/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.EncodedTaskRunRequest;
import com.microsoft.azure.management.containerregistry.OverridingValue;
import com.microsoft.azure.management.containerregistry.PlatformProperties;
import com.microsoft.azure.management.containerregistry.RegistryEncodedTaskRunRequest;
import com.microsoft.azure.management.containerregistry.SetValue;
import com.microsoft.azure.management.containerregistry.implementation.RegistryTaskRunImpl;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Map;

@LangDefinition
class RegistryEncodedTaskRunRequestImpl
implements RegistryEncodedTaskRunRequest,
RegistryEncodedTaskRunRequest.Definition,
HasInner<EncodedTaskRunRequest> {
    private EncodedTaskRunRequest inner = new EncodedTaskRunRequest();
    private RegistryTaskRunImpl registryTaskRunImpl;

    @Override
    public int timeout() {
        return Utils.toPrimitiveInt((Integer)this.inner.timeout());
    }

    @Override
    public PlatformProperties platform() {
        return this.inner.platform();
    }

    @Override
    public int cpuCount() {
        if (this.inner.agentConfiguration() == null) {
            return 0;
        }
        return Utils.toPrimitiveInt((Integer)this.inner.agentConfiguration().cpu());
    }

    @Override
    public String sourceLocation() {
        return this.inner.sourceLocation();
    }

    @Override
    public boolean isArchiveEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)this.inner.isArchiveEnabled());
    }

    RegistryEncodedTaskRunRequestImpl(RegistryTaskRunImpl registryTaskRunImpl) {
        this.registryTaskRunImpl = registryTaskRunImpl;
    }

    @Override
    public RegistryEncodedTaskRunRequestImpl defineEncodedTaskStep() {
        return this;
    }

    @Override
    public RegistryEncodedTaskRunRequestImpl withBase64EncodedTaskContent(String encodedTaskContent) {
        this.inner.withEncodedTaskContent(encodedTaskContent);
        return this;
    }

    @Override
    public RegistryEncodedTaskRunRequestImpl withBase64EncodedValueContent(String encodedValueContent) {
        this.inner.withEncodedValuesContent(encodedValueContent);
        return this;
    }

    @Override
    public RegistryEncodedTaskRunRequestImpl withOverridingValues(Map<String, OverridingValue> overridingValues) {
        if (overridingValues.size() == 0) {
            return this;
        }
        ArrayList<SetValue> overridingValuesList = new ArrayList<SetValue>();
        for (Map.Entry<String, OverridingValue> entry : overridingValues.entrySet()) {
            SetValue value = new SetValue();
            value.withName(entry.getKey());
            value.withValue(entry.getValue().value());
            value.withIsSecret(entry.getValue().isSecret());
            overridingValuesList.add(value);
        }
        this.inner.withValues(overridingValuesList);
        return this;
    }

    @Override
    public RegistryEncodedTaskRunRequestImpl withOverridingValue(String name, OverridingValue overridingValue) {
        if (this.inner.values() == null) {
            this.inner.withValues(new ArrayList<SetValue>());
        }
        SetValue value = new SetValue();
        value.withName(name);
        value.withValue(overridingValue.value());
        value.withIsSecret(overridingValue.isSecret());
        this.inner.values().add(value);
        return this;
    }

    public RegistryTaskRunImpl attach() {
        this.registryTaskRunImpl.withEncodedTaskRunRequest(this.inner);
        return this.registryTaskRunImpl;
    }

    public EncodedTaskRunRequest inner() {
        return this.inner;
    }
}

