/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.containerregistry.implementation.OperationsInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistriesInner;
import com.microsoft.azure.management.containerregistry.implementation.ReplicationsInner;
import com.microsoft.azure.management.containerregistry.implementation.RunsInner;
import com.microsoft.azure.management.containerregistry.implementation.TasksInner;
import com.microsoft.azure.management.containerregistry.implementation.WebhooksInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class ContainerRegistryManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private RegistriesInner registries;
    private OperationsInner operations;
    private ReplicationsInner replications;
    private WebhooksInner webhooks;
    private RunsInner runs;
    private TasksInner tasks;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ContainerRegistryManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public ContainerRegistryManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public ContainerRegistryManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public ContainerRegistryManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public RegistriesInner registries() {
        return this.registries;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public ReplicationsInner replications() {
        return this.replications;
    }

    public WebhooksInner webhooks() {
        return this.webhooks;
    }

    public RunsInner runs() {
        return this.runs;
    }

    public TasksInner tasks() {
        return this.tasks;
    }

    public ContainerRegistryManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public ContainerRegistryManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public ContainerRegistryManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.registries = new RegistriesInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.replications = new ReplicationsInner(this.restClient().retrofit(), this);
        this.webhooks = new WebhooksInner(this.restClient().retrofit(), this);
        this.runs = new RunsInner(this.restClient().retrofit(), this);
        this.tasks = new TasksInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "ContainerRegistryManagementClient");
    }
}

