/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batchai.JobCreateParameters;
import com.microsoft.azure.management.batchai.JobsListByExperimentOptions;
import com.microsoft.azure.management.batchai.JobsListOutputFilesOptions;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.FileInner;
import com.microsoft.azure.management.batchai.implementation.JobInner;
import com.microsoft.azure.management.batchai.implementation.PageImpl;
import com.microsoft.azure.management.batchai.implementation.RemoteLoginInformationInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobsInner {
    private JobsService service;
    private BatchAIManagementClientImpl client;

    public JobsInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = (JobsService)retrofit.create(JobsService.class);
        this.client = client;
    }

    public PagedList<JobInner> listByExperiment(String resourceGroupName, String workspaceName, String experimentName) {
        ServiceResponse response = (ServiceResponse)this.listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listByExperimentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listByExperimentAsync(String resourceGroupName, String workspaceName, String experimentName, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listByExperimentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listByExperimentAsync(String resourceGroupName, String workspaceName, String experimentName) {
        return this.listByExperimentWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName) {
        return this.listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listByExperimentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentSinglePageAsync(String resourceGroupName, String workspaceName, String experimentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobsListByExperimentOptions = null;
        Integer maxResults = null;
        return this.service.listByExperiment(resourceGroupName, workspaceName, experimentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listByExperimentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<JobInner> listByExperiment(String resourceGroupName, String workspaceName, String experimentName, JobsListByExperimentOptions jobsListByExperimentOptions) {
        ServiceResponse response = (ServiceResponse)this.listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobsListByExperimentOptions).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listByExperimentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listByExperimentAsync(String resourceGroupName, String workspaceName, String experimentName, JobsListByExperimentOptions jobsListByExperimentOptions, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobsListByExperimentOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listByExperimentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listByExperimentAsync(String resourceGroupName, String workspaceName, String experimentName, JobsListByExperimentOptions jobsListByExperimentOptions) {
        return this.listByExperimentWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobsListByExperimentOptions).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, JobsListByExperimentOptions jobsListByExperimentOptions) {
        return this.listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobsListByExperimentOptions).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listByExperimentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentSinglePageAsync(String resourceGroupName, String workspaceName, String experimentName, JobsListByExperimentOptions jobsListByExperimentOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobsListByExperimentOptions);
        Integer maxResults = null;
        if (jobsListByExperimentOptions != null) {
            maxResults = jobsListByExperimentOptions.maxResults();
        }
        return this.service.listByExperiment(resourceGroupName, workspaceName, experimentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listByExperimentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobInner>> listByExperimentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobInner create(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        return (JobInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<JobInner> createAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters, ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters), serviceCallback);
    }

    public Observable<JobInner> createAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters).map((Func1)new Func1<ServiceResponse<JobInner>, JobInner>(){

            public JobInner call(ServiceResponse<JobInner> response) {
                return (JobInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobInner>> createWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobInner>(){}.getType());
    }

    public JobInner beginCreate(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        return (JobInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<JobInner> beginCreateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters, ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters), serviceCallback);
    }

    public Observable<JobInner> beginCreateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters).map((Func1)new Func1<ServiceResponse<JobInner>, JobInner>(){

            public JobInner call(ServiceResponse<JobInner> response) {
                return (JobInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>(){

            public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobInner get(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return (JobInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().single()).body());
    }

    public ServiceFuture<JobInner> getAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    public Observable<JobInner> getAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return this.getWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map((Func1)new Func1<ServiceResponse<JobInner>, JobInner>(){

            public JobInner call(ServiceResponse<JobInner> response) {
                return (JobInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobInner>> getWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>(){

            public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileInner> listOutputFiles(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobsListOutputFilesOptions jobsListOutputFilesOptions) {
        ServiceResponse response = (ServiceResponse)this.listOutputFilesSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName, jobsListOutputFilesOptions).toBlocking().single();
        return new PagedList<FileInner>((Page)response.body()){

            public Page<FileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileInner>> listOutputFilesAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobsListOutputFilesOptions jobsListOutputFilesOptions, ListOperationCallback<FileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOutputFilesSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName, jobsListOutputFilesOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(String nextPageLink) {
                return JobsInner.this.listOutputFilesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileInner>> listOutputFilesAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobsListOutputFilesOptions jobsListOutputFilesOptions) {
        return this.listOutputFilesWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, jobsListOutputFilesOptions).map((Func1)new Func1<ServiceResponse<Page<FileInner>>, Page<FileInner>>(){

            public Page<FileInner> call(ServiceResponse<Page<FileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobsListOutputFilesOptions jobsListOutputFilesOptions) {
        return this.listOutputFilesSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName, jobsListOutputFilesOptions).concatMap((Func1)new Func1<ServiceResponse<Page<FileInner>>, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(ServiceResponse<Page<FileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listOutputFilesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesSinglePageAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobsListOutputFilesOptions jobsListOutputFilesOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (jobsListOutputFilesOptions == null) {
            throw new IllegalArgumentException("Parameter jobsListOutputFilesOptions is required and cannot be null.");
        }
        Validator.validate((Object)jobsListOutputFilesOptions);
        String outputdirectoryid = jobsListOutputFilesOptions.outputdirectoryid();
        String directory = jobsListOutputFilesOptions.directory();
        Integer linkexpiryinminutes = jobsListOutputFilesOptions.linkexpiryinminutes();
        Integer maxResults = jobsListOutputFilesOptions.maxResults();
        return this.service.listOutputFiles(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), outputdirectoryid, directory, linkexpiryinminutes, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listOutputFilesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileInner>> listOutputFilesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformation(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        ServiceResponse response = (ServiceResponse)this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>((Page)response.body()){

            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                return JobsInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return this.listRemoteLoginInformationWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>(){

            public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName).concatMap((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationSinglePageAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listRemoteLoginInformation(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listRemoteLoginInformationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void terminate(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        ((ServiceResponse)this.terminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> terminateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.terminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    public Observable<Void> terminateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return this.terminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> terminateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.terminate(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginTerminate(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        ((ServiceResponse)this.beginTerminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginTerminateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginTerminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    public Observable<Void> beginTerminateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return this.beginTerminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginTerminateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginTerminate(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.beginTerminateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginTerminateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobInner> listByExperimentNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByExperimentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listByExperimentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listByExperimentNextAsync(String nextPageLink, ServiceFuture<List<JobInner>> serviceFuture, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByExperimentNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listByExperimentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listByExperimentNextAsync(String nextPageLink) {
        return this.listByExperimentNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByExperimentNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listByExperimentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByExperimentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listByExperimentNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobInner>> listByExperimentNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileInner> listOutputFilesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FileInner>((Page)response.body()){

            public Page<FileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileInner>> listOutputFilesNextAsync(String nextPageLink, ServiceFuture<List<FileInner>> serviceFuture, ListOperationCallback<FileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOutputFilesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(String nextPageLink) {
                return JobsInner.this.listOutputFilesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileInner>> listOutputFilesNextAsync(String nextPageLink) {
        return this.listOutputFilesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FileInner>>, Page<FileInner>>(){

            public Page<FileInner> call(ServiceResponse<Page<FileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listOutputFilesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FileInner>>, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(ServiceResponse<Page<FileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listOutputFilesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listOutputFilesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listOutputFilesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileInner>> listOutputFilesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformationNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>((Page)response.body()){

            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(String nextPageLink, ServiceFuture<List<RemoteLoginInformationInner>> serviceFuture, ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                return JobsInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(String nextPageLink) {
        return this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>(){

            public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextWithServiceResponseAsync(String nextPageLink) {
        return this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listRemoteLoginInformationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listRemoteLoginInformationNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listByExperiment"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs")
        public Observable<Response<ResponseBody>> listByExperiment(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Query(value="maxresults") Integer var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Body JobCreateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Body JobCreateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listOutputFiles"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/listOutputFiles")
        public Observable<Response<ResponseBody>> listOutputFiles(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Query(value="outputdirectoryid") String var8, @Query(value="directory") String var9, @Query(value="linkexpiryinminutes") Integer var10, @Query(value="maxresults") Integer var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listRemoteLoginInformation"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/listRemoteLoginInformation")
        public Observable<Response<ResponseBody>> listRemoteLoginInformation(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs terminate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/terminate")
        public Observable<Response<ResponseBody>> terminate(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginTerminate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/terminate")
        public Observable<Response<ResponseBody>> beginTerminate(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listByExperimentNext"})
        @GET
        public Observable<Response<ResponseBody>> listByExperimentNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listOutputFilesNext"})
        @GET
        public Observable<Response<ResponseBody>> listOutputFilesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listRemoteLoginInformationNext"})
        @GET
        public Observable<Response<ResponseBody>> listRemoteLoginInformationNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

