/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batchai.ExperimentsListByWorkspaceOptions;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.ExperimentInner;
import com.microsoft.azure.management.batchai.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ExperimentsInner {
    private ExperimentsService service;
    private BatchAIManagementClientImpl client;

    public ExperimentsInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = (ExperimentsService)retrofit.create(ExperimentsService.class);
        this.client = client;
    }

    public PagedList<ExperimentInner> listByWorkspace(String resourceGroupName, String workspaceName) {
        ServiceResponse response = (ServiceResponse)this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName).toBlocking().single();
        return new PagedList<ExperimentInner>((Page)response.body()){

            public Page<ExperimentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExperimentsInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExperimentInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName, ListOperationCallback<ExperimentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExperimentInner>>>>(){

            public Observable<ServiceResponse<Page<ExperimentInner>>> call(String nextPageLink) {
                return ExperimentsInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExperimentInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName) {
        return this.listByWorkspaceWithServiceResponseAsync(resourceGroupName, workspaceName).map((Func1)new Func1<ServiceResponse<Page<ExperimentInner>>, Page<ExperimentInner>>(){

            public Page<ExperimentInner> call(ServiceResponse<Page<ExperimentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExperimentInner>>> listByWorkspaceWithServiceResponseAsync(String resourceGroupName, String workspaceName) {
        return this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName).concatMap((Func1)new Func1<ServiceResponse<Page<ExperimentInner>>, Observable<ServiceResponse<Page<ExperimentInner>>>>(){

            public Observable<ServiceResponse<Page<ExperimentInner>>> call(ServiceResponse<Page<ExperimentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExperimentsInner.this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExperimentInner>>> listByWorkspaceSinglePageAsync(String resourceGroupName, String workspaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object experimentsListByWorkspaceOptions = null;
        Integer maxResults = null;
        return this.service.listByWorkspace(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExperimentInner>>>>(){

            public Observable<ServiceResponse<Page<ExperimentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExperimentsInner.this.listByWorkspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ExperimentInner> listByWorkspace(String resourceGroupName, String workspaceName, ExperimentsListByWorkspaceOptions experimentsListByWorkspaceOptions) {
        ServiceResponse response = (ServiceResponse)this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, experimentsListByWorkspaceOptions).toBlocking().single();
        return new PagedList<ExperimentInner>((Page)response.body()){

            public Page<ExperimentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExperimentsInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExperimentInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName, ExperimentsListByWorkspaceOptions experimentsListByWorkspaceOptions, ListOperationCallback<ExperimentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, experimentsListByWorkspaceOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExperimentInner>>>>(){

            public Observable<ServiceResponse<Page<ExperimentInner>>> call(String nextPageLink) {
                return ExperimentsInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExperimentInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName, ExperimentsListByWorkspaceOptions experimentsListByWorkspaceOptions) {
        return this.listByWorkspaceWithServiceResponseAsync(resourceGroupName, workspaceName, experimentsListByWorkspaceOptions).map((Func1)new Func1<ServiceResponse<Page<ExperimentInner>>, Page<ExperimentInner>>(){

            public Page<ExperimentInner> call(ServiceResponse<Page<ExperimentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExperimentInner>>> listByWorkspaceWithServiceResponseAsync(String resourceGroupName, String workspaceName, ExperimentsListByWorkspaceOptions experimentsListByWorkspaceOptions) {
        return this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, experimentsListByWorkspaceOptions).concatMap((Func1)new Func1<ServiceResponse<Page<ExperimentInner>>, Observable<ServiceResponse<Page<ExperimentInner>>>>(){

            public Observable<ServiceResponse<Page<ExperimentInner>>> call(ServiceResponse<Page<ExperimentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExperimentsInner.this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExperimentInner>>> listByWorkspaceSinglePageAsync(String resourceGroupName, String workspaceName, ExperimentsListByWorkspaceOptions experimentsListByWorkspaceOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)experimentsListByWorkspaceOptions);
        Integer maxResults = null;
        if (experimentsListByWorkspaceOptions != null) {
            maxResults = experimentsListByWorkspaceOptions.maxResults();
        }
        return this.service.listByWorkspace(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExperimentInner>>>>(){

            public Observable<ServiceResponse<Page<ExperimentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExperimentsInner.this.listByWorkspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExperimentInner>> listByWorkspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExperimentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExperimentInner create(String resourceGroupName, String workspaceName, String experimentName) {
        return (ExperimentInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).toBlocking().last()).body());
    }

    public ServiceFuture<ExperimentInner> createAsync(String resourceGroupName, String workspaceName, String experimentName, ServiceCallback<ExperimentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName), serviceCallback);
    }

    public Observable<ExperimentInner> createAsync(String resourceGroupName, String workspaceName, String experimentName) {
        return this.createWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).map((Func1)new Func1<ServiceResponse<ExperimentInner>, ExperimentInner>(){

            public ExperimentInner call(ServiceResponse<ExperimentInner> response) {
                return (ExperimentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExperimentInner>> createWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, workspaceName, experimentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ExperimentInner>(){}.getType());
    }

    public ExperimentInner beginCreate(String resourceGroupName, String workspaceName, String experimentName) {
        return (ExperimentInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).toBlocking().single()).body());
    }

    public ServiceFuture<ExperimentInner> beginCreateAsync(String resourceGroupName, String workspaceName, String experimentName, ServiceCallback<ExperimentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName), serviceCallback);
    }

    public Observable<ExperimentInner> beginCreateAsync(String resourceGroupName, String workspaceName, String experimentName) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).map((Func1)new Func1<ServiceResponse<ExperimentInner>, ExperimentInner>(){

            public ExperimentInner call(ServiceResponse<ExperimentInner> response) {
                return (ExperimentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExperimentInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginCreate(resourceGroupName, workspaceName, experimentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExperimentInner>>>(){

            public Observable<ServiceResponse<ExperimentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExperimentsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExperimentInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExperimentInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String workspaceName, String experimentName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String workspaceName, String experimentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String workspaceName, String experimentName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, workspaceName, experimentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String workspaceName, String experimentName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String experimentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String experimentName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, workspaceName, experimentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExperimentsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExperimentInner get(String resourceGroupName, String workspaceName, String experimentName) {
        return (ExperimentInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).toBlocking().single()).body());
    }

    public ServiceFuture<ExperimentInner> getAsync(String resourceGroupName, String workspaceName, String experimentName, ServiceCallback<ExperimentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName), serviceCallback);
    }

    public Observable<ExperimentInner> getAsync(String resourceGroupName, String workspaceName, String experimentName) {
        return this.getWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName).map((Func1)new Func1<ServiceResponse<ExperimentInner>, ExperimentInner>(){

            public ExperimentInner call(ServiceResponse<ExperimentInner> response) {
                return (ExperimentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExperimentInner>> getWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, workspaceName, experimentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExperimentInner>>>(){

            public Observable<ServiceResponse<ExperimentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExperimentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExperimentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExperimentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExperimentInner> listByWorkspaceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ExperimentInner>((Page)response.body()){

            public Page<ExperimentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExperimentsInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExperimentInner>> listByWorkspaceNextAsync(String nextPageLink, ServiceFuture<List<ExperimentInner>> serviceFuture, ListOperationCallback<ExperimentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByWorkspaceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExperimentInner>>>>(){

            public Observable<ServiceResponse<Page<ExperimentInner>>> call(String nextPageLink) {
                return ExperimentsInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExperimentInner>> listByWorkspaceNextAsync(String nextPageLink) {
        return this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ExperimentInner>>, Page<ExperimentInner>>(){

            public Page<ExperimentInner> call(ServiceResponse<Page<ExperimentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExperimentInner>>> listByWorkspaceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByWorkspaceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ExperimentInner>>, Observable<ServiceResponse<Page<ExperimentInner>>>>(){

            public Observable<ServiceResponse<Page<ExperimentInner>>> call(ServiceResponse<Page<ExperimentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExperimentsInner.this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExperimentInner>>> listByWorkspaceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByWorkspaceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExperimentInner>>>>(){

            public Observable<ServiceResponse<Page<ExperimentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExperimentsInner.this.listByWorkspaceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExperimentInner>> listByWorkspaceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExperimentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ExperimentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Experiments listByWorkspace"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments")
        public Observable<Response<ResponseBody>> listByWorkspace(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="maxresults") Integer var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Experiments create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Experiments beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Experiments delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Experiments beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Experiments get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="experimentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Experiments listByWorkspaceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByWorkspaceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

