/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAICluster;
import com.microsoft.azure.management.batchai.BatchAIClusters;
import com.microsoft.azure.management.batchai.BatchAIWorkspace;
import com.microsoft.azure.management.batchai.implementation.BatchAIClusterImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.BatchAIWorkspaceImpl;
import com.microsoft.azure.management.batchai.implementation.ClusterInner;
import com.microsoft.azure.management.batchai.implementation.ClustersInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class BatchAIClustersImpl
extends CreatableResourcesImpl<BatchAICluster, BatchAIClusterImpl, ClusterInner>
implements BatchAIClusters {
    private final BatchAIWorkspaceImpl workspace;

    BatchAIClustersImpl(BatchAIWorkspaceImpl workspace) {
        this.workspace = workspace;
    }

    public BatchAIClusterImpl define(String name) {
        return this.wrapModel(name);
    }

    protected BatchAIClusterImpl wrapModel(String name) {
        ClusterInner inner = new ClusterInner();
        return new BatchAIClusterImpl(name, this.workspace, inner);
    }

    protected BatchAIClusterImpl wrapModel(ClusterInner inner) {
        if (inner == null) {
            return null;
        }
        return new BatchAIClusterImpl(inner.name(), this.workspace, inner);
    }

    public PagedList<BatchAICluster> list() {
        return this.wrapList(this.inner().listByWorkspace(this.workspace.resourceGroupName(), this.workspace.name()));
    }

    public Observable<BatchAICluster> listAsync() {
        return this.wrapPageAsync(this.inner().listByWorkspaceAsync(this.workspace.resourceGroupName(), this.workspace.name()));
    }

    public BatchAIWorkspace parent() {
        return this.workspace;
    }

    public BatchAIClusterImpl getById(String id) {
        return (BatchAIClusterImpl)this.getByIdAsync(id).toBlocking().single();
    }

    public Observable<BatchAICluster> getByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().getAsync(resourceId.resourceGroupName(), this.workspace.name(), resourceId.name()).map((Func1)new Func1<ClusterInner, BatchAICluster>(){

            public BatchAICluster call(ClusterInner innerT) {
                return BatchAIClustersImpl.this.wrapModel(innerT);
            }
        });
    }

    public ServiceFuture<BatchAICluster> getByIdAsync(String id, ServiceCallback<BatchAICluster> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    public BatchAIManager manager() {
        return (BatchAIManager)this.workspace.manager();
    }

    public Completable deleteByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().deleteAsync(resourceId.resourceGroupName(), this.workspace.name(), resourceId.name()).toCompletable();
    }

    public ClustersInner inner() {
        return ((BatchAIManagementClientImpl)((Object)this.manager().inner())).clusters();
    }

    public Observable<BatchAICluster> getByNameAsync(String name) {
        return this.inner().getAsync(this.workspace.resourceGroupName(), this.workspace.name(), name).map((Func1)new Func1<ClusterInner, BatchAICluster>(){

            public BatchAICluster call(ClusterInner innerT) {
                return BatchAIClustersImpl.this.wrapModel(innerT);
            }
        });
    }

    public BatchAIClusterImpl getByName(String name) {
        return (BatchAIClusterImpl)this.getByNameAsync(name).toBlocking().single();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ServiceFuture.fromResponse(this.inner().deleteWithServiceResponseAsync(this.workspace.resourceGroupName(), this.workspace.name(), name), callback);
    }

    public Completable deleteByNameAsync(String name) {
        return this.inner().deleteAsync(this.workspace.resourceGroupName(), this.workspace.name(), name).toCompletable();
    }
}

