/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils.functioncache;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.functions.utils.functioncache.FunctionClassLoaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionCacheEntry
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionCacheEntry.class);
    public static final String JAVA_INSTANCE_JAR_PROPERTY = "pulsar.functions.java.instance.jar";
    private final URLClassLoader classLoader;
    private final Set<String> executionHolders;
    private final Set<String> jarFiles;
    private final Set<String> classpaths;

    FunctionCacheEntry(Collection<String> requiredJarFiles, Collection<URL> requiredClasspaths, URL[] libraryURLs, String initialInstanceId, ClassLoader rootClassLoader) {
        this.classLoader = FunctionClassLoaders.create(libraryURLs, rootClassLoader);
        this.classpaths = requiredClasspaths.stream().map(URL::toString).collect(Collectors.toSet());
        this.jarFiles = new HashSet<String>(requiredJarFiles);
        this.executionHolders = new HashSet<String>(Collections.singleton(initialInstanceId));
    }

    FunctionCacheEntry(String narArchive, String initialInstanceId, ClassLoader rootClassLoader, String narExtractionDirectory) throws IOException {
        this.classLoader = NarClassLoaderBuilder.builder().narFile(new File(narArchive)).extractionDirectory(narExtractionDirectory).parentClassLoader(rootClassLoader).build();
        this.classpaths = Collections.emptySet();
        this.jarFiles = Collections.singleton(narArchive);
        this.executionHolders = new HashSet<String>(Collections.singleton(initialInstanceId));
    }

    boolean isInstanceRegistered(String iid) {
        return this.executionHolders.contains(iid);
    }

    public void register(String eid, Collection<String> requiredJarFiles, Collection<URL> requiredClassPaths) {
        if (this.jarFiles.size() != requiredJarFiles.size() || !new HashSet<String>(requiredJarFiles).containsAll(this.jarFiles)) {
            throw new IllegalStateException("The function registration references a different set of jar files than  previous registrations for this function : old = " + String.valueOf(this.jarFiles) + ", new = " + String.valueOf(requiredJarFiles));
        }
        if (this.classpaths.size() != requiredClassPaths.size() || !requiredClassPaths.stream().map(URL::toString).collect(Collectors.toSet()).containsAll(this.classpaths)) {
            throw new IllegalStateException("The function registration references a different set of classpaths than  previous registrations for this function : old = " + String.valueOf(this.classpaths) + ", new = " + String.valueOf(requiredClassPaths));
        }
        this.executionHolders.add(eid);
    }

    public boolean unregister(String eid) {
        this.executionHolders.remove(eid);
        return this.executionHolders.isEmpty();
    }

    @Override
    public void close() {
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to release function code class loader for " + Arrays.toString(this.jarFiles.toArray()));
        }
    }

    @Generated
    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public Set<String> getJarFiles() {
        return this.jarFiles;
    }
}

