/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.windowing.evictors;

import lombok.Generated;
import org.apache.pulsar.functions.windowing.Event;
import org.apache.pulsar.functions.windowing.EvictionContext;
import org.apache.pulsar.functions.windowing.EvictionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeEvictionPolicy<T>
implements EvictionPolicy<T, EvictionContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeEvictionPolicy.class);
    private final long windowLength;
    protected volatile EvictionContext evictionContext;
    private long delta;

    public TimeEvictionPolicy(long windowLength) {
        this.windowLength = windowLength;
    }

    @Override
    public EvictionPolicy.Action evict(Event<T> event) {
        long now = this.evictionContext == null ? System.currentTimeMillis() : this.evictionContext.getReferenceTime();
        long diff = now - event.getTimestamp();
        if (diff >= this.windowLength + this.delta) {
            return EvictionPolicy.Action.EXPIRE;
        }
        if (diff < 0L) {
            return EvictionPolicy.Action.KEEP;
        }
        return EvictionPolicy.Action.PROCESS;
    }

    @Override
    public void track(Event<T> event) {
    }

    @Override
    public void setContext(EvictionContext context) {
        EvictionContext prevContext = this.evictionContext;
        this.evictionContext = context;
        if (context.getSlidingInterval() != null) {
            if (prevContext == null) {
                this.delta = Integer.MAX_VALUE;
            } else {
                this.delta = context.getReferenceTime() - prevContext.getReferenceTime() - context.getSlidingInterval();
                if (Math.abs(this.delta) > 100L) {
                    log.warn(String.format("Possible clock drift or long running computation in window; Previous eviction time: %s, current eviction time: %s", prevContext.getReferenceTime(), context.getReferenceTime()));
                }
            }
        }
    }

    @Override
    public EvictionContext getContext() {
        return this.evictionContext;
    }

    @Override
    public void reset() {
    }

    @Override
    public EvictionContext getState() {
        return this.evictionContext;
    }

    @Override
    public void restoreState(EvictionContext state) {
        this.evictionContext = state;
    }

    public String toString() {
        return "TimeEvictionPolicy{windowLength=" + this.windowLength + ", evictionContext=" + this.evictionContext + "}";
    }
}

