/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import lombok.Generated;
import lombok.NonNull;
import org.apache.pulsar.client.api.MessagePayload;

public class MessagePayloadImpl
implements MessagePayload {
    private static final Recycler<MessagePayloadImpl> RECYCLER = new Recycler<MessagePayloadImpl>(){

        protected MessagePayloadImpl newObject(Recycler.Handle<MessagePayloadImpl> handle) {
            return new MessagePayloadImpl(handle);
        }
    };
    private final Recycler.Handle<MessagePayloadImpl> recyclerHandle;
    private ByteBuf byteBuf;

    public static MessagePayloadImpl create(@NonNull ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("byteBuf is marked non-null but is null");
        }
        MessagePayloadImpl payload = (MessagePayloadImpl)RECYCLER.get();
        payload.byteBuf = byteBuf;
        return payload;
    }

    private MessagePayloadImpl(Recycler.Handle<MessagePayloadImpl> handle) {
        this.recyclerHandle = handle;
    }

    public void release() {
        ReferenceCountUtil.release((Object)this.byteBuf);
        this.byteBuf = null;
        this.recyclerHandle.recycle((Object)this);
    }

    public byte[] copiedBuffer() {
        int readable = this.byteBuf.readableBytes();
        if (readable > 0) {
            byte[] bytes = new byte[readable];
            this.byteBuf.getBytes(this.byteBuf.readerIndex(), bytes);
            return bytes;
        }
        return new byte[0];
    }

    @Generated
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }
}

