/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import javax.portlet.MutableResourceParameters;
import javax.portlet.ResourceURL;
import org.apache.pluto.container.PortletMimeResponseContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.impl.BaseURLImpl;
import org.apache.pluto.container.impl.MutableResourceParametersImpl;
import org.apache.pluto.container.util.ArgumentUtility;

public class ResourceURLImpl
extends BaseURLImpl
implements ResourceURL {
    private String cacheLevel = "cacheLevelPage";

    public ResourceURLImpl(PortletMimeResponseContext responseContext) {
        super((PortletResponseContext)responseContext, responseContext.getPortletURLProvider(PortletURLProvider.TYPE.RESOURCE));
    }

    public ResourceURLImpl(PortletMimeResponseContext responseContext, String cacheLevel) {
        this(responseContext);
        if (cacheLevel != null) {
            this.cacheLevel = cacheLevel;
        }
        this.urlProvider.setCacheability(this.cacheLevel);
    }

    public String getCacheability() {
        return this.urlProvider.getCacheability();
    }

    public void setCacheability(String cacheLevel) {
        ArgumentUtility.validateNotEmpty("cachelevel", cacheLevel);
        if (!"cacheLevelFull".equals(cacheLevel)) {
            if ("cacheLevelPortlet".equals(cacheLevel)) {
                if ("cacheLevelFull".equals(this.cacheLevel)) {
                    throw new IllegalStateException("Current request cacheablility is FULL: URLs with cacheability PORTLET not allowed");
                }
            } else if ("cacheLevelPage".equals(cacheLevel)) {
                if ("cacheLevelFull".equals(this.cacheLevel)) {
                    throw new IllegalStateException("Current request cacheablility is FULL: URLs with cacheability PORTLET not allowed");
                }
                if ("cacheLevelPortlet".equals(this.cacheLevel)) {
                    throw new IllegalStateException("Current request cacheablility is PORTLET: URLs with cacheability PAGE not allowed");
                }
            } else {
                throw new IllegalArgumentException("Unknown cacheLevel: " + cacheLevel);
            }
        }
        this.urlProvider.setCacheability(cacheLevel);
    }

    public void setResourceID(String resourceID) {
        this.urlProvider.setResourceID(resourceID);
    }

    public MutableResourceParameters getResourceParameters() {
        return new MutableResourceParametersImpl(this.urlProvider, this.windowId);
    }

    public String getResourceID() {
        return this.urlProvider.getResourceID();
    }
}

