/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.portlet.PortletSessionUtil;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.util.ArgumentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletSessionImpl
implements PortletSession {
    private static final Logger LOG = LoggerFactory.getLogger(PortletSessionImpl.class);
    protected static final int DEFAULT_SCOPE = 2;
    protected static final String PORTLET_SCOPE_NAMESPACE = "javax.portlet.p.";
    protected static final char ID_NAME_SEPARATOR = '?';
    private HttpSession httpSession;
    private PortletContext portletContext;
    private PortletWindow portletWindow;

    public PortletSessionImpl(PortletContext portletContext, PortletWindow portletWindow, HttpSession httpSession) {
        this.portletContext = portletContext;
        this.portletWindow = portletWindow;
        this.httpSession = httpSession;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int scope) {
        ArgumentUtility.validateNotNull("attributeName", name);
        String key = scope == 1 ? name : this.createPortletScopedId(name);
        return this.httpSession.getAttribute(key);
    }

    public Enumeration<String> getAttributeNames() {
        return this.getAttributeNames(2);
    }

    public Enumeration<String> getAttributeNames(int scope) {
        if (scope == 1) {
            return this.httpSession.getAttributeNames();
        }
        Vector<String> portletScopedNames = new Vector<String>();
        Enumeration en = this.httpSession.getAttributeNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!this.isInCurrentPortletScope(name)) continue;
            portletScopedNames.add(PortletSessionUtil.decodeAttributeName((String)name));
        }
        return portletScopedNames.elements();
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) {
        ArgumentUtility.validateNotNull("attributeName", name);
        if (scope == 1) {
            this.httpSession.removeAttribute(name);
        } else {
            this.httpSession.removeAttribute(this.createPortletScopedId(name));
        }
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void setAttribute(String name, Object value, int scope) {
        ArgumentUtility.validateNotNull("attributeName", name);
        if (scope == 1) {
            this.httpSession.setAttribute(name, value);
        } else {
            this.httpSession.setAttribute(this.createPortletScopedId(name), value);
        }
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public long getCreationTime() {
        return this.httpSession.getCreationTime();
    }

    public String getId() {
        return this.httpSession.getId();
    }

    public long getLastAccessedTime() {
        return this.httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    public void invalidate() {
        this.httpSession.invalidate();
    }

    public boolean isNew() {
        return this.httpSession.isNew();
    }

    public void setMaxInactiveInterval(int interval) {
        this.httpSession.setMaxInactiveInterval(interval);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session timeout set to: " + interval);
        }
    }

    protected String createPortletScopedId(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PORTLET_SCOPE_NAMESPACE);
        buffer.append(this.portletWindow.getId().getStringId());
        buffer.append('?');
        buffer.append(name);
        return buffer.toString();
    }

    protected boolean isInCurrentPortletScope(String name) {
        if (name.startsWith(PORTLET_SCOPE_NAMESPACE) && name.indexOf(63) > -1) {
            String id = name.substring(PORTLET_SCOPE_NAMESPACE.length(), name.indexOf(63));
            return id.equals(this.portletWindow.getId().getStringId());
        }
        return false;
    }

    public Map<String, Object> getMap() {
        List<String> paramNames = this.getAttributeNamesAsList(2);
        return this.fillMap(paramNames, 2);
    }

    public Map<String, Object> getMap(int scope) {
        List<String> paramNames = this.getAttributeNamesAsList(scope);
        return this.fillMap(paramNames, scope);
    }

    private List<String> getAttributeNamesAsList(int scope) {
        ArrayList<String> paramNames = new ArrayList<String>();
        Enumeration<String> e = this.getAttributeNames(scope);
        while (e.hasMoreElements()) {
            paramNames.add(e.nextElement());
        }
        return paramNames;
    }

    private Map<String, Object> fillMap(List<String> paramNames, int scope) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String string : paramNames) {
            resultMap.put(string, this.getAttribute(string, scope));
        }
        return resultMap;
    }

    public Map<String, Object> getAttributeMap(int scope) {
        return this.getMap(scope);
    }

    public Map<String, Object> getAttributeMap() {
        return this.getMap();
    }
}

