/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CompoundBloomFilterBase;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.BloomFilterChunk;
import org.apache.hadoop.hbase.util.BloomFilterUtil;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CompoundBloomFilterWriter
extends CompoundBloomFilterBase
implements BloomFilterWriter,
InlineBlockWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CompoundBloomFilterWriter.class);
    private BloomFilterChunk chunk;
    private BloomFilterChunk prevChunk;
    private int maxFold;
    private int chunkByteSize;
    private Cell prevCell;
    private Queue<ReadyChunk> readyChunks = new LinkedList<ReadyChunk>();
    private byte[] firstKeyInChunk = null;
    private HFileBlockIndex.BlockIndexWriter bloomBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter();
    private boolean cacheOnWrite;
    private BloomType bloomType;

    public CompoundBloomFilterWriter(int chunkByteSizeHint, float errorRate, int hashType, int maxFold, boolean cacheOnWrite, CellComparator comparator, BloomType bloomType) {
        this.chunkByteSize = BloomFilterUtil.computeFoldableByteSize((long)chunkByteSizeHint * 8L, maxFold);
        this.errorRate = errorRate;
        this.hashType = hashType;
        this.maxFold = maxFold;
        this.cacheOnWrite = cacheOnWrite;
        this.comparator = comparator;
        this.bloomType = bloomType;
    }

    @Override
    public boolean shouldWriteBlock(boolean closing) {
        this.enqueueReadyChunk(closing);
        return !this.readyChunks.isEmpty();
    }

    private void enqueueReadyChunk(boolean closing) {
        if (this.chunk == null || this.chunk.getKeyCount() < this.chunk.getMaxKeys() && !closing) {
            return;
        }
        if (this.firstKeyInChunk == null) {
            throw new NullPointerException("Trying to enqueue a chunk, but first key is null: closing=" + closing + ", keyCount=" + this.chunk.getKeyCount() + ", maxKeys=" + this.chunk.getMaxKeys());
        }
        ReadyChunk readyChunk = new ReadyChunk();
        readyChunk.chunkId = this.numChunks - 1;
        readyChunk.chunk = this.chunk;
        readyChunk.firstKey = this.firstKeyInChunk;
        this.readyChunks.add(readyChunk);
        long prevMaxKeys = this.chunk.getMaxKeys();
        long prevByteSize = this.chunk.getByteSize();
        this.chunk.compactBloom();
        if (LOG.isTraceEnabled() && prevByteSize != this.chunk.getByteSize()) {
            LOG.trace("Compacted Bloom chunk #" + readyChunk.chunkId + " from [" + prevMaxKeys + " max keys, " + prevByteSize + " bytes] to [" + this.chunk.getMaxKeys() + " max keys, " + this.chunk.getByteSize() + " bytes]");
        }
        this.totalMaxKeys += this.chunk.getMaxKeys();
        this.totalByteSize += this.chunk.getByteSize();
        this.firstKeyInChunk = null;
        this.prevChunk = this.chunk;
        this.chunk = null;
    }

    @Override
    public void append(Cell cell) throws IOException {
        if (cell == null) {
            throw new NullPointerException();
        }
        this.enqueueReadyChunk(false);
        if (this.chunk == null) {
            if (this.firstKeyInChunk != null) {
                throw new IllegalStateException("First key in chunk already set: " + Bytes.toStringBinary((byte[])this.firstKeyInChunk));
            }
            this.firstKeyInChunk = this.bloomType == BloomType.ROWCOL ? PrivateCellUtil.getCellKeySerializedAsKeyValueKey((Cell)PrivateCellUtil.createFirstOnRowCol((Cell)cell)) : CellUtil.copyRow((Cell)cell);
            this.allocateNewChunk();
        }
        this.chunk.add(cell);
        this.prevCell = cell;
        ++this.totalKeyCount;
    }

    @Override
    public void beforeShipped() throws IOException {
        if (this.prevCell != null) {
            this.prevCell = KeyValueUtil.toNewKeyCell((Cell)this.prevCell);
        }
    }

    @Override
    public Cell getPrevCell() {
        return this.prevCell;
    }

    private void allocateNewChunk() {
        this.chunk = this.prevChunk == null ? BloomFilterUtil.createBySize(this.chunkByteSize, this.errorRate, this.hashType, this.maxFold, this.bloomType) : this.prevChunk.createAnother();
        if (this.chunk.getKeyCount() != 0L) {
            throw new IllegalStateException("keyCount=" + this.chunk.getKeyCount() + " > 0");
        }
        this.chunk.allocBloom();
        ++this.numChunks;
    }

    @Override
    public void writeInlineBlock(DataOutput out) throws IOException {
        ReadyChunk readyChunk = this.readyChunks.peek();
        BloomFilterChunk readyChunkBloom = readyChunk.chunk;
        readyChunkBloom.writeBloom(out);
    }

    @Override
    public void blockWritten(long offset, int onDiskSize, int uncompressedSize) {
        ReadyChunk readyChunk = this.readyChunks.remove();
        this.bloomBlockIndexWriter.addEntry(readyChunk.firstKey, offset, onDiskSize);
    }

    @Override
    public BlockType getInlineBlockType() {
        return BlockType.BLOOM_CHUNK;
    }

    @Override
    public void compactBloom() {
    }

    @Override
    public Writable getMetaWriter() {
        return new MetaWriter();
    }

    @Override
    public Writable getDataWriter() {
        return null;
    }

    @Override
    public boolean getCacheOnWrite() {
        return this.cacheOnWrite;
    }

    private class MetaWriter
    implements Writable {
        protected MetaWriter() {
        }

        public void readFields(DataInput in) throws IOException {
            throw new IOException("Cant read with this class.");
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(3);
            out.writeLong(CompoundBloomFilterWriter.this.getByteSize());
            out.writeInt(CompoundBloomFilterWriter.this.prevChunk.getHashCount());
            out.writeInt(CompoundBloomFilterWriter.this.prevChunk.getHashType());
            out.writeLong(CompoundBloomFilterWriter.this.getKeyCount());
            out.writeLong(CompoundBloomFilterWriter.this.getMaxKeys());
            out.writeInt(CompoundBloomFilterWriter.this.numChunks);
            if (CompoundBloomFilterWriter.this.comparator != null) {
                Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)CompoundBloomFilterWriter.this.comparator.getClass().getName()));
            } else {
                Bytes.writeByteArray((DataOutput)out, null);
            }
            CompoundBloomFilterWriter.this.bloomBlockIndexWriter.writeSingleLevelIndex(out, "Bloom filter");
        }
    }

    private static class ReadyChunk {
        int chunkId;
        byte[] firstKey;
        BloomFilterChunk chunk;

        private ReadyChunk() {
        }
    }
}

