/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.impl.CounterImpl;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCounterImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCounterImpl.class);
    private Counter counter;

    @Before
    public void setup() {
        this.counter = new CounterImpl();
    }

    @Test
    public void testCounting() {
        this.counter.increment();
        Assert.assertEquals((long)1L, (long)this.counter.getCount());
        this.counter.increment();
        Assert.assertEquals((long)2L, (long)this.counter.getCount());
        this.counter.increment(2L);
        Assert.assertEquals((long)4L, (long)this.counter.getCount());
        this.counter.increment(-1L);
        Assert.assertEquals((long)3L, (long)this.counter.getCount());
        this.counter.decrement();
        Assert.assertEquals((long)2L, (long)this.counter.getCount());
        this.counter.decrement();
        Assert.assertEquals((long)1L, (long)this.counter.getCount());
        this.counter.decrement(4L);
        Assert.assertEquals((long)-3L, (long)this.counter.getCount());
        this.counter.decrement(-3L);
        Assert.assertEquals((long)0L, (long)this.counter.getCount());
    }
}

