/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.scan;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.TooManyFilesException;
import org.apache.accumulo.tserver.scan.ScanRunState;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextBatchTask
extends ScanTask<ScanBatch> {
    private static final Logger log = LoggerFactory.getLogger(NextBatchTask.class);
    private final long scanID;

    public NextBatchTask(TabletServer server, long scanID, AtomicBoolean interruptFlag) {
        super(server);
        this.scanID = scanID;
        this.interruptFlag = interruptFlag;
        if (interruptFlag.get()) {
            this.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ScanSession scanSession = (ScanSession)this.server.getSession(this.scanID);
        String oldThreadName = Thread.currentThread().getName();
        try {
            if (this.isCancelled() || scanSession == null) {
                return;
            }
            this.runState.set(ScanRunState.RUNNING);
            Thread.currentThread().setName("User: " + scanSession.getUser() + " Start: " + scanSession.startTime + " Client: " + scanSession.client + " Tablet: " + scanSession.extent);
            Tablet tablet = this.server.getOnlineTablet(scanSession.extent);
            if (tablet == null) {
                this.addResult(new NotServingTabletException(scanSession.extent.toThrift()));
                return;
            }
            long t1 = System.currentTimeMillis();
            ScanBatch batch = scanSession.scanner.read();
            long t2 = System.currentTimeMillis();
            scanSession.nbTimes.addStat(t2 - t1);
            this.addResult(batch);
        }
        catch (TabletClosedException e) {
            this.addResult(new NotServingTabletException(scanSession.extent.toThrift()));
        }
        catch (IterationInterruptedException iie) {
            if (!this.isCancelled()) {
                log.warn("Iteration interrupted, when scan not cancelled", (Throwable)iie);
                this.addResult((Object)iie);
            }
        }
        catch (SampleNotPresentException | TooManyFilesException e) {
            this.addResult(e);
        }
        catch (OutOfMemoryError ome) {
            Halt.halt((String)("Ran out of memory scanning " + scanSession.extent + " for " + scanSession.client), (int)1);
            this.addResult(ome);
        }
        catch (Throwable e) {
            log.warn("exception while scanning tablet " + (scanSession == null ? "(unknown)" : scanSession.extent), e);
            this.addResult(e);
        }
        finally {
            this.runState.set(ScanRunState.FINISHED);
            Thread.currentThread().setName(oldThreadName);
        }
    }
}

