/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.impl.TabletType;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteTracker {
    private static final Logger log = LoggerFactory.getLogger(WriteTracker.class);
    private static final AtomicLong operationCounter = new AtomicLong(1L);
    private final Map<TabletType, TreeSet<Long>> inProgressWrites = new EnumMap<TabletType, TreeSet<Long>>(TabletType.class);

    WriteTracker() {
        for (TabletType ttype : TabletType.values()) {
            this.inProgressWrites.put(ttype, new TreeSet());
        }
    }

    synchronized long startWrite(TabletType ttype) {
        long operationId = operationCounter.getAndIncrement();
        this.inProgressWrites.get(ttype).add(operationId);
        return operationId;
    }

    synchronized void finishWrite(long operationId) {
        TabletType ttype;
        if (operationId == -1L) {
            return;
        }
        boolean removed = false;
        TabletType[] tabletTypeArray = TabletType.values();
        int n = tabletTypeArray.length;
        for (int i = 0; i < n && !(removed = this.inProgressWrites.get(ttype = tabletTypeArray[i]).remove(operationId)); ++i) {
        }
        if (!removed) {
            throw new IllegalArgumentException("Attempted to finish write not in progress,  operationId " + operationId);
        }
        this.notifyAll();
    }

    synchronized void waitForWrites(TabletType ttype) {
        long operationId = operationCounter.getAndIncrement();
        while (this.inProgressWrites.get(ttype).floor(operationId) != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public long startWrite(Set<Tablet> keySet) {
        if (keySet.size() == 0) {
            return -1L;
        }
        ArrayList<KeyExtent> extents = new ArrayList<KeyExtent>(keySet.size());
        for (Tablet tablet : keySet) {
            extents.add(tablet.getExtent());
        }
        return this.startWrite(TabletType.type(extents));
    }
}

