/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.hdfs.server.common.Util;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGetUriFromString {
    private static final Logger LOG = LoggerFactory.getLogger(TestGetUriFromString.class);
    private static final String RELATIVE_FILE_PATH = "relativeFilePath";
    private static final String ABSOLUTE_PATH_UNIX = "/tmp/file1";
    private static final String ABSOLUTE_PATH_WINDOWS = "C:\\Documents and Settings\\All Users";
    private static final String URI_FILE_SCHEMA = "file";
    private static final String URI_PATH_UNIX = "/var/www";
    private static final String URI_PATH_WINDOWS = "/C:/Documents%20and%20Settings/All%20Users";
    private static final String URI_UNIX = "file:///var/www";
    private static final String URI_WINDOWS = "file:///C:/Documents%20and%20Settings/All%20Users";

    @Test
    public void testRelativePathAsURI() throws IOException {
        URI u = Util.stringAsURI((String)RELATIVE_FILE_PATH);
        LOG.info("Uri: " + u);
        Assert.assertNotNull((Object)u);
    }

    @Test
    public void testAbsolutePathAsURI() throws IOException {
        URI u = null;
        u = Util.stringAsURI((String)ABSOLUTE_PATH_WINDOWS);
        Assert.assertNotNull((String)"Uri should not be null for Windows pathC:\\Documents and Settings\\All Users", (Object)u);
        Assert.assertEquals((Object)URI_FILE_SCHEMA, (Object)u.getScheme());
        u = Util.stringAsURI((String)ABSOLUTE_PATH_UNIX);
        Assert.assertNotNull((String)"Uri should not be null for Unix path/tmp/file1", (Object)u);
        Assert.assertEquals((Object)URI_FILE_SCHEMA, (Object)u.getScheme());
    }

    @Test
    public void testURI() throws IOException {
        LOG.info("Testing correct Unix URI: file:///var/www");
        URI u = Util.stringAsURI((String)URI_UNIX);
        LOG.info("Uri: " + u);
        Assert.assertNotNull((String)"Uri should not be null at this point", (Object)u);
        Assert.assertEquals((Object)URI_FILE_SCHEMA, (Object)u.getScheme());
        Assert.assertEquals((Object)URI_PATH_UNIX, (Object)u.getPath());
        LOG.info("Testing correct windows URI: file:///C:/Documents%20and%20Settings/All%20Users");
        u = Util.stringAsURI((String)URI_WINDOWS);
        LOG.info("Uri: " + u);
        Assert.assertNotNull((String)"Uri should not be null at this point", (Object)u);
        Assert.assertEquals((Object)URI_FILE_SCHEMA, (Object)u.getScheme());
        Assert.assertEquals((Object)URI_PATH_WINDOWS.replace("%20", " "), (Object)u.getPath());
    }
}

