/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.PigSecondaryKeyComparatorSpark;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.joda.time.DateTime;

public class IndexedKey
implements Serializable,
Comparable {
    private static final Log LOG = LogFactory.getLog(IndexedKey.class);
    private byte index;
    private Object key;
    private boolean useSecondaryKey;
    private boolean[] secondarySortOrder;

    public IndexedKey(byte index, Object key) {
        this.index = index;
        this.key = key;
    }

    public byte getIndex() {
        return this.index;
    }

    public Object getKey() {
        return this.key;
    }

    public String toString() {
        return "IndexedKey{index=" + this.index + ", key=" + this.key + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedKey that = (IndexedKey)o;
        if (this.index == that.index) {
            if (this.key == null && that.key == null) {
                return true;
            }
            if (this.key == null || that.key == null) {
                return false;
            }
            if (this.key instanceof DateTime) {
                return ((DateTime)this.key).isEqual((DateTime)that.key);
            }
            return this.key.equals(that.key);
        }
        if (this.key == null || that.key == null) {
            return false;
        }
        return this.key.equals(that.key) && !this.containNullfields(this.key);
    }

    private boolean containNullfields(Object key) {
        if (key instanceof Tuple) {
            for (int i = 0; i < ((Tuple)key).size(); ++i) {
                try {
                    if (((Tuple)key).get(i) != null) continue;
                    return true;
                }
                catch (ExecException e) {
                    throw new RuntimeException("exception found in containNullfields", e);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        if (this.key == null) {
            result = this.index;
        } else if (this.key instanceof DateTime) {
            DateTime dt = (DateTime)this.key;
            result = (int)(dt.getMillis() ^ dt.getMillis() >>> 32);
        } else {
            result = this.key.hashCode();
        }
        return result;
    }

    public int compareTo(Object o) {
        IndexedKey that = (IndexedKey)o;
        int res = this.index - that.getIndex();
        if (res > 0) {
            return 1;
        }
        if (res < 0) {
            return -1;
        }
        if (this.useSecondaryKey) {
            Tuple thisCompoundKey = (Tuple)this.key;
            Tuple thatCompoundKey = (Tuple)that.getKey();
            PigSecondaryKeyComparatorSpark comparator = new PigSecondaryKeyComparatorSpark(this.secondarySortOrder);
            return comparator.compareCompoundKey(thisCompoundKey, thatCompoundKey);
        }
        return DataType.compare(this.key, that.getKey());
    }

    public void setUseSecondaryKey(boolean useSecondaryKey) {
        this.useSecondaryKey = useSecondaryKey;
    }

    public void setSecondarySortOrder(boolean[] secondarySortOrder) {
        this.secondarySortOrder = secondarySortOrder;
    }
}

