/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.regionserver.HBaseInterClusterReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestSerialReplicationEndpoint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSerialReplicationEndpoint.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Configuration CONF;
    private static Connection CONN;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster();
        CONF = UTIL.getConfiguration();
        CONF.setLong("hbase.ipc.max.request.size", 102400L);
        CONN = UTIL.getConnection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    private String getZKClusterKey() {
        return String.format("127.0.0.1:%d:%s", UTIL.getZkCluster().getClientPort(), CONF.get("zookeeper.znode.parent"));
    }

    private void testHBaseReplicationEndpoint(String tableNameStr, String peerId, boolean isSerial) throws IOException {
        TestEndpoint.reset();
        int cellNum = 10000;
        TableName tableName = TableName.valueOf((String)tableNameStr);
        byte[] family = Bytes.toBytes((String)"f");
        byte[] qualifier = Bytes.toBytes((String)"q");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setScope(1).build()).build();
        UTIL.createTable(td, (byte[][])null);
        Admin admin = CONN.getAdmin();
        Object object = null;
        try {
            ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey(this.getZKClusterKey()).setReplicationEndpointImpl(TestEndpoint.class.getName()).setReplicateAllUserTables(false).setSerial(isSerial).setTableCFsMap((Map)ImmutableMap.of((Object)tableName, (Object)ImmutableList.of())).build();
            admin.addReplicationPeer(peerId, peerConfig);
        }
        catch (Throwable peerConfig) {
            object = peerConfig;
            throw peerConfig;
        }
        finally {
            if (admin != null) {
                if (object != null) {
                    try {
                        admin.close();
                    }
                    catch (Throwable peerConfig) {
                        ((Throwable)object).addSuppressed(peerConfig);
                    }
                } else {
                    admin.close();
                }
            }
        }
        Table table = CONN.getTable(tableName);
        object = null;
        try {
            for (int i = 0; i < cellNum; ++i) {
                Put put = new Put(Bytes.toBytes((int)i)).addColumn(family, qualifier, System.currentTimeMillis(), Bytes.toBytes((int)i));
                table.put(put);
            }
        }
        catch (Throwable i) {
            object = i;
            throw i;
        }
        finally {
            if (table != null) {
                if (object != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable i) {
                        ((Throwable)object).addSuppressed(i);
                    }
                } else {
                    table.close();
                }
            }
        }
        Waiter.waitFor((Configuration)CONF, (long)60000L, () -> TestEndpoint.getEntries().size() >= cellNum);
        int index = 0;
        Assert.assertEquals((long)TestEndpoint.getEntries().size(), (long)cellNum);
        if (!isSerial) {
            Collections.sort(TestEndpoint.getEntries(), (a, b) -> {
                long seqB;
                long seqA = a.getKey().getSequenceId();
                return seqA == (seqB = b.getKey().getSequenceId()) ? 0 : (seqA < seqB ? -1 : 1);
            });
        }
        for (WAL.Entry entry : TestEndpoint.getEntries()) {
            Assert.assertEquals((Object)entry.getKey().getTableName(), (Object)tableName);
            Assert.assertEquals((long)entry.getEdit().getCells().size(), (long)1L);
            Cell cell = (Cell)entry.getEdit().getCells().get(0);
            Assert.assertArrayEquals((byte[])Bytes.copy((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()), (byte[])Bytes.toBytes((int)index));
            ++index;
        }
        Assert.assertEquals((long)index, (long)cellNum);
    }

    @Test
    public void testSerialReplicate() throws Exception {
        this.testHBaseReplicationEndpoint("testSerialReplicate", "100", true);
    }

    @Test
    public void testParallelReplicate() throws Exception {
        this.testHBaseReplicationEndpoint("testParallelReplicate", "101", false);
    }

    public static class TestEndpoint
    extends HBaseInterClusterReplicationEndpoint {
        private static final BlockingQueue<WAL.Entry> entryQueue = new LinkedBlockingQueue<WAL.Entry>();

        public static void reset() {
            entryQueue.clear();
        }

        public static List<WAL.Entry> getEntries() {
            return new ArrayList<WAL.Entry>(entryQueue);
        }

        public boolean canReplicateToSameCluster() {
            return true;
        }

        protected Callable<Integer> createReplicator(List<WAL.Entry> entries, int ordinal, int timeout) {
            return () -> {
                entryQueue.addAll(entries);
                return ordinal;
            };
        }

        public synchronized List<ServerName> getRegionServers() {
            return new ArrayList<ServerName>((Collection<ServerName>)ImmutableList.of((Object)ServerName.valueOf((String)"www.example.com", (int)12016, (long)1525245876026L), (Object)ServerName.valueOf((String)"www.example2.com", (int)12016, (long)1525245876026L), (Object)ServerName.valueOf((String)"www.example3.com", (int)12016, (long)1525245876026L), (Object)ServerName.valueOf((String)"www.example4.com", (int)12016, (long)1525245876026L), (Object)ServerName.valueOf((String)"www.example4.com", (int)12016, (long)1525245876026L)));
        }
    }
}

