/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactSplit;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.TestBulkloadBase;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequester;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestCompactionAfterBulkLoad
extends TestBulkloadBase {
    private final RegionServerServices regionServerServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
    private final CompactionRequester compactionRequester = (CompactionRequester)Mockito.mock(CompactSplit.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactionAfterBulkLoad.class);

    @Override
    protected HRegion testRegionWithFamiliesAndSpecifiedTableName(TableName tableName, byte[] ... families) throws IOException {
        RegionInfo hRegionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return HRegion.createHRegion((RegionInfo)hRegionInfo, (Path)new Path(testFolder.newFolder().toURI()), (Configuration)this.conf, (TableDescriptor)builder.build(), (WAL)this.log, (boolean)true, (RegionServerServices)this.regionServerServices);
    }

    @Test
    public void shouldRequestCompactionAfterBulkLoad() throws IOException {
        ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>();
        for (int i = 0; i < 5; ++i) {
            familyPaths.addAll(this.withFamilyPathsFor(this.family1, this.family2, this.family3));
        }
        Mockito.when((Object)this.regionServerServices.getConfiguration()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.regionServerServices.getCompactionRequestor()).thenReturn((Object)this.compactionRequester);
        Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestCompactionAfterBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                if (mvcc != null) {
                    MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                    walKey.setWriteEntry(we);
                }
                return 1L;
            }
        });
        ((CompactionRequester)Mockito.doNothing().when((Object)this.compactionRequester)).requestCompaction((HRegion)ArgumentMatchers.any(), (HStore)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (CompactionLifeCycleTracker)ArgumentMatchers.any(), (User)ArgumentMatchers.any());
        this.testRegionWithFamilies(this.family1, this.family2, this.family3).bulkLoadHFiles(familyPaths, false, null);
        ((CompactionRequester)Mockito.verify((Object)this.compactionRequester, (VerificationMode)Mockito.times((int)3))).requestCompaction((HRegion)ArgumentMatchers.isA(HRegion.class), (HStore)ArgumentMatchers.isA(HStore.class), (String)ArgumentMatchers.isA(String.class), ArgumentMatchers.anyInt(), (CompactionLifeCycleTracker)ArgumentMatchers.eq((Object)CompactionLifeCycleTracker.DUMMY), (User)ArgumentMatchers.eq(null));
    }
}

