/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.webapp;

import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.webapp.MetaBrowser;
import org.apache.hadoop.hbase.master.webapp.TestMetaBrowser;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@Category(value={MasterTests.class, SmallTests.class})
public class TestMetaBrowserNoCluster {
    @ClassRule
    public static final HBaseClassTestRule testRule = HBaseClassTestRule.forClass(TestMetaBrowserNoCluster.class);
    @Mock
    private AsyncConnection connection;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void buildFirstPageQueryStringNoParams() {
        HttpServletRequest request = new TestMetaBrowser.MockRequestBuilder().build();
        MetaBrowser metaBrowser = new MetaBrowser(this.connection, request);
        Assert.assertEquals((Object)"hbase:meta", (Object)metaBrowser.getName());
        Assert.assertNull((Object)metaBrowser.getScanLimit());
        Assert.assertNull((Object)metaBrowser.getScanRegionState());
        Assert.assertNull((Object)metaBrowser.getScanStart());
        Assert.assertNull((Object)metaBrowser.getScanTable());
        Assert.assertEquals((Object)"/table.jsp?name=hbase%3Ameta", (Object)metaBrowser.buildFirstPageUrl());
    }

    @Test
    public void buildFirstPageQueryStringNonNullParams() {
        HttpServletRequest request = new TestMetaBrowser.MockRequestBuilder().setLimit(50).setRegionState(RegionState.State.ABNORMALLY_CLOSED).setTable("foo%3Abar").build();
        MetaBrowser metaBrowser = new MetaBrowser(this.connection, request);
        Assert.assertEquals((long)50L, (long)metaBrowser.getScanLimit().intValue());
        Assert.assertEquals((Object)RegionState.State.ABNORMALLY_CLOSED, (Object)metaBrowser.getScanRegionState());
        Assert.assertEquals((Object)TableName.valueOf((String)"foo", (String)"bar"), (Object)metaBrowser.getScanTable());
        Assert.assertEquals((Object)"/table.jsp?name=hbase%3Ameta&scan_limit=50&scan_region_state=ABNORMALLY_CLOSED&scan_table=foo%3Abar", (Object)metaBrowser.buildNextPageUrl(null));
    }

    @Test
    public void buildNextPageQueryString() {
        HttpServletRequest request = new TestMetaBrowser.MockRequestBuilder().build();
        MetaBrowser metaBrowser = new MetaBrowser(this.connection, request);
        Assert.assertEquals((Object)"/table.jsp?name=hbase%3Ameta&scan_start=%255Cx80%255Cx00%255Cx7F", (Object)metaBrowser.buildNextPageUrl(new byte[]{-128, 0, 127}));
    }

    @Test
    public void unparseableLimitParam() {
        HttpServletRequest request = new TestMetaBrowser.MockRequestBuilder().setLimit("foo").build();
        MetaBrowser metaBrowser = new MetaBrowser(this.connection, request);
        Assert.assertNull((Object)metaBrowser.getScanLimit());
        MatcherAssert.assertThat((Object)metaBrowser.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Requested SCAN_LIMIT value 'foo' cannot be parsed as an integer."}));
    }

    @Test
    public void zeroLimitParam() {
        HttpServletRequest request = new TestMetaBrowser.MockRequestBuilder().setLimit(0).build();
        MetaBrowser metaBrowser = new MetaBrowser(this.connection, request);
        Assert.assertEquals((long)10L, (long)metaBrowser.getScanLimit().intValue());
        MatcherAssert.assertThat((Object)metaBrowser.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Requested SCAN_LIMIT value 0 is <= 0."}));
    }

    @Test
    public void negativeLimitParam() {
        HttpServletRequest request = new TestMetaBrowser.MockRequestBuilder().setLimit(-10).build();
        MetaBrowser metaBrowser = new MetaBrowser(this.connection, request);
        Assert.assertEquals((long)10L, (long)metaBrowser.getScanLimit().intValue());
        MatcherAssert.assertThat((Object)metaBrowser.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Requested SCAN_LIMIT value -10 is <= 0."}));
    }

    @Test
    public void excessiveLimitParam() {
        HttpServletRequest request = new TestMetaBrowser.MockRequestBuilder().setLimit(10001).build();
        MetaBrowser metaBrowser = new MetaBrowser(this.connection, request);
        Assert.assertEquals((long)10000L, (long)metaBrowser.getScanLimit().intValue());
        MatcherAssert.assertThat((Object)metaBrowser.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Requested SCAN_LIMIT value 10001 exceeds maximum value 10000."}));
    }

    @Test
    public void invalidRegionStateParam() {
        HttpServletRequest request = new TestMetaBrowser.MockRequestBuilder().setRegionState("foo").build();
        MetaBrowser metaBrowser = new MetaBrowser(this.connection, request);
        Assert.assertNull((Object)metaBrowser.getScanRegionState());
        MatcherAssert.assertThat((Object)metaBrowser.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Requested SCAN_REGION_STATE value 'foo' cannot be parsed as a RegionState."}));
    }

    @Test
    public void multipleErrorMessages() {
        HttpServletRequest request = new TestMetaBrowser.MockRequestBuilder().setLimit("foo").setRegionState("bar").build();
        MetaBrowser metaBrowser = new MetaBrowser(this.connection, request);
        MatcherAssert.assertThat((Object)metaBrowser.getErrorMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Requested SCAN_LIMIT value 'foo' cannot be parsed as an integer.", "Requested SCAN_REGION_STATE value 'bar' cannot be parsed as a RegionState."}));
    }
}

