/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class VectorUDFMapIndexBaseScalar
extends VectorUDFMapIndexBase {
    private static final long serialVersionUID = 1L;
    private int mapColumnNum;

    public VectorUDFMapIndexBaseScalar() {
    }

    public VectorUDFMapIndexBaseScalar(int mapColumnNum, int outputColumnNum) {
        super(outputColumnNum);
        this.mapColumnNum = mapColumnNum;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector outV = batch.cols[this.outputColumnNum];
        MapColumnVector mapV = (MapColumnVector)batch.cols[this.mapColumnNum];
        if (mapV.isRepeating) {
            if (mapV.isNull[0]) {
                outV.isNull[0] = true;
                outV.noNulls = false;
            } else {
                int[] mapValueIndex = this.getMapValueIndex(mapV, batch);
                if (mapValueIndex[0] == -1) {
                    outV.isNull[0] = true;
                    outV.noNulls = false;
                } else {
                    outV.setElement(0, (int)(mapV.offsets[0] + (long)mapValueIndex[0]), mapV.values);
                }
            }
            outV.isRepeating = true;
        } else {
            int[] mapValueIndex = this.getMapValueIndex(mapV, batch);
            for (int i = 0; i < batch.size; ++i) {
                int j;
                int n = j = batch.selectedInUse ? batch.selected[i] : i;
                if (mapV.isNull[j] || mapValueIndex[j] == -1) {
                    outV.isNull[j] = true;
                    outV.noNulls = false;
                    continue;
                }
                outV.isNull[j] = false;
                outV.setElement(j, (int)(mapV.offsets[j] + (long)mapValueIndex[j]), mapV.values);
            }
            outV.isRepeating = false;
        }
    }

    public int getMapColumnNum() {
        return this.mapColumnNum;
    }
}

