/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class VectorUDFMapIndexBase
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public VectorUDFMapIndexBase() {
    }

    public VectorUDFMapIndexBase(int outputColumnNum) {
        super(outputColumnNum);
    }

    protected int[] getMapValueIndex(MapColumnVector mapV, VectorizedRowBatch batch) {
        int[] indexArray = new int[1024];
        for (int i = 0; i < batch.size; ++i) {
            boolean findKey = false;
            int offset = batch.selectedInUse ? batch.selected[i] : i;
            Object columnKey = this.getCurrentKey(offset);
            int j = 0;
            while ((long)j < mapV.lengths[offset]) {
                int index = (int)(mapV.offsets[offset] + (long)j);
                Object tempKey = this.getKeyByIndex(mapV.keys, index);
                if (this.compareKey(columnKey, tempKey)) {
                    indexArray[offset] = j;
                    findKey = true;
                    break;
                }
                ++j;
            }
            if (!findKey) {
                indexArray[offset] = -1;
            }
            if (mapV.isRepeating) break;
        }
        return indexArray;
    }

    protected boolean compareKey(Object columnKey, Object otherKey) {
        if (columnKey == null && otherKey == null) {
            return true;
        }
        if (columnKey != null && otherKey != null) {
            return this.compareKeyInternal(columnKey, otherKey);
        }
        return false;
    }

    protected boolean compareKeyInternal(Object columnKey, Object otherKey) {
        return columnKey.equals(otherKey);
    }

    abstract Object getKeyByIndex(ColumnVector var1, int var2);

    abstract Object getCurrentKey(int var1);
}

