/*
 * Decompiled with CFR 0.152.
 */
package sdsu.algorithms.data;

import sdsu.algorithms.data.NoInverseDistribution;
import sdsu.algorithms.data.OutOfBoundsException;

public class GeneralizedEightyTwenty
extends NoInverseDistribution {
    private double theta;

    public GeneralizedEightyTwenty(double d, int n) {
        if (d < 0.5 || d > 1.0) {
            throw new OutOfBoundsException("percentConsumed must be in the interval [.5, 1, your value was " + d);
        }
        if (n < 1) {
            throw new OutOfBoundsException("numberOfConsumers must be greater than 0, your value was " + n);
        }
        this.populationSize = n;
        this.theta = Math.log(d) / Math.log(1.0 - d);
        super.computePartialCumulativeDist(Math.min(20, n));
    }

    public double density(double d) throws OutOfBoundsException {
        int n = (int)d;
        if (n <= 0 || n > this.populationSize) {
            throw new OutOfBoundsException("Agrument to density function of GeneralizedEightyTwenty must be value in interval [1, " + this.populationSize + "], your value was " + d);
        }
        return (Math.pow(n, this.theta) - Math.pow(n - 1, this.theta)) / Math.pow(this.populationSize, this.theta);
    }

    public double mean() {
        return this.theta * (double)this.populationSize / (this.theta + 1.0) + 0.5;
    }

    public double variance() {
        return this.theta * (double)this.populationSize * (double)this.populationSize / ((this.theta + 1.0) * (this.theta + 1.0) * (this.theta + 2.0));
    }
}

