/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.pig.PigServer;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.parser.ParserException;
import org.apache.pig.tools.DownloadResolver;

public class RegisterResolver {
    private PigServer pigServer;

    public RegisterResolver(PigServer pigServer) {
        this.pigServer = pigServer;
    }

    public void parseRegister(String path, String scriptingLang, String namespace) throws IOException {
        try {
            URI uri = new URI(path);
            if (this.resolvesToJar(uri)) {
                URI[] uriList;
                if (scriptingLang != null || namespace != null) {
                    throw new ParserException("Cannot register a jar with a scripting language or namespace");
                }
                for (URI jarUri : uriList = this.resolve(uri)) {
                    this.pigServer.registerJar(jarUri.toString());
                }
            } else {
                this.pigServer.registerCode(path, scriptingLang, namespace);
            }
        }
        catch (URISyntaxException e) {
            throw new ParserException("URI " + path + " is incorrect.", e);
        }
    }

    public URI[] resolve(URI uri) throws IOException {
        String scheme = uri.getScheme();
        if (scheme != null) {
            if ((scheme = scheme.toLowerCase()).equals("ivy")) {
                DownloadResolver downloadResolver = DownloadResolver.getInstance();
                return downloadResolver.downloadArtifact(uri, this.pigServer);
            }
            if (!this.hasFileSystemImpl(uri)) {
                throw new ParserException("Invalid Scheme: " + uri.getScheme());
            }
        }
        return new URI[]{uri};
    }

    private boolean hasFileSystemImpl(URI uri) {
        Configuration conf = ConfigurationUtil.toConfiguration(this.pigServer.getPigContext().getProperties(), true);
        return HadoopShims.hasFileSystemImpl(new Path(uri), conf);
    }

    private boolean resolvesToJar(URI uri) {
        String scheme = uri.getScheme();
        return uri.toString().endsWith("jar") || scheme != null && scheme.toLowerCase().equals("ivy");
    }
}

