/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.PartitionFilterExtractor;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class PartitionFilterOptimizer
extends Rule {
    private static final Log LOG = LogFactory.getLog(PartitionFilterOptimizer.class);
    private String[] partitionKeys;
    private LoadMetadata loadMetadata;
    private LoadFunc loadFunc;
    private LOLoad loLoad;
    private LOFilter loFilter;
    private Map<String, String> colNameMap = new HashMap<String, String>();
    private Map<String, String> reverseColNameMap = new HashMap<String, String>();

    public PartitionFilterOptimizer(String name) {
        super(name, false);
    }

    @Override
    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOLoad load = new LOLoad(null, plan);
        plan.add(load);
        return plan;
    }

    @Override
    public Transformer getNewTransformer() {
        return new PartitionFilterPushDownTransformer();
    }

    static /* synthetic */ String[] access$502(PartitionFilterOptimizer x0, String[] x1) {
        x0.partitionKeys = x1;
        return x1;
    }

    public class PartitionFilterPushDownTransformer
    extends Transformer {
        protected OperatorSubPlan subPlan;
        private boolean planChanged;

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            PartitionFilterOptimizer.this.loLoad = (LOLoad)matched.getSources().get(0);
            List<Operator> succeds = PartitionFilterOptimizer.this.currentPlan.getSuccessors(PartitionFilterOptimizer.this.loLoad);
            if (succeds == null || succeds.size() == 0 || !(succeds.get(0) instanceof LOFilter)) {
                return false;
            }
            PartitionFilterOptimizer.this.loFilter = (LOFilter)succeds.get(0);
            PartitionFilterOptimizer.this.loadFunc = PartitionFilterOptimizer.this.loLoad.getLoadFunc();
            if (!(PartitionFilterOptimizer.this.loadFunc instanceof LoadMetadata)) {
                return false;
            }
            PartitionFilterOptimizer.this.loadMetadata = (LoadMetadata)((Object)PartitionFilterOptimizer.this.loadFunc);
            try {
                PartitionFilterOptimizer.access$502(PartitionFilterOptimizer.this, PartitionFilterOptimizer.this.loadMetadata.getPartitionKeys(PartitionFilterOptimizer.this.loLoad.getFileSpec().getFileName(), new Job(PartitionFilterOptimizer.this.loLoad.getConfiguration())));
            }
            catch (IOException e) {
                throw new FrontendException(e);
            }
            return PartitionFilterOptimizer.this.partitionKeys != null && PartitionFilterOptimizer.this.partitionKeys.length != 0;
        }

        @Override
        public OperatorPlan reportChanges() {
            return this.planChanged ? this.subPlan : null;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            this.subPlan = new OperatorSubPlan(PartitionFilterOptimizer.this.currentPlan);
            this.setupColNameMaps();
            PartitionFilterExtractor filterFinder = new PartitionFilterExtractor(PartitionFilterOptimizer.this.loFilter.getFilterPlan(), this.getMappedKeys(PartitionFilterOptimizer.this.partitionKeys));
            filterFinder.visit();
            LOG.info((Object)("Partition keys are " + Arrays.asList(PartitionFilterOptimizer.this.partitionKeys)));
            Expression partitionFilter = filterFinder.getPushDownExpression();
            if (partitionFilter != null) {
                this.updateMappedColNames(partitionFilter);
                try {
                    LOG.info((Object)("Setting partition filter [" + partitionFilter + "] on loader " + PartitionFilterOptimizer.this.loadMetadata));
                    PartitionFilterOptimizer.this.loadMetadata.setPartitionFilter(partitionFilter);
                    this.planChanged = true;
                }
                catch (IOException e) {
                    throw new FrontendException(e);
                }
                if (filterFinder.isFilterRemovable()) {
                    PartitionFilterOptimizer.this.currentPlan.removeAndReconnect(PartitionFilterOptimizer.this.loFilter);
                } else {
                    PartitionFilterOptimizer.this.loFilter.setFilterPlan(filterFinder.getFilteredPlan());
                }
            }
        }

        protected void updateMappedColNames(Expression expr) {
            if (expr instanceof Expression.BinaryExpression) {
                this.updateMappedColNames(((Expression.BinaryExpression)expr).getLhs());
                this.updateMappedColNames(((Expression.BinaryExpression)expr).getRhs());
            } else if (expr instanceof Expression.Column) {
                Expression.Column col = (Expression.Column)expr;
                col.setName((String)PartitionFilterOptimizer.this.reverseColNameMap.get(col.getName()));
            }
        }

        protected List<String> getMappedKeys(String[] partitionKeys) {
            ArrayList<String> mappedKeys = new ArrayList<String>(partitionKeys.length);
            for (int i = 0; i < partitionKeys.length; ++i) {
                mappedKeys.add((String)PartitionFilterOptimizer.this.colNameMap.get(partitionKeys[i]));
            }
            return mappedKeys;
        }

        protected void setupColNameMaps() throws FrontendException {
            LogicalSchema loLoadSchema = PartitionFilterOptimizer.this.loLoad.getSchema();
            LogicalSchema loadFuncSchema = PartitionFilterOptimizer.this.loLoad.getDeterminedSchema();
            for (int i = 0; i < loadFuncSchema.size(); ++i) {
                PartitionFilterOptimizer.this.colNameMap.put(loadFuncSchema.getField((int)i).alias, i < loLoadSchema.size() ? loLoadSchema.getField((int)i).alias : loadFuncSchema.getField((int)i).alias);
                PartitionFilterOptimizer.this.reverseColNameMap.put(i < loLoadSchema.size() ? loLoadSchema.getField((int)i).alias : loadFuncSchema.getField((int)i).alias, loadFuncSchema.getField((int)i).alias);
            }
        }
    }
}

