/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezTaskConfigurable;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;

public class POCounterTez
extends POCounter
implements TezOutput,
TezTaskConfigurable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POCounterTez.class);
    private String tuplesOutputKey;
    private String statsOutputKey;
    private transient KeyValueWriter tuplesWriter;
    private transient KeyValueWriter statsWriter;
    private transient long totalTaskRecords = 0L;

    public POCounterTez(POCounter copy) {
        super(copy);
    }

    @Override
    public void initialize(ProcessorContext processorContext) throws ExecException {
        this.setTaskId(processorContext.getTaskIndex());
    }

    public void setTuplesOutputKey(String tuplesOutputKey) {
        this.tuplesOutputKey = tuplesOutputKey;
    }

    public void setStatsOutputKey(String statsOutputKey) {
        this.statsOutputKey = statsOutputKey;
    }

    @Override
    public String[] getTezOutputs() {
        return new String[]{this.tuplesOutputKey, this.statsOutputKey};
    }

    @Override
    public void replaceOutput(String oldOutputKey, String newOutputKey) {
        if (oldOutputKey.equals(this.tuplesOutputKey)) {
            this.tuplesOutputKey = newOutputKey;
        } else if (oldOutputKey.equals(this.statsOutputKey)) {
            this.statsOutputKey = newOutputKey;
        }
    }

    @Override
    public void attachOutputs(Map<String, LogicalOutput> outputs, Configuration conf) throws ExecException {
        LogicalOutput output = outputs.get(this.tuplesOutputKey);
        if (output == null) {
            throw new ExecException("Output to vertex " + this.tuplesOutputKey + " is missing");
        }
        try {
            this.tuplesWriter = (KeyValueWriter)output.getWriter();
            LOG.info((Object)("Attached output to vertex " + this.tuplesOutputKey + " : output=" + output + ", writer=" + this.tuplesWriter));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
        output = outputs.get(this.statsOutputKey);
        if (output == null) {
            throw new ExecException("Output to vertex " + this.statsOutputKey + " is missing");
        }
        try {
            this.statsWriter = (KeyValueWriter)output.getWriter();
            LOG.info((Object)("Attached output to vertex " + this.statsOutputKey + " : output=" + output + ", writer=" + this.statsWriter));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result inp = null;
        try {
            while (true) {
                inp = this.processInput();
                if (inp.returnStatus == 3 || inp.returnStatus == 2) break;
                if (inp.returnStatus == 1) continue;
                this.tuplesWriter.write((Object)POValueOutputTez.EMPTY_KEY, this.addCounterValue((Result)inp).result);
                if (!this.isRowNumber()) continue;
                this.incrementReduceCounter(POCounter.ONE);
            }
            this.statsWriter.write((Object)new IntWritable(this.getTaskId()), (Object)new LongWritable(this.totalTaskRecords));
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
        return RESULT_EOP;
    }

    @Override
    protected void incrementReduceCounter(Long increment) {
        this.totalTaskRecords += increment.longValue();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        super.visit(v);
        v.visit(this);
    }

    @Override
    public String name() {
        return "POCounterTez - " + this.mKey.toString() + "\t->\t " + this.tuplesOutputKey + "," + this.statsOutputKey;
    }
}

