/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security.crypto;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BlockedInputStream
extends InputStream {
    byte[] array;
    int readPos;
    int writePos;
    DataInputStream in;
    int blockSize;
    boolean finished = false;

    public BlockedInputStream(InputStream in, int blockSize, int maxSize) {
        if (blockSize == 0) {
            throw new RuntimeException("Invalid block size");
        }
        this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        this.array = new byte[maxSize];
        this.readPos = 0;
        this.writePos = -1;
        this.blockSize = blockSize;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining() > 0) {
            return this.array[this.readAndIncrement(1)] & 0xFF;
        }
        return -1;
    }

    private int readAndIncrement(int toAdd) {
        int toRet = this.readPos;
        this.readPos += toAdd;
        if (this.readPos == this.array.length) {
            this.readPos = 0;
        } else if (this.readPos > this.array.length) {
            throw new RuntimeException("Unexpected state, this should only ever increase or cycle on the boundry!");
        }
        return toRet;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int toCopy = Math.min(len, this.remaining());
        if (toCopy > 0) {
            System.arraycopy(this.array, this.readPos, b, off, toCopy);
            this.readAndIncrement(toCopy);
        }
        return toCopy;
    }

    private int remaining() throws IOException {
        if (this.finished) {
            return -1;
        }
        if (this.available() == 0) {
            this.refill();
        }
        return this.available();
    }

    @Override
    public int available() {
        int toRet = this.writePos + 1 - this.readPos;
        if (toRet < 0) {
            toRet += this.array.length;
        }
        return Math.min(this.array.length - this.readPos, toRet);
    }

    private boolean refill() throws IOException {
        int remainder;
        int size;
        if (this.finished) {
            return false;
        }
        try {
            size = this.in.readInt();
        }
        catch (EOFException eof) {
            this.finished = true;
            return false;
        }
        if (size < 0 || size > this.array.length) {
            this.finished = true;
            return false;
        }
        if (size == 0) {
            throw new RuntimeException("Empty block written, this shouldn't happen with this BlockedOutputStream.");
        }
        int bufferAvailable = this.array.length - this.readPos;
        if (size > bufferAvailable) {
            this.in.readFully(this.array, this.writePos + 1, bufferAvailable);
            this.in.readFully(this.array, 0, size - bufferAvailable);
        } else {
            this.in.readFully(this.array, this.writePos + 1, size);
        }
        this.writePos += size;
        if (this.writePos >= this.array.length - 1) {
            this.writePos -= this.array.length;
        }
        if ((remainder = this.blockSize - (size + 4) % this.blockSize) != this.blockSize) {
            if (this.in.available() < remainder) {
                this.undoWrite(size);
                return false;
            }
            this.in.skip(remainder);
        }
        return true;
    }

    private void undoWrite(int size) {
        this.writePos -= size;
        if (this.writePos < -1) {
            this.writePos += this.array.length;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.array = null;
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.readPos = 0;
        this.writePos = -1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

