/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.sample.impl;

import com.google.common.hash.Hasher;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class DataoutputHasher
implements DataOutput {
    private Hasher hasher;

    public DataoutputHasher(Hasher hasher) {
        this.hasher = hasher;
    }

    @Override
    public void write(int b) throws IOException {
        this.hasher.putByte((byte)(0xFF & b));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.hasher.putBytes(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.hasher.putBytes(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.hasher.putBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.hasher.putByte((byte)(0xFF & v));
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.hasher.putShort((short)(0xFFFF & v));
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.hasher.putChar((char)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.hasher.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.hasher.putLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.hasher.putDouble((double)v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.hasher.putDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.hasher.putByte((byte)(0xFF & s.charAt(i)));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.hasher.putChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.hasher.putInt(s.length());
        this.hasher.putBytes(s.getBytes(StandardCharsets.UTF_8));
    }
}

