/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;

public class SortedMapIterator
implements InterruptibleIterator {
    private Iterator<Map.Entry<Key, Value>> iter;
    private Map.Entry<Key, Value> entry;
    private SortedMap<Key, Value> map;
    private Range range;
    private AtomicBoolean interruptFlag;
    private int interruptCheckCount = 0;

    public SortedMapIterator deepCopy(IteratorEnvironment env) {
        if (env != null && env.isSamplingEnabled()) {
            throw new SampleNotPresentException();
        }
        return new SortedMapIterator(this.map, this.interruptFlag);
    }

    private SortedMapIterator(SortedMap<Key, Value> map, AtomicBoolean interruptFlag) {
        this.map = map;
        this.iter = null;
        this.range = new Range();
        this.entry = null;
        this.interruptFlag = interruptFlag;
    }

    public SortedMapIterator(SortedMap<Key, Value> map) {
        this(map, null);
    }

    @Override
    public Key getTopKey() {
        return this.entry.getKey();
    }

    @Override
    public Value getTopValue() {
        return this.entry.getValue();
    }

    @Override
    public boolean hasTop() {
        return this.entry != null;
    }

    @Override
    public void next() throws IOException {
        if (this.entry == null) {
            throw new IllegalStateException();
        }
        if (this.interruptFlag != null && this.interruptCheckCount++ % 100 == 0 && this.interruptFlag.get()) {
            throw new IterationInterruptedException();
        }
        if (this.iter.hasNext()) {
            this.entry = this.iter.next();
            if (this.range.afterEndKey(this.entry.getKey())) {
                this.entry = null;
            }
        } else {
            this.entry = null;
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        if (this.interruptFlag != null && this.interruptFlag.get()) {
            throw new IterationInterruptedException();
        }
        this.range = range;
        Key key = range.getStartKey();
        if (key == null) {
            key = new Key();
        }
        this.iter = this.map.tailMap(key).entrySet().iterator();
        if (this.iter.hasNext()) {
            this.entry = this.iter.next();
            if (range.afterEndKey(this.entry.getKey())) {
                this.entry = null;
            }
        } else {
            this.entry = null;
        }
        while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
            this.next();
        }
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInterruptFlag(AtomicBoolean flag) {
        this.interruptFlag = flag;
    }
}

