/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BuilderStyleTest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PrettyPrinter;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MiscTests.class, SmallTests.class})
@Deprecated
public class TestHColumnDescriptor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHColumnDescriptor.class);
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testPb() throws DeserializationException {
        HColumnDescriptor hcd = new HColumnDescriptor(new HColumnDescriptor(HConstants.CATALOG_FAMILY).setInMemory(true).setScope(0).setBloomFilterType(BloomType.NONE).setCacheDataInL1(true));
        int v = 123;
        hcd.setBlocksize(123);
        hcd.setTimeToLive(123);
        hcd.setBlockCacheEnabled(false);
        hcd.setValue("a", "b");
        hcd.setMaxVersions(123);
        Assert.assertEquals((long)123L, (long)hcd.getMaxVersions());
        hcd.setMinVersions(123);
        Assert.assertEquals((long)123L, (long)hcd.getMinVersions());
        hcd.setKeepDeletedCells(KeepDeletedCells.TRUE);
        hcd.setInMemory(true);
        boolean inmemory = hcd.isInMemory();
        hcd.setScope(123);
        hcd.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
        hcd.setBloomFilterType(BloomType.ROW);
        hcd.setCompressionType(Compression.Algorithm.SNAPPY);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(1000L);
        hcd.setDFSReplication((short)123);
        byte[] bytes = hcd.toByteArray();
        HColumnDescriptor deserializedHcd = HColumnDescriptor.parseFrom((byte[])bytes);
        Assert.assertTrue((boolean)hcd.equals((Object)deserializedHcd));
        Assert.assertEquals((long)123L, (long)hcd.getBlocksize());
        Assert.assertEquals((long)123L, (long)hcd.getTimeToLive());
        Assert.assertEquals((long)123L, (long)hcd.getScope());
        Assert.assertEquals((Object)hcd.getValue("a"), (Object)deserializedHcd.getValue("a"));
        Assert.assertEquals((long)hcd.getMaxVersions(), (long)deserializedHcd.getMaxVersions());
        Assert.assertEquals((long)hcd.getMinVersions(), (long)deserializedHcd.getMinVersions());
        Assert.assertEquals((Object)hcd.getKeepDeletedCells(), (Object)deserializedHcd.getKeepDeletedCells());
        Assert.assertEquals((Object)inmemory, (Object)deserializedHcd.isInMemory());
        Assert.assertEquals((long)hcd.getScope(), (long)deserializedHcd.getScope());
        Assert.assertTrue((boolean)deserializedHcd.getCompressionType().equals((Object)Compression.Algorithm.SNAPPY));
        Assert.assertTrue((boolean)deserializedHcd.getDataBlockEncoding().equals((Object)DataBlockEncoding.FAST_DIFF));
        Assert.assertTrue((boolean)deserializedHcd.getBloomFilterType().equals((Object)BloomType.ROW));
        Assert.assertEquals((Object)hcd.isMobEnabled(), (Object)deserializedHcd.isMobEnabled());
        Assert.assertEquals((long)hcd.getMobThreshold(), (long)deserializedHcd.getMobThreshold());
        Assert.assertEquals((long)123L, (long)deserializedHcd.getDFSReplication());
    }

    @Test
    public void testHColumnDescriptorShouldThrowIAEWhenFamilyNameEmpty() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Column Family name can not be empty");
        new HColumnDescriptor(Bytes.toBytes((String)""));
    }

    @Test
    public void testAddGetRemoveConfiguration() throws Exception {
        HColumnDescriptor desc = new HColumnDescriptor("foo");
        String key = "Some";
        String value = "value";
        desc.setConfiguration(key, value);
        Assert.assertEquals((Object)value, (Object)desc.getConfigurationValue(key));
        desc.removeConfiguration(key);
        Assert.assertEquals(null, (Object)desc.getConfigurationValue(key));
    }

    @Test
    public void testMobValuesInHColumnDescriptorShouldReadable() {
        boolean isMob = true;
        long threshold = 1000L;
        String policy = "weekly";
        String isMobString = PrettyPrinter.format((String)String.valueOf(isMob), (PrettyPrinter.Unit)HColumnDescriptor.getUnit((String)"IS_MOB"));
        String thresholdString = PrettyPrinter.format((String)String.valueOf(threshold), (PrettyPrinter.Unit)HColumnDescriptor.getUnit((String)"MOB_THRESHOLD"));
        String policyString = PrettyPrinter.format((String)Bytes.toStringBinary((byte[])Bytes.toBytes((String)policy)), (PrettyPrinter.Unit)HColumnDescriptor.getUnit((String)"MOB_COMPACT_PARTITION_POLICY"));
        Assert.assertEquals((Object)String.valueOf(isMob), (Object)isMobString);
        Assert.assertEquals((Object)String.valueOf(threshold), (Object)thresholdString);
        Assert.assertEquals((Object)String.valueOf(policy), (Object)policyString);
    }

    @Test
    public void testClassMethodsAreBuilderStyle() {
        BuilderStyleTest.assertClassesAreBuilderStyle(HColumnDescriptor.class);
    }

    @Test
    public void testSetTimeToLive() throws HBaseException {
        HColumnDescriptor desc = new HColumnDescriptor("foo");
        String ttl = "50000";
        desc.setTimeToLive(ttl);
        Assert.assertEquals((long)50000L, (long)desc.getTimeToLive());
        ttl = "50000 seconds";
        desc.setTimeToLive(ttl);
        Assert.assertEquals((long)50000L, (long)desc.getTimeToLive());
        ttl = "";
        desc.setTimeToLive(ttl);
        Assert.assertEquals((long)0L, (long)desc.getTimeToLive());
        ttl = "FOREVER";
        desc.setTimeToLive(ttl);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)desc.getTimeToLive());
        ttl = "1 HOUR 10 minutes 1 second";
        desc.setTimeToLive(ttl);
        Assert.assertEquals((long)4201L, (long)desc.getTimeToLive());
        ttl = "500 Days 23 HOURS";
        desc.setTimeToLive(ttl);
        Assert.assertEquals((long)43282800L, (long)desc.getTimeToLive());
        ttl = "43282800 SECONDS (500 Days 23 hours)";
        desc.setTimeToLive(ttl);
        Assert.assertEquals((long)43282800L, (long)desc.getTimeToLive());
    }
}

