/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.tez;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.pig.PigCounters;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POStoreTez;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.PigStatsUtil;
import org.apache.pig.tools.pigstats.tez.TezDAGStats;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.client.VertexStatus;

public class TezVertexStats
extends JobStats {
    private static final Log LOG = LogFactory.getLog(TezVertexStats.class);
    private boolean isMapOpts;
    private int parallelism;
    private VertexStatus.State vertexState;
    private Map<String, Map<String, Long>> counters = null;
    private List<POStore> stores = null;
    private List<POLoad> loads = null;
    private int numTasks = 0;
    private long numInputRecords = 0L;
    private long numReduceInputRecords = 0L;
    private long numOutputRecords = 0L;
    private long fileBytesRead = 0L;
    private long fileBytesWritten = 0L;
    private long spillCount = 0L;
    private long activeSpillCountObj = 0L;
    private long activeSpillCountRecs = 0L;
    private Map<String, Long> multiInputCounters = Maps.newHashMap();
    private Map<String, Long> multiStoreCounters = Maps.newHashMap();

    public TezVertexStats(String name, PigStats.JobGraph plan, boolean isMapOpts) {
        super(name, plan);
        this.isMapOpts = isMapOpts;
    }

    @Override
    public String getJobId() {
        return this.name;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (v instanceof PigStats.JobGraphPrinter) {
            PigStats.JobGraphPrinter jpp = (PigStats.JobGraphPrinter)v;
            jpp.visit(this);
        }
    }

    @Override
    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-10s ", this.name));
        if (this.state == JobStats.JobState.FAILED) {
            sb.append(this.vertexState.name());
        }
        sb.append(String.format("%9s ", this.parallelism));
        sb.append(String.format("%10s ", this.numTasks));
        sb.append(String.format("%14s ", this.numInputRecords));
        sb.append(String.format("%20s ", this.numReduceInputRecords));
        sb.append(String.format("%14s ", this.numOutputRecords));
        sb.append(String.format("%14s ", this.fileBytesRead));
        sb.append(String.format("%16s ", this.fileBytesWritten));
        sb.append(String.format("%14s ", this.hdfsBytesRead));
        sb.append(String.format("%16s ", this.hdfsBytesWritten));
        sb.append(this.getAlias()).append("\t");
        sb.append(this.getFeature()).append("\t");
        for (OutputStats os : this.outputs) {
            sb.append(os.getLocation()).append(",");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        try {
            this.stores = (List)ObjectSerializer.deserialize(conf.get("pig.reduce.stores"));
            this.loads = (List)ObjectSerializer.deserialize(conf.get("pig.loads"));
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to deserialize the store list", (Throwable)e);
        }
    }

    public boolean hasLoadOrStore() {
        return this.loads != null && !this.loads.isEmpty() || this.stores != null && !this.stores.isEmpty();
    }

    public void accumulateStats(VertexStatus status, int parallelism) {
        if (status != null) {
            Map<String, Long> pigCounters;
            this.setSuccessful(status.getState().equals((Object)VertexStatus.State.SUCCEEDED));
            this.vertexState = status.getState();
            this.parallelism = parallelism;
            this.numTasks = status.getProgress().getTotalTaskCount();
            TezCounters tezCounters = status.getVertexCounters();
            this.counters = Maps.newHashMap();
            for (CounterGroup grp : tezCounters) {
                Iterator cntIt = grp.iterator();
                HashMap cntMap = Maps.newHashMap();
                while (cntIt.hasNext()) {
                    TezCounter cnt = (TezCounter)cntIt.next();
                    cntMap.put(cnt.getName(), cnt.getValue());
                }
                this.counters.put(grp.getName(), cntMap);
            }
            Map<String, Long> fsCounters = this.counters.get(TezDAGStats.FS_COUNTER_GROUP);
            if (fsCounters != null) {
                if (fsCounters.containsKey("HDFS_BYTES_READ")) {
                    this.hdfsBytesRead = fsCounters.get("HDFS_BYTES_READ");
                }
                if (fsCounters.containsKey("HDFS_BYTES_WRITTEN")) {
                    this.hdfsBytesWritten = fsCounters.get("HDFS_BYTES_WRITTEN");
                }
                if (fsCounters.containsKey("FILE_BYTES_READ")) {
                    this.fileBytesRead = fsCounters.get("FILE_BYTES_READ");
                }
                if (fsCounters.containsKey("FILE_BYTES_WRITTEN")) {
                    this.fileBytesWritten = fsCounters.get("FILE_BYTES_WRITTEN");
                }
            }
            if ((pigCounters = this.counters.get(TezDAGStats.PIG_COUNTER_GROUP)) != null) {
                if (pigCounters.containsKey((Object)PigCounters.SPILLABLE_MEMORY_MANAGER_SPILL_COUNT)) {
                    this.spillCount = pigCounters.get((Object)PigCounters.SPILLABLE_MEMORY_MANAGER_SPILL_COUNT);
                }
                if (pigCounters.containsKey((Object)PigCounters.PROACTIVE_SPILL_COUNT_BAGS)) {
                    this.activeSpillCountObj = pigCounters.get((Object)PigCounters.PROACTIVE_SPILL_COUNT_BAGS);
                }
                if (pigCounters.containsKey((Object)PigCounters.PROACTIVE_SPILL_COUNT_RECS)) {
                    this.activeSpillCountRecs = pigCounters.get((Object)PigCounters.PROACTIVE_SPILL_COUNT_RECS);
                }
            }
            this.addInputStatistics();
            this.addOutputStatistics();
        }
    }

    public Map<String, Map<String, Long>> getCounters() {
        return this.counters;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void addInputStatistics() {
        long inputRecords = -1L;
        Map<String, Long> taskCounters = this.counters.get(TezDAGStats.TASK_COUNTER_GROUP);
        if (taskCounters != null) {
            if (taskCounters.get(TaskCounter.INPUT_RECORDS_PROCESSED.name()) != null) {
                this.numInputRecords = inputRecords = taskCounters.get(TaskCounter.INPUT_RECORDS_PROCESSED.name()).longValue();
            }
            if (taskCounters.get(TaskCounter.REDUCE_INPUT_RECORDS.name()) != null) {
                this.numReduceInputRecords = taskCounters.get(TaskCounter.REDUCE_INPUT_RECORDS.name());
            }
        }
        if (this.loads == null) {
            return;
        }
        Map<String, Long> mIGroup = this.counters.get("MultiInputCounters");
        if (mIGroup != null) {
            this.multiInputCounters.putAll(mIGroup);
        }
        for (POLoad fs : this.loads) {
            long records = -1L;
            long hdfsBytesRead = -1L;
            String filename = fs.getLFile().getFileName();
            if (this.counters != null) {
                Long n;
                if (mIGroup != null && (n = mIGroup.get(PigStatsUtil.getMultiInputsCounterName(fs.getLFile().getFileName(), 0))) != null) {
                    records = n;
                }
                if (records == -1L) {
                    records = inputRecords;
                }
                if (this.isSuccessful() && records == -1L) {
                    records = 0L;
                }
                if (this.counters.get(TezDAGStats.FS_COUNTER_GROUP) != null && this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_READ") != null) {
                    hdfsBytesRead = this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_READ");
                }
            }
            InputStats is = new InputStats(filename, hdfsBytesRead, records, this.state == JobStats.JobState.SUCCESS);
            is.setConf(this.conf);
            this.inputs.add(is);
        }
    }

    public void addOutputStatistics() {
        long outputRecords = -1L;
        Map<String, Long> taskCounters = this.counters.get(TezDAGStats.TASK_COUNTER_GROUP);
        if (taskCounters != null && taskCounters.get(TaskCounter.OUTPUT_RECORDS.name()) != null) {
            this.numOutputRecords = outputRecords = taskCounters.get(TaskCounter.OUTPUT_RECORDS.name()).longValue();
        }
        if (this.stores == null) {
            return;
        }
        Map<String, Long> msGroup = this.counters.get("MultiStoreCounters");
        if (msGroup != null) {
            this.multiStoreCounters.putAll(msGroup);
        }
        HashMap<String, ArrayList<POStoreTez>> uniqueOutputs = new HashMap<String, ArrayList<POStoreTez>>();
        for (POStore sto : this.stores) {
            POStoreTez store = (POStoreTez)sto;
            ArrayList<POStoreTez> stores = (ArrayList<POStoreTez>)uniqueOutputs.get(store.getOutputKey());
            if (stores == null) {
                stores = new ArrayList<POStoreTez>();
            }
            stores.add(store);
            uniqueOutputs.put(store.getOutputKey(), stores);
        }
        for (List stores : uniqueOutputs.values()) {
            POStore sto = (POStore)stores.get(0);
            if (sto.isTmpStore()) continue;
            long records = -1L;
            long hdfsBytesWritten = -1L;
            String filename = sto.getSFile().getFileName();
            if (this.counters != null) {
                if (msGroup != null) {
                    long n = 0L;
                    Long val = null;
                    for (POStore store : stores) {
                        val = msGroup.get(PigStatsUtil.getMultiStoreCounterName(store));
                        if (val == null) continue;
                        n += val.longValue();
                    }
                    records = n;
                }
                if (this.isSuccessful() && records == -1L) {
                    records = 0L;
                }
            }
            if (!sto.isMultiStore() && this.counters.get(TezDAGStats.FS_COUNTER_GROUP) != null && this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_WRITTEN") != null) {
                hdfsBytesWritten = this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_WRITTEN");
            } else {
                try {
                    hdfsBytesWritten = JobStats.getOutputSize(sto, this.conf);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error while getting the bytes written for the output " + sto.getSFile()), (Throwable)e);
                }
            }
            OutputStats os = new OutputStats(filename, hdfsBytesWritten, records, this.state == JobStats.JobState.SUCCESS);
            os.setPOStore(sto);
            os.setConf(this.conf);
            this.outputs.add(os);
        }
    }

    @Override
    @Deprecated
    public int getNumberMaps() {
        return this.isMapOpts ? this.numTasks : 0;
    }

    @Override
    @Deprecated
    public int getNumberReduces() {
        return this.isMapOpts ? 0 : this.numTasks;
    }

    @Override
    @Deprecated
    public long getMaxMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMinMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getAvgMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMaxReduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMinReduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getAvgREduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMapInputRecords() {
        return this.isMapOpts ? this.numInputRecords : 0L;
    }

    @Override
    @Deprecated
    public long getMapOutputRecords() {
        return this.isMapOpts ? this.numOutputRecords : 0L;
    }

    @Override
    @Deprecated
    public long getReduceInputRecords() {
        return this.numReduceInputRecords;
    }

    @Override
    @Deprecated
    public long getReduceOutputRecords() {
        return this.isMapOpts ? 0L : this.numOutputRecords;
    }

    @Override
    public long getSMMSpillCount() {
        return this.spillCount;
    }

    @Override
    public long getProactiveSpillCountObjects() {
        return this.activeSpillCountObj;
    }

    @Override
    public long getProactiveSpillCountRecs() {
        return this.activeSpillCountRecs;
    }

    @Override
    @Deprecated
    public Counters getHadoopCounters() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Map<String, Long> getMultiStoreCounters() {
        return Collections.unmodifiableMap(this.multiStoreCounters);
    }

    @Override
    @Deprecated
    public Map<String, Long> getMultiInputCounters() {
        throw new UnsupportedOperationException();
    }
}

