/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.pig.PigCounters;
import org.apache.pig.backend.hadoop.executionengine.tez.TezJob;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPrinter;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.tez.TezScriptState;
import org.apache.pig.tools.pigstats.tez.TezVertexStats;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.VertexStatus;

public class TezDAGStats
extends JobStats {
    private static final Log LOG = LogFactory.getLog(TezDAGStats.class);
    public static final String DAG_COUNTER_GROUP = DAGCounter.class.getName();
    public static final String FS_COUNTER_GROUP = FileSystemCounter.class.getName();
    public static final String TASK_COUNTER_GROUP = TaskCounter.class.getName();
    public static final String PIG_COUNTER_GROUP = PigCounters.class.getName();
    public static final String SUCCESS_HEADER = String.format("VertexId Parallelism TotalTasks %1$14s %2$20s %3$14s %4$14s %5$16s %6$14s %7$16s Alias\tFeature\tOutputs", "InputRecords", "ReduceInputRecords", "OutputRecords", "FileBytesRead", "FileBytesWritten", "HdfsBytesRead", "HdfsBytesWritten");
    public static final String FAILURE_HEADER = String.format("VertexId  State Parallelism TotalTasks %1$14s %2$20s %3$14s %4$14s %5$16s %6$14s %7$16s Alias\tFeature\tOutputs", "InputRecords", "ReduceInputRecords", "OutputRecords", "FileBytesRead", "FileBytesWritten", "HdfsBytesRead", "HdfsBytesWritten");
    private Map<String, TezVertexStats> tezVertexStatsMap;
    private String appId;
    private StringBuilder tezDAGPlan;
    private int totalTasks = -1;
    private long fileBytesRead = -1L;
    private long fileBytesWritten = -1L;
    private Counters counters = null;
    private int numberMaps = 0;
    private int numberReduces = 0;
    private long mapInputRecords = 0L;
    private long mapOutputRecords = 0L;
    private long reduceInputRecords = 0L;
    private long reduceOutputRecords = 0L;
    private long spillCount = 0L;
    private long activeSpillCountObj = 0L;
    private long activeSpillCountRecs = 0L;
    private Map<String, Long> multiStoreCounters = new HashMap<String, Long>();
    private Map<String, OutputStats> outputsByLocation = new HashMap<String, OutputStats>();

    protected TezDAGStats(String name, PigStats.JobGraph plan, Map<String, TezVertexStats> tezVertexStatsMap, StringBuilder tezDAGPlan) {
        super(name, plan);
        this.tezVertexStatsMap = tezVertexStatsMap;
        this.tezDAGPlan = tezDAGPlan;
    }

    public TezVertexStats getVertexStats(String vertexName) {
        return this.tezVertexStatsMap.get(vertexName);
    }

    void setAlias(TezScriptState.TezDAGScriptInfo dagScriptInfo) {
        this.annotate("JobStatistics:alias", dagScriptInfo.getAlias());
        this.annotate("JobStatistics:alias_location", dagScriptInfo.getAliasLocation());
        this.annotate("JobStatistics:feature", dagScriptInfo.getPigFeatures());
    }

    public void accumulateStats(TezJob tezJob) throws IOException {
        this.appId = tezJob.getApplicationId().toString().replace("application", "job");
        this.setConf(tezJob.getConfiguration());
        DAG dag = tezJob.getDAG();
        this.hdfsBytesRead = -1L;
        this.hdfsBytesWritten = -1L;
        TezCounters tezCounters = tezJob.getDAGCounters();
        if (tezCounters != null) {
            this.counters = this.covertToHadoopCounters(tezCounters);
            CounterGroup dagGrp = (CounterGroup)tezCounters.getGroup(DAG_COUNTER_GROUP);
            this.totalTasks = (int)dagGrp.findCounter("TOTAL_LAUNCHED_TASKS").getValue();
            CounterGroup fsGrp = (CounterGroup)tezCounters.getGroup(FS_COUNTER_GROUP);
            this.fileBytesRead = fsGrp.findCounter("FILE_BYTES_READ").getValue();
            this.fileBytesWritten = fsGrp.findCounter("FILE_BYTES_WRITTEN").getValue();
            this.hdfsBytesRead = fsGrp.findCounter("HDFS_BYTES_READ").getValue();
            this.hdfsBytesWritten = fsGrp.findCounter("HDFS_BYTES_WRITTEN").getValue();
        } else {
            LOG.warn((Object)("Failed to get counters for DAG: " + dag.getName()));
        }
        for (Map.Entry<String, TezVertexStats> entry : this.tezVertexStatsMap.entrySet()) {
            Vertex v = dag.getVertex(entry.getKey());
            if (v == null || !this.tezVertexStatsMap.containsKey(v.getName())) continue;
            TezVertexStats vertexStats = entry.getValue();
            UserPayload payload = v.getProcessorDescriptor().getUserPayload();
            Configuration conf = TezUtils.createConfFromUserPayload((UserPayload)payload);
            vertexStats.setConf(conf);
            VertexStatus status = tezJob.getVertexStatus(v.getName());
            if (status == null) {
                LOG.warn((Object)("Failed to get status for vertex: " + v.getName()));
                continue;
            }
            vertexStats.accumulateStats(status, v.getParallelism());
            if (vertexStats.getInputs() != null && !vertexStats.getInputs().isEmpty()) {
                this.inputs.addAll(vertexStats.getInputs());
            }
            if (vertexStats.getOutputs() != null && !vertexStats.getOutputs().isEmpty()) {
                for (OutputStats output : vertexStats.getOutputs()) {
                    if (this.outputsByLocation.get(output.getLocation()) != null) {
                        OutputStats existingOut = this.outputsByLocation.get(output.getLocation());
                        if (output.getPOStore().isMultiStore()) {
                            existingOut.setBytes(output.getBytes());
                            existingOut.setPOStore(output.getPOStore());
                        } else if (!existingOut.getPOStore().isMultiStore() && output.getBytes() > -1L) {
                            long bytes = existingOut.getBytes() > -1L ? existingOut.getBytes() + output.getBytes() : output.getBytes();
                            existingOut.setBytes(bytes);
                        }
                        if (output.getRecords() <= -1L) continue;
                        long records = existingOut.getRecords() > -1L ? existingOut.getRecords() + output.getRecords() : output.getRecords();
                        existingOut.setRecords(records);
                        continue;
                    }
                    this.outputs.add(output);
                    this.outputsByLocation.put(output.getLocation(), output);
                }
            }
            if (!vertexStats.getMultiStoreCounters().isEmpty()) {
                this.multiStoreCounters.putAll(vertexStats.getMultiStoreCounters());
            }
            this.numberMaps += vertexStats.getNumberMaps();
            this.numberReduces += vertexStats.getNumberReduces();
            this.mapInputRecords += vertexStats.getMapInputRecords();
            this.mapOutputRecords += vertexStats.getMapOutputRecords();
            this.reduceInputRecords += vertexStats.getReduceInputRecords();
            this.reduceOutputRecords += vertexStats.getReduceOutputRecords();
            this.spillCount += vertexStats.getSMMSpillCount();
            this.activeSpillCountObj += vertexStats.getProactiveSpillCountObjects();
            this.activeSpillCountRecs += vertexStats.getProactiveSpillCountRecs();
        }
    }

    private Counters covertToHadoopCounters(TezCounters tezCounters) {
        Counters counters = new Counters();
        for (CounterGroup tezGrp : tezCounters) {
            Counters.Group grp = (Counters.Group)counters.addGroup(tezGrp.getName(), tezGrp.getDisplayName());
            for (TezCounter counter : tezGrp) {
                grp.addCounter(counter.getName(), counter.getDisplayName(), counter.getValue());
            }
        }
        return counters;
    }

    @Override
    public String getJobId() {
        return this.appId;
    }

    public void setJobId(String appId) {
        this.appId = appId;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (v instanceof PigStats.JobGraphPrinter) {
            PigStats.JobGraphPrinter jpp = (PigStats.JobGraphPrinter)v;
            jpp.visit(this);
        }
    }

    @Override
    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%1$40s: %2$-100s%n", "Name", this.name));
        sb.append(String.format("%1$40s: %2$-100s%n", "ApplicationId", this.appId));
        sb.append(String.format("%1$40s: %2$-100s%n", "TotalLaunchedTasks", this.totalTasks));
        sb.append(String.format("%1$40s: %2$-100s%n", "FileBytesRead", this.fileBytesRead));
        sb.append(String.format("%1$40s: %2$-100s%n", "FileBytesWritten", this.fileBytesWritten));
        sb.append(String.format("%1$40s: %2$-100s%n", "HdfsBytesRead", this.hdfsBytesRead));
        sb.append(String.format("%1$40s: %2$-100s%n", "HdfsBytesWritten", this.hdfsBytesWritten));
        sb.append(String.format("%1$40s: %2$-100s%n", "SpillableMemoryManager spill count", this.spillCount));
        sb.append(String.format("%1$40s: %2$-100s%n", "Bags proactively spilled", this.activeSpillCountObj));
        sb.append(String.format("%1$40s: %2$-100s%n", "Records proactively spilled", this.activeSpillCountRecs));
        sb.append("\nDAG Plan:\n");
        sb.append((CharSequence)this.tezDAGPlan);
        List<JobStats> success = ((PigStats.JobGraph)this.getPlan()).getSuccessfulJobs();
        List<JobStats> failed = ((PigStats.JobGraph)this.getPlan()).getFailedJobs();
        if (success != null && !success.isEmpty()) {
            sb.append("\nVertex Stats:\n");
            sb.append(SUCCESS_HEADER).append("\n");
            for (JobStats js : success) {
                sb.append(js.getDisplayString());
            }
        }
        if (failed != null && !failed.isEmpty()) {
            sb.append("\nFailed vertices:\n");
            sb.append(FAILURE_HEADER).append("\n");
            for (JobStats js : failed) {
                sb.append(js.getDisplayString());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    @Deprecated
    public int getNumberMaps() {
        return this.numberMaps;
    }

    @Override
    @Deprecated
    public int getNumberReduces() {
        return this.numberReduces;
    }

    @Override
    @Deprecated
    public long getMaxMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMinMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getAvgMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMaxReduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMinReduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getAvgREduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMapInputRecords() {
        return this.mapInputRecords;
    }

    @Override
    @Deprecated
    public long getMapOutputRecords() {
        return this.mapOutputRecords;
    }

    @Override
    @Deprecated
    public long getReduceInputRecords() {
        return this.reduceInputRecords;
    }

    @Override
    @Deprecated
    public long getReduceOutputRecords() {
        return this.reduceOutputRecords;
    }

    @Override
    public long getSMMSpillCount() {
        return this.spillCount;
    }

    @Override
    public long getProactiveSpillCountObjects() {
        return this.activeSpillCountObj;
    }

    @Override
    public long getProactiveSpillCountRecs() {
        return this.activeSpillCountRecs;
    }

    @Override
    @Deprecated
    public Counters getHadoopCounters() {
        return this.counters;
    }

    @Override
    @Deprecated
    public Map<String, Long> getMultiStoreCounters() {
        return this.multiStoreCounters;
    }

    @Override
    @Deprecated
    public Map<String, Long> getMultiInputCounters() {
        throw new UnsupportedOperationException();
    }

    static class TezDAGStatsBuilder
    extends TezOpPlanVisitor {
        private TezPlanContainerNode tezPlanNode;
        private PigStats.JobGraph jobPlan;
        private Map<String, TezVertexStats> tezVertexStatsMap;
        private List<TezVertexStats> vertexStatsToBeRemoved;
        private TezScriptState.TezDAGScriptInfo dagScriptInfo;
        private StringBuilder tezDAGPlan;

        public TezDAGStatsBuilder(TezPlanContainerNode tezPlanNode, TezScriptState.TezDAGScriptInfo dagScriptInfo) {
            super(tezPlanNode.getTezOperPlan(), (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(tezPlanNode.getTezOperPlan()));
            this.tezPlanNode = tezPlanNode;
            this.tezVertexStatsMap = new HashMap<String, TezVertexStats>();
            this.vertexStatsToBeRemoved = new ArrayList<TezVertexStats>();
            this.jobPlan = new PigStats.JobGraph();
            this.tezDAGPlan = new StringBuilder();
            this.dagScriptInfo = dagScriptInfo;
        }

        public TezDAGStats build() throws VisitorException {
            this.visit();
            TezDAGStats dagStats = new TezDAGStats(this.tezPlanNode.getOperatorKey().toString(), this.jobPlan, this.tezVertexStatsMap, this.tezDAGPlan);
            dagStats.setAlias(this.dagScriptInfo);
            return dagStats;
        }

        @Override
        public void visitTezOp(TezOperator tezOp) throws VisitorException {
            TezPrinter.TezVertexGraphPrinter.writePlan((TezOperPlan)this.mPlan, tezOp, this.tezDAGPlan);
            TezVertexStats currStats = new TezVertexStats(tezOp.getOperatorKey().toString(), this.jobPlan, tezOp.isUseMRMapSettings());
            this.jobPlan.add(currStats);
            List<TezOperator> preds = ((TezOperPlan)this.getPlan()).getPredecessors(tezOp);
            if (preds != null) {
                for (TezOperator pred : preds) {
                    TezVertexStats predStats = this.tezVertexStatsMap.get(pred);
                    if (this.jobPlan.isConnected(predStats, currStats)) continue;
                    this.jobPlan.connect(predStats, currStats);
                }
            }
            if (tezOp.isVertexGroup()) {
                this.vertexStatsToBeRemoved.add(currStats);
            } else {
                currStats.annotate("JobStatistics:alias", this.dagScriptInfo.getAlias(tezOp));
                currStats.annotate("JobStatistics:alias_location", this.dagScriptInfo.getAliasLocation(tezOp));
                currStats.annotate("JobStatistics:feature", this.dagScriptInfo.getPigFeatures(tezOp));
            }
            this.tezVertexStatsMap.put(tezOp.getOperatorKey().toString(), currStats);
        }

        @Override
        public void visit() throws VisitorException {
            super.visit();
            try {
                for (TezVertexStats vertexStats : this.vertexStatsToBeRemoved) {
                    this.jobPlan.removeAndReconnect(vertexStats);
                }
            }
            catch (FrontendException e) {
                LOG.warn((Object)"Unable to build Tez DAG", (Throwable)e);
            }
        }
    }
}

