/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.ozone.shell.Shell;
import org.jline.console.CommandRegistry;
import org.jline.console.SystemRegistry;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.widget.TailTipWidgets;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

class REPL {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    REPL(Shell shell, CommandLine cmd, PicocliCommands.PicocliCommandsFactory factory, List<String> lines) {
        DefaultParser parser = new DefaultParser();
        Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
        TerminalBuilder terminalBuilder = TerminalBuilder.builder().dumb(true);
        try (Terminal terminal = terminalBuilder.build();){
            int batchSize;
            factory.setTerminal(terminal);
            PicocliCommands picocliCommands = new PicocliCommands(cmd);
            picocliCommands.name(shell.name());
            SystemRegistryImpl registry = new SystemRegistryImpl((Parser)parser, terminal, workDir, null);
            registry.setCommandRegistries(new CommandRegistry[]{picocliCommands});
            registry.register("help", (CommandRegistry)picocliCommands);
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(registry.completer()).parser((Parser)parser).variable("list-max", (Object)50).build();
            if (!"dumb".equals(terminal.getType()) && !"dumb-color".equals(terminal.getType())) {
                TailTipWidgets widgets = new TailTipWidgets(reader, arg_0 -> ((SystemRegistry)registry).commandDescription(arg_0), 5, TailTipWidgets.TipType.COMPLETER);
                widgets.enable();
            }
            String prompt = shell.prompt() + "> ";
            int n = batchSize = lines == null ? 0 : lines.size();
            if (batchSize > 0) {
                terminal.echo(true);
                reader.addCommandsInBuffer(lines);
            }
            for (int i = 0; batchSize == 0 || i < batchSize; ++i) {
                try {
                    registry.cleanUp();
                    String line = reader.readLine(prompt, null, (MaskingCallback)null, null);
                    registry.execute(line);
                    continue;
                }
                catch (UserInterruptException line) {
                    continue;
                }
                catch (EndOfFileException e) {
                    if (terminal == null) return;
                    terminal.close();
                    return;
                }
                catch (Exception e) {
                    try {
                        registry.trace((Throwable)e);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            shell.printError(e);
        }
    }
}

