/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.replicas;

import java.util.Collections;
import java.util.List;

public class BlockVerificationResult {
    private final boolean completed;
    private final boolean pass;
    private final List<String> failures;

    public BlockVerificationResult(boolean completed, boolean pass, List<String> failures) {
        this.completed = completed;
        this.pass = pass;
        this.failures = failures;
    }

    public static BlockVerificationResult pass() {
        return new BlockVerificationResult(true, true, Collections.emptyList());
    }

    public static BlockVerificationResult failCheck(String message) {
        return new BlockVerificationResult(true, false, Collections.singletonList(message));
    }

    public static BlockVerificationResult failIncomplete(String message) {
        return new BlockVerificationResult(false, false, Collections.singletonList(message));
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean passed() {
        return this.pass;
    }

    public List<String> getFailures() {
        return this.failures;
    }
}

