/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot.filter;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.snapshot.filter.ReclaimableFilter;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;

public class ReclaimableRenameEntryFilter
extends ReclaimableFilter<String> {
    public ReclaimableRenameEntryFilter(OzoneManager ozoneManager, OmSnapshotManager omSnapshotManager, SnapshotChainManager snapshotChainManager, SnapshotInfo currentSnapshotInfo, KeyManager keyManager, IOzoneManagerLock lock) {
        super(ozoneManager, omSnapshotManager, snapshotChainManager, currentSnapshotInfo, keyManager, lock, 1);
    }

    @Override
    protected Boolean isReclaimable(Table.KeyValue<String, String> renameEntry) throws IOException {
        UncheckedAutoCloseableSupplier<OmSnapshot> previousSnapshot = this.getPreviousOmSnapshot(0);
        Table previousKeyTable = null;
        Table prevDirTable = null;
        if (previousSnapshot != null) {
            previousKeyTable = ((OmSnapshot)previousSnapshot.get()).getMetadataManager().getKeyTable(this.getBucketInfo().getBucketLayout());
            if (this.getBucketInfo().getBucketLayout().isFileSystemOptimized()) {
                prevDirTable = ((OmSnapshot)previousSnapshot.get()).getMetadataManager().getDirectoryTable();
            }
        }
        return this.isRenameEntryReclaimable(renameEntry, prevDirTable, previousKeyTable);
    }

    @Override
    protected String getVolumeName(Table.KeyValue<String, String> keyValue) throws IOException {
        return this.getKeyManager().getMetadataManager().splitRenameKey((String)keyValue.getKey())[0];
    }

    @Override
    protected String getBucketName(Table.KeyValue<String, String> keyValue) throws IOException {
        return this.getKeyManager().getMetadataManager().splitRenameKey((String)keyValue.getKey())[1];
    }

    @SafeVarargs
    private final boolean isRenameEntryReclaimable(Table.KeyValue<String, String> renameEntry, Table<String, ? extends WithObjectID> ... previousTables) throws IOException {
        Table<String, ? extends WithObjectID>[] tableArray = previousTables;
        int n = previousTables.length;
        int n2 = 0;
        while (n2 < n) {
            String prevDbKey;
            WithObjectID withObjectID;
            Table<String, ? extends WithObjectID> previousTable = tableArray[n2];
            if (previousTable != null && (withObjectID = (WithObjectID)previousTable.getIfExist((Object)(prevDbKey = (String)renameEntry.getValue()))) != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

