/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartUploadCleanupService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartUploadCleanupService.class);
    private static final int MPU_INFO_DELETING_CORE_POOL_SIZE = 1;
    private final OzoneManager ozoneManager;
    private final KeyManager keyManager;
    private final ClientId clientId = ClientId.randomId();
    private final Duration expireThreshold;
    private final int mpuPartsLimitPerTask;
    private final AtomicLong submittedMpuInfoCount;
    private final AtomicLong runCount;
    private final AtomicBoolean suspended;

    public MultipartUploadCleanupService(long interval, TimeUnit unit, long timeout, OzoneManager ozoneManager, ConfigurationSource conf) {
        super("MultipartUploadCleanupService", interval, unit, 1, timeout, ozoneManager.getThreadNamePrefix());
        this.ozoneManager = ozoneManager;
        this.keyManager = ozoneManager.getKeyManager();
        long expireMillis = conf.getTimeDuration("ozone.om.open.mpu.expire.threshold", "30d", TimeUnit.MILLISECONDS);
        this.expireThreshold = Duration.ofMillis(expireMillis);
        this.mpuPartsLimitPerTask = conf.getInt("ozone.om.open.mpu.parts.cleanup.limit.per.task", 1000);
        this.submittedMpuInfoCount = new AtomicLong(0L);
        this.runCount = new AtomicLong(0L);
        this.suspended = new AtomicBoolean(false);
    }

    @VisibleForTesting
    public long getRunCount() {
        return this.runCount.get();
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    @VisibleForTesting
    public long getSubmittedMpuInfoCount() {
        return this.submittedMpuInfoCount.get();
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new MultipartUploadCleanupTask());
        return queue;
    }

    private boolean shouldRun() {
        return !this.suspended.get() && this.ozoneManager.isLeaderReady();
    }

    private class MultipartUploadCleanupTask
    implements BackgroundTask {
        private MultipartUploadCleanupTask() {
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() throws Exception {
            if (!MultipartUploadCleanupService.this.shouldRun()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            MultipartUploadCleanupService.this.runCount.incrementAndGet();
            long startTime = Time.monotonicNow();
            List<OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket> expiredMultipartUploads = null;
            try {
                expiredMultipartUploads = MultipartUploadCleanupService.this.keyManager.getExpiredMultipartUploads(MultipartUploadCleanupService.this.expireThreshold, MultipartUploadCleanupService.this.mpuPartsLimitPerTask);
            }
            catch (IOException e) {
                LOG.error("Unable to get expired MPU info, retry in next interval", (Throwable)e);
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            if (expiredMultipartUploads != null && !expiredMultipartUploads.isEmpty()) {
                int numExpiredMultipartUploads = expiredMultipartUploads.stream().mapToInt(OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket::getMultipartUploadsCount).sum();
                OzoneManagerProtocolProtos.OMRequest omRequest = this.createRequest(expiredMultipartUploads);
                this.submitRequest(omRequest);
                LOG.debug("Number of expired multipart info submitted for deletion: {}, elapsed time: {}ms", (Object)numExpiredMultipartUploads, (Object)(Time.monotonicNow() - startTime));
                MultipartUploadCleanupService.this.submittedMpuInfoCount.addAndGet(numExpiredMultipartUploads);
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        private OzoneManagerProtocolProtos.OMRequest createRequest(List<OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket> expiredMultipartUploadsBuckets) {
            OzoneManagerProtocolProtos.MultipartUploadsExpiredAbortRequest request = OzoneManagerProtocolProtos.MultipartUploadsExpiredAbortRequest.newBuilder().addAllExpiredMultipartUploadsPerBucket(expiredMultipartUploadsBuckets).build();
            OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.AbortExpiredMultiPartUploads).setMultipartUploadsExpiredAbortRequest(request).setClientId(MultipartUploadCleanupService.this.clientId.toString()).build();
            return omRequest;
        }

        private void submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
            try {
                OzoneManagerRatisUtils.submitRequest(MultipartUploadCleanupService.this.ozoneManager, omRequest, MultipartUploadCleanupService.this.clientId, MultipartUploadCleanupService.this.runCount.get());
            }
            catch (ServiceException e) {
                LOG.error("Expired multipart info delete request failed. Will retry at next run.", (Throwable)e);
            }
        }
    }
}

