/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.DeleteKeysResult;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.service.AbstractKeyDeletingService;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.om.snapshot.filter.ReclaimableDirFilter;
import org.apache.hadoop.ozone.om.snapshot.filter.ReclaimableKeyFilter;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.function.CheckedFunction;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryDeletingService
extends AbstractKeyDeletingService {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryDeletingService.class);
    private int ratisByteLimit;
    private final SnapshotChainManager snapshotChainManager;
    private final boolean deepCleanSnapshots;
    private ExecutorService deletionThreadPool;
    private final int numberOfParallelThreadsPerStore;
    private final AtomicLong deletedDirsCount;
    private final AtomicLong movedDirsCount;
    private final AtomicLong movedFilesCount;
    private final int pathLimitPerTask;

    public DirectoryDeletingService(long interval, TimeUnit unit, long serviceTimeout, OzoneManager ozoneManager, OzoneConfiguration configuration, int dirDeletingServiceCorePoolSize, boolean deepCleanSnapshots) {
        super(DirectoryDeletingService.class.getSimpleName(), interval, unit, dirDeletingServiceCorePoolSize, serviceTimeout, ozoneManager);
        int limit = (int)configuration.getStorageSize("ozone.om.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        this.numberOfParallelThreadsPerStore = dirDeletingServiceCorePoolSize;
        this.deletionThreadPool = new ThreadPoolExecutor(0, this.numberOfParallelThreadsPerStore, interval, unit, new LinkedBlockingDeque<Runnable>(Integer.MAX_VALUE));
        this.ratisByteLimit = (int)((double)limit * 0.9);
        this.registerReconfigCallbacks(ozoneManager.getReconfigurationHandler());
        this.snapshotChainManager = ((OmMetadataManagerImpl)ozoneManager.getMetadataManager()).getSnapshotChainManager();
        this.deepCleanSnapshots = deepCleanSnapshots;
        this.deletedDirsCount = new AtomicLong(0L);
        this.movedDirsCount = new AtomicLong(0L);
        this.movedFilesCount = new AtomicLong(0L);
        this.pathLimitPerTask = configuration.getInt("ozone.path.deleting.limit.per.task", 20000);
    }

    public void registerReconfigCallbacks(ReconfigurationHandler handler) {
        handler.registerCompleteCallback((changedKeys, newConf) -> {
            if (changedKeys.containsKey("ozone.directory.deleting.service.interval") || changedKeys.containsKey("ozone.thread.number.dir.deletion")) {
                this.updateAndRestart((OzoneConfiguration)newConf);
            }
        });
    }

    private synchronized void updateAndRestart(OzoneConfiguration conf) {
        long newInterval = conf.getTimeDuration("ozone.directory.deleting.service.interval", "60s", TimeUnit.SECONDS);
        int newCorePoolSize = conf.getInt("ozone.thread.number.dir.deletion", 10);
        LOG.info("Updating and restarting DirectoryDeletingService with interval {} {} and core pool size {}", new Object[]{newInterval, TimeUnit.SECONDS.name().toLowerCase(), newCorePoolSize});
        this.shutdown();
        this.setInterval(newInterval, TimeUnit.SECONDS);
        this.setPoolSize(newCorePoolSize);
        this.start();
    }

    /*
     * Unable to fully structure code
     */
    public BackgroundTaskQueue getTasks() {
        block3: {
            queue = new BackgroundTaskQueue();
            queue.add((BackgroundTask)new DirDeletingTask(null));
            if (!this.deepCleanSnapshots) break block3;
            iterator = null;
            try {
                iterator = this.snapshotChainManager.iterator(true);
                if (true) ** GOTO lbl14
            }
            catch (IOException v0) {
                DirectoryDeletingService.LOG.error("Error while initializing snapshot chain iterator.");
                return queue;
            }
            do {
                snapshotId = iterator.next();
                queue.add((BackgroundTask)new DirDeletingTask(snapshotId));
lbl14:
                // 2 sources

            } while (iterator.hasNext());
        }
        return queue;
    }

    public void shutdown() {
        if (this.deletionThreadPool != null) {
            this.deletionThreadPool.shutdown();
            try {
                if (!this.deletionThreadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.deletionThreadPool.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                this.deletionThreadPool.shutdownNow();
            }
        }
        super.shutdown();
    }

    public synchronized void start() {
        if (this.deletionThreadPool == null || this.deletionThreadPool.isShutdown() || this.deletionThreadPool.isTerminated()) {
            this.deletionThreadPool = new ThreadPoolExecutor(0, this.numberOfParallelThreadsPerStore, super.getIntervalMillis(), TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(Integer.MAX_VALUE));
        }
        super.start();
    }

    private boolean isThreadPoolActive(ExecutorService threadPoolExecutor) {
        return threadPoolExecutor != null && !threadPoolExecutor.isShutdown() && !threadPoolExecutor.isTerminated();
    }

    void optimizeDirDeletesAndSubmitRequest(long dirNum, long subDirNum, long subFileNum, List<Pair<String, OmKeyInfo>> allSubDirList, List<OzoneManagerProtocolProtos.PurgePathRequest> purgePathRequestList, String snapTableKey, long startTime, KeyManager keyManager, CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException> reclaimableDirChecker, CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException> reclaimableFileChecker, Map<OMMetadataManager.VolumeBucketId, OzoneManagerProtocolProtos.BucketNameInfo> bucketNameInfoMap, UUID expectedPreviousSnapshotId, long rnCnt, AtomicInteger remainNum) throws InterruptedException {
        int subdirDelNum = 0;
        int subDirRecursiveCnt = 0;
        while (subDirRecursiveCnt < allSubDirList.size() && remainNum.get() > 0) {
            try {
                Pair<String, OmKeyInfo> stringOmKeyInfoPair = allSubDirList.get(subDirRecursiveCnt++);
                Boolean subDirectoryReclaimable = (Boolean)reclaimableDirChecker.apply((Object)Table.newKeyValue((Object)((String)stringOmKeyInfoPair.getKey()), (Object)((OmKeyInfo)stringOmKeyInfoPair.getValue())));
                Optional<OzoneManagerProtocolProtos.PurgePathRequest> request = this.prepareDeleteDirRequest((OmKeyInfo)stringOmKeyInfoPair.getValue(), (String)stringOmKeyInfoPair.getKey(), subDirectoryReclaimable, allSubDirList, keyManager, reclaimableFileChecker, remainNum);
                if (!request.isPresent()) continue;
                OzoneManagerProtocolProtos.PurgePathRequest requestVal = request.get();
                purgePathRequestList.add(requestVal);
                if (requestVal.hasDeletedDir() && !StringUtils.isBlank((CharSequence)requestVal.getDeletedDir())) {
                    ++subdirDelNum;
                }
                subDirNum += (long)requestVal.getMarkDeletedSubDirsCount();
                subFileNum += (long)requestVal.getDeletedSubFilesCount();
            }
            catch (IOException e) {
                LOG.error("Error while running delete directories and files background task. Will retry at next run for subset.", (Throwable)e);
                break;
            }
        }
        if (!purgePathRequestList.isEmpty()) {
            this.submitPurgePathsWithBatching(purgePathRequestList, snapTableKey, expectedPreviousSnapshotId, bucketNameInfoMap);
        }
        if (dirNum != 0L || subDirNum != 0L || subFileNum != 0L) {
            long subdirMoved = subDirNum - (long)subdirDelNum;
            this.deletedDirsCount.addAndGet(dirNum + (long)subdirDelNum);
            this.movedDirsCount.addAndGet(subdirMoved);
            this.movedFilesCount.addAndGet(subFileNum);
            long timeTakenInIteration = Time.monotonicNow() - startTime;
            LOG.info("Number of dirs deleted: {}, Number of sub-dir deleted: {}, Number of sub-files moved: {} to DeletedTable, Number of sub-dirs moved {} to DeletedDirectoryTable, iteration elapsed: {}ms,  totalRunCount: {}", new Object[]{dirNum, subdirDelNum, subFileNum, subDirNum - (long)subdirDelNum, timeTakenInIteration, rnCnt});
            this.getMetrics().incrementDirectoryDeletionTotalMetrics(dirNum + (long)subdirDelNum, subDirNum, subFileNum);
            this.getPerfMetrics().setDirectoryDeletingServiceLatencyMs(timeTakenInIteration);
        }
    }

    @VisibleForTesting
    public long getDeletedDirsCount() {
        return this.deletedDirsCount.get();
    }

    @VisibleForTesting
    public long getMovedDirsCount() {
        return this.movedDirsCount.get();
    }

    @VisibleForTesting
    public long getMovedFilesCount() {
        return this.movedFilesCount.get();
    }

    private Optional<OzoneManagerProtocolProtos.PurgePathRequest> prepareDeleteDirRequest(OmKeyInfo pendingDeletedDirInfo, String delDirName, boolean purgeDir, List<Pair<String, OmKeyInfo>> subDirList, KeyManager keyManager, CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException> reclaimableFileFilter, AtomicInteger remainNum) throws IOException {
        String purgeDeletedDir;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pending deleted dir name: {}", (Object)pendingDeletedDirInfo.getKeyName());
        }
        OMMetadataManager.VolumeBucketId volumeBucketId = keyManager.getMetadataManager().getVolumeBucketIdPairFSO(delDirName);
        int remainingNum = remainNum.get();
        DeleteKeysResult subDirDeleteResult = keyManager.getPendingDeletionSubDirs(volumeBucketId.getVolumeId(), volumeBucketId.getBucketId(), pendingDeletedDirInfo, (CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException>)((CheckedFunction)keyInfo -> true), remainingNum);
        List<OmKeyInfo> subDirs = subDirDeleteResult.getKeysToDelete();
        remainNum.addAndGet(-subDirs.size());
        OMMetadataManager omMetadataManager = keyManager.getMetadataManager();
        for (OmKeyInfo dirInfo : subDirs) {
            String ozoneDbKey = omMetadataManager.getOzonePathKey(volumeBucketId.getVolumeId(), volumeBucketId.getBucketId(), dirInfo.getParentObjectID(), dirInfo.getFileName());
            String ozoneDeleteKey = omMetadataManager.getOzoneDeletePathKey(dirInfo.getObjectID(), ozoneDbKey);
            subDirList.add((Pair<String, OmKeyInfo>)Pair.of((Object)ozoneDeleteKey, (Object)dirInfo));
            LOG.debug("Moved sub dir name: {}", (Object)dirInfo.getKeyName());
        }
        remainingNum = remainNum.get();
        DeleteKeysResult subFileDeleteResult = keyManager.getPendingDeletionSubFiles(volumeBucketId.getVolumeId(), volumeBucketId.getBucketId(), pendingDeletedDirInfo, (CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException>)((CheckedFunction)keyInfo -> purgeDir || (Boolean)reclaimableFileFilter.apply(keyInfo) != false), remainingNum);
        List<OmKeyInfo> subFiles = subFileDeleteResult.getKeysToDelete();
        remainNum.addAndGet(-subFiles.size());
        if (LOG.isDebugEnabled()) {
            for (OmKeyInfo fileInfo : subFiles) {
                LOG.debug("Moved sub file name: {}", (Object)fileInfo.getKeyName());
            }
        }
        String string = purgeDeletedDir = purgeDir && subDirDeleteResult.isProcessedKeys() && subFileDeleteResult.isProcessedKeys() ? delDirName : null;
        if (purgeDeletedDir == null && subFiles.isEmpty() && subDirs.isEmpty()) {
            return Optional.empty();
        }
        if (purgeDeletedDir != null) {
            remainNum.addAndGet(-1);
        }
        return Optional.of(this.wrapPurgeRequest(volumeBucketId.getVolumeId(), volumeBucketId.getBucketId(), purgeDeletedDir, subFiles, subDirs));
    }

    private OzoneManagerProtocolProtos.PurgePathRequest wrapPurgeRequest(long volumeId, long bucketId, String purgeDeletedDir, List<OmKeyInfo> purgeDeletedFiles, List<OmKeyInfo> markDirsAsDeleted) {
        OzoneManagerProtocolProtos.PurgePathRequest.Builder purgePathsRequest = OzoneManagerProtocolProtos.PurgePathRequest.newBuilder();
        purgePathsRequest.setVolumeId(volumeId);
        purgePathsRequest.setBucketId(bucketId);
        if (purgeDeletedDir != null) {
            purgePathsRequest.setDeletedDir(purgeDeletedDir);
        }
        for (OmKeyInfo purgeFile : purgeDeletedFiles) {
            purgePathsRequest.addDeletedSubFiles(purgeFile.getProtobuf(true, ClientVersion.CURRENT_VERSION));
        }
        for (OmKeyInfo dir : markDirsAsDeleted) {
            purgePathsRequest.addMarkDeletedSubDirs(dir.getProtobuf(ClientVersion.CURRENT_VERSION));
        }
        return purgePathsRequest.build();
    }

    private List<OzoneManagerProtocolProtos.OMResponse> submitPurgePathsWithBatching(List<OzoneManagerProtocolProtos.PurgePathRequest> requests, String snapTableKey, UUID expectedPreviousSnapshotId, Map<OMMetadataManager.VolumeBucketId, OzoneManagerProtocolProtos.BucketNameInfo> bucketNameInfoMap) throws InterruptedException {
        ArrayList<OzoneManagerProtocolProtos.OMResponse> responses = new ArrayList<OzoneManagerProtocolProtos.OMResponse>();
        ArrayList<OzoneManagerProtocolProtos.PurgePathRequest> purgePathRequestBatch = new ArrayList<OzoneManagerProtocolProtos.PurgePathRequest>();
        long batchBytes = 0L;
        for (OzoneManagerProtocolProtos.PurgePathRequest req : requests) {
            int reqSize = req.getSerializedSize();
            if (batchBytes + (long)reqSize > (long)this.ratisByteLimit && !purgePathRequestBatch.isEmpty()) {
                OzoneManagerProtocolProtos.OMResponse resp = this.submitPurgeRequest(snapTableKey, expectedPreviousSnapshotId, bucketNameInfoMap, purgePathRequestBatch);
                if (!resp.getSuccess()) {
                    return Collections.emptyList();
                }
                responses.add(resp);
                purgePathRequestBatch.clear();
                batchBytes = 0L;
            }
            purgePathRequestBatch.add(req);
            batchBytes += (long)reqSize;
        }
        if (!purgePathRequestBatch.isEmpty()) {
            OzoneManagerProtocolProtos.OMResponse resp = this.submitPurgeRequest(snapTableKey, expectedPreviousSnapshotId, bucketNameInfoMap, purgePathRequestBatch);
            if (!resp.getSuccess()) {
                return Collections.emptyList();
            }
            responses.add(resp);
        }
        return responses;
    }

    @VisibleForTesting
    OzoneManagerProtocolProtos.OMResponse submitPurgeRequest(String snapTableKey, UUID expectedPreviousSnapshotId, Map<OMMetadataManager.VolumeBucketId, OzoneManagerProtocolProtos.BucketNameInfo> bucketNameInfoMap, List<OzoneManagerProtocolProtos.PurgePathRequest> pathRequests) throws InterruptedException {
        OzoneManagerProtocolProtos.PurgeDirectoriesRequest.Builder purgeDirRequest = OzoneManagerProtocolProtos.PurgeDirectoriesRequest.newBuilder();
        if (snapTableKey != null) {
            purgeDirRequest.setSnapshotTableKey(snapTableKey);
        }
        OzoneManagerProtocolProtos.NullableUUID.Builder expectedPreviousSnapshotNullableUUID = OzoneManagerProtocolProtos.NullableUUID.newBuilder();
        if (expectedPreviousSnapshotId != null) {
            expectedPreviousSnapshotNullableUUID.setUuid(HddsUtils.toProtobuf((UUID)expectedPreviousSnapshotId));
        }
        purgeDirRequest.setExpectedPreviousSnapshotID(expectedPreviousSnapshotNullableUUID.build());
        purgeDirRequest.addAllDeletedPath(pathRequests);
        purgeDirRequest.addAllBucketNameInfos((Iterable)pathRequests.stream().map(purgePathRequest -> new OMMetadataManager.VolumeBucketId(purgePathRequest.getVolumeId(), purgePathRequest.getBucketId())).distinct().map(bucketNameInfoMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
        OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.PurgeDirectories).setPurgeDirectoriesRequest(purgeDirRequest).setClientId(this.getClientId().toString()).build();
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (BootstrapStateHandler.Lock lock = snapTableKey != null ? this.getBootstrapStateLock().lock() : null;){
                return this.submitRequest(omRequest);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ServiceException e) {
            LOG.error("PurgePaths request failed. Will retry at next run.", (Throwable)e);
            return null;
        }
    }

    private static final class DeletedDirSupplier
    implements Closeable {
        private final TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> deleteTableIterator;

        private DeletedDirSupplier(TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> deleteTableIterator) {
            this.deleteTableIterator = deleteTableIterator;
        }

        private synchronized Table.KeyValue<String, OmKeyInfo> get() {
            if (this.deleteTableIterator.hasNext()) {
                return (Table.KeyValue)this.deleteTableIterator.next();
            }
            return null;
        }

        @Override
        public synchronized void close() {
            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.deleteTableIterator});
        }
    }

    @VisibleForTesting
    final class DirDeletingTask
    implements BackgroundTask {
        private final UUID snapshotId;

        DirDeletingTask(UUID snapshotId) {
            this.snapshotId = snapshotId;
        }

        public int getPriority() {
            return 0;
        }

        private OzoneManagerProtocolProtos.SetSnapshotPropertyRequest getSetSnapshotRequestUpdatingExclusiveSize(long exclusiveSize, long exclusiveReplicatedSize, UUID snapshotID) {
            OzoneManagerProtocolProtos.SnapshotSize snapshotSize = OzoneManagerProtocolProtos.SnapshotSize.newBuilder().setExclusiveSize(exclusiveSize).setExclusiveReplicatedSize(exclusiveReplicatedSize).build();
            return OzoneManagerProtocolProtos.SetSnapshotPropertyRequest.newBuilder().setSnapshotKey(DirectoryDeletingService.this.snapshotChainManager.getTableKey(snapshotID)).setSnapshotSizeDeltaFromDirDeepCleaning(snapshotSize).build();
        }

        @VisibleForTesting
        void processDeletedDirsForStore(SnapshotInfo currentSnapshotInfo, KeyManager keyManager, long rnCnt, int remainNum) throws IOException, ExecutionException, InterruptedException {
            String snapshotTableKey;
            String bucket;
            String volume;
            if (currentSnapshotInfo != null) {
                volume = currentSnapshotInfo.getVolumeName();
                bucket = currentSnapshotInfo.getBucketName();
                snapshotTableKey = currentSnapshotInfo.getTableKey();
            } else {
                volume = null;
                bucket = null;
                snapshotTableKey = null;
            }
            Throwable throwable = null;
            Object var10_10 = null;
            try (DeletedDirSupplier dirSupplier = new DeletedDirSupplier(currentSnapshotInfo == null ? keyManager.getDeletedDirEntries() : keyManager.getDeletedDirEntries(volume, bucket));){
                UUID expectedPreviousSnapshotId = currentSnapshotInfo == null ? DirectoryDeletingService.this.snapshotChainManager.getLatestGlobalSnapshotId() : SnapshotUtils.getPreviousSnapshotId(currentSnapshotInfo, DirectoryDeletingService.this.snapshotChainManager);
                ConcurrentMap exclusiveSizeMap = Maps.newConcurrentMap();
                CompletionStage<Boolean> processedAllDeletedDirs = CompletableFuture.completedFuture(true);
                int i = 0;
                while (i < DirectoryDeletingService.this.numberOfParallelThreadsPerStore) {
                    CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> {
                        try {
                            return this.processDeletedDirectories(currentSnapshotInfo, keyManager, dirSupplier, expectedPreviousSnapshotId, exclusiveSizeMap, rnCnt, remainNum);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            return false;
                        }
                        catch (Throwable throwable) {
                            return false;
                        }
                    }, DirectoryDeletingService.this.isThreadPoolActive(DirectoryDeletingService.this.deletionThreadPool) ? DirectoryDeletingService.this.deletionThreadPool : ForkJoinPool.commonPool());
                    processedAllDeletedDirs = processedAllDeletedDirs.thenCombine(future, (a, b) -> a != false && b != false);
                    ++i;
                }
                if (processedAllDeletedDirs.get().booleanValue()) {
                    ArrayList<OzoneManagerProtocolProtos.SetSnapshotPropertyRequest> setSnapshotPropertyRequests = new ArrayList<OzoneManagerProtocolProtos.SetSnapshotPropertyRequest>();
                    for (Map.Entry entry : exclusiveSizeMap.entrySet()) {
                        UUID snapshotID = (UUID)entry.getKey();
                        long exclusiveSize = (Long)((Pair)entry.getValue()).getLeft();
                        long exclusiveReplicatedSize = (Long)((Pair)entry.getValue()).getRight();
                        setSnapshotPropertyRequests.add(this.getSetSnapshotRequestUpdatingExclusiveSize(exclusiveSize, exclusiveReplicatedSize, snapshotID));
                    }
                    if (currentSnapshotInfo != null) {
                        setSnapshotPropertyRequests.add(OzoneManagerProtocolProtos.SetSnapshotPropertyRequest.newBuilder().setSnapshotKey(snapshotTableKey).setDeepCleanedDeletedDir(true).build());
                    }
                    DirectoryDeletingService.this.submitSetSnapshotRequests(setSnapshotPropertyRequests);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        /*
         * Loose catch block
         */
        private boolean processDeletedDirectories(SnapshotInfo currentSnapshotInfo, KeyManager keyManager, DeletedDirSupplier dirSupplier, UUID expectedPreviousSnapshotId, Map<UUID, Pair<Long, Long>> totalExclusiveSizeMap, long runCount, int remaining) throws InterruptedException {
            OmSnapshotManager omSnapshotManager = DirectoryDeletingService.this.getOzoneManager().getOmSnapshotManager();
            IOzoneManagerLock lock = DirectoryDeletingService.this.getOzoneManager().getMetadataManager().getLock();
            String snapshotTableKey = currentSnapshotInfo == null ? null : currentSnapshotInfo.getTableKey();
            try {
                Throwable throwable = null;
                Object var13_14 = null;
                try {
                    boolean bl;
                    ReclaimableKeyFilter reclaimableFileFilter;
                    ReclaimableDirFilter reclaimableDirFilter;
                    block21: {
                        block20: {
                            reclaimableDirFilter = new ReclaimableDirFilter(DirectoryDeletingService.this.getOzoneManager(), omSnapshotManager, DirectoryDeletingService.this.snapshotChainManager, currentSnapshotInfo, keyManager, lock);
                            reclaimableFileFilter = new ReclaimableKeyFilter(DirectoryDeletingService.this.getOzoneManager(), omSnapshotManager, DirectoryDeletingService.this.snapshotChainManager, currentSnapshotInfo, keyManager, lock);
                            long startTime = Time.monotonicNow();
                            long dirNum = 0L;
                            long subDirNum = 0L;
                            long subFileNum = 0L;
                            ArrayList<OzoneManagerProtocolProtos.PurgePathRequest> purgePathRequestList = new ArrayList<OzoneManagerProtocolProtos.PurgePathRequest>();
                            HashMap<OMMetadataManager.VolumeBucketId, OzoneManagerProtocolProtos.BucketNameInfo> bucketNameInfos = new HashMap<OMMetadataManager.VolumeBucketId, OzoneManagerProtocolProtos.BucketNameInfo>();
                            AtomicInteger remainNum = new AtomicInteger(remaining);
                            ArrayList<Pair<String, OmKeyInfo>> allSubDirList = new ArrayList<Pair<String, OmKeyInfo>>();
                            while (remainNum.get() > 0) {
                                Table.KeyValue pendingDeletedDirInfo = dirSupplier.get();
                                if (pendingDeletedDirInfo == null) break;
                                OmKeyInfo deletedDirInfo = (OmKeyInfo)pendingDeletedDirInfo.getValue();
                                OMMetadataManager.VolumeBucketId volumeBucketId = keyManager.getMetadataManager().getVolumeBucketIdPairFSO((String)pendingDeletedDirInfo.getKey());
                                bucketNameInfos.computeIfAbsent(volumeBucketId, k -> OzoneManagerProtocolProtos.BucketNameInfo.newBuilder().setVolumeId(volumeBucketId.getVolumeId()).setBucketId(volumeBucketId.getBucketId()).setVolumeName(deletedDirInfo.getVolumeName()).setBucketName(deletedDirInfo.getBucketName()).build());
                                boolean isDirReclaimable = reclaimableDirFilter.apply(pendingDeletedDirInfo);
                                Optional request = DirectoryDeletingService.this.prepareDeleteDirRequest((OmKeyInfo)pendingDeletedDirInfo.getValue(), (String)pendingDeletedDirInfo.getKey(), isDirReclaimable, allSubDirList, DirectoryDeletingService.this.getOzoneManager().getKeyManager(), (CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException>)reclaimableFileFilter, remainNum);
                                if (!request.isPresent()) continue;
                                OzoneManagerProtocolProtos.PurgePathRequest purgePathRequest = (OzoneManagerProtocolProtos.PurgePathRequest)request.get();
                                purgePathRequestList.add(purgePathRequest);
                                if (purgePathRequest.hasDeletedDir() && !StringUtils.isBlank((CharSequence)purgePathRequest.getDeletedDir())) {
                                    ++dirNum;
                                }
                                subDirNum += (long)purgePathRequest.getMarkDeletedSubDirsCount();
                                subFileNum += (long)purgePathRequest.getDeletedSubFilesCount();
                            }
                            DirectoryDeletingService.this.optimizeDirDeletesAndSubmitRequest(dirNum, subDirNum, subFileNum, allSubDirList, purgePathRequestList, snapshotTableKey, startTime, DirectoryDeletingService.this.getOzoneManager().getKeyManager(), reclaimableDirFilter, reclaimableFileFilter, bucketNameInfos, expectedPreviousSnapshotId, runCount, remainNum);
                            Map<UUID, Long> exclusiveReplicatedSizeMap = reclaimableFileFilter.getExclusiveReplicatedSizeMap();
                            Map<UUID, Long> exclusiveSizeMap = reclaimableFileFilter.getExclusiveSizeMap();
                            List previousPathSnapshotsInChain = Stream.of(exclusiveSizeMap.keySet(), exclusiveReplicatedSizeMap.keySet()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                            for (UUID snapshot : previousPathSnapshotsInChain) {
                                totalExclusiveSizeMap.compute(snapshot, (k, v) -> {
                                    long exclusiveSize = exclusiveSizeMap.getOrDefault(snapshot, 0L);
                                    long exclusiveReplicatedSize = exclusiveReplicatedSizeMap.getOrDefault(snapshot, 0L);
                                    if (v == null) {
                                        return Pair.of((Object)exclusiveSize, (Object)exclusiveReplicatedSize);
                                    }
                                    return Pair.of((Object)((Long)v.getLeft() + exclusiveSize), (Object)((Long)v.getRight() + exclusiveReplicatedSize));
                                });
                            }
                            bl = purgePathRequestList.isEmpty();
                            if (reclaimableFileFilter == null) break block20;
                            reclaimableFileFilter.close();
                        }
                        if (reclaimableDirFilter == null) break block21;
                        reclaimableDirFilter.close();
                    }
                    return bl;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (reclaimableFileFilter != null) {
                                    reclaimableFileFilter.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (reclaimableDirFilter != null) {
                                    reclaimableDirFilter.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.error("Error while running delete directories for store : {} and files background task. Will retry at next run. ", (Object)snapshotTableKey, (Object)e);
                return false;
            }
        }

        public BackgroundTaskResult call() {
            if (DirectoryDeletingService.this.shouldRun()) {
                long run = DirectoryDeletingService.this.getRunCount().incrementAndGet();
                if (this.snapshotId == null) {
                    LOG.debug("Running DirectoryDeletingService for active object store, {}", (Object)run);
                } else {
                    LOG.debug("Running DirectoryDeletingService for snapshot : {}, {}", (Object)this.snapshotId, (Object)run);
                }
                OmSnapshotManager omSnapshotManager = DirectoryDeletingService.this.getOzoneManager().getOmSnapshotManager();
                SnapshotInfo snapInfo = null;
                try {
                    SnapshotInfo snapshotInfo = snapInfo = this.snapshotId == null ? null : SnapshotUtils.getSnapshotInfo(DirectoryDeletingService.this.getOzoneManager(), DirectoryDeletingService.this.snapshotChainManager, this.snapshotId);
                    if (snapInfo != null) {
                        if (snapInfo.isDeepCleanedDeletedDir()) {
                            LOG.info("Snapshot {} has already been deep cleaned directory. Skipping the snapshot in this iteration.", (Object)snapInfo.getSnapshotId());
                            return BackgroundTaskResult.EmptyTaskResult.newResult();
                        }
                        if (!OmSnapshotManager.areSnapshotChangesFlushedToDB(DirectoryDeletingService.this.getOzoneManager().getMetadataManager(), snapInfo)) {
                            LOG.info("Skipping snapshot processing since changes to snapshot {} have not been flushed to disk", (Object)snapInfo);
                            return BackgroundTaskResult.EmptyTaskResult.newResult();
                        }
                    } else if (!DirectoryDeletingService.this.isPreviousPurgeTransactionFlushed()) {
                        return BackgroundTaskResult.EmptyTaskResult.newResult();
                    }
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (UncheckedAutoCloseableSupplier<OmSnapshot> omSnapshot = snapInfo == null ? null : omSnapshotManager.getActiveSnapshot(snapInfo.getVolumeName(), snapInfo.getBucketName(), snapInfo.getName());){
                        KeyManager keyManager = snapInfo == null ? DirectoryDeletingService.this.getOzoneManager().getKeyManager() : ((OmSnapshot)omSnapshot.get()).getKeyManager();
                        this.processDeletedDirsForStore(snapInfo, keyManager, run, DirectoryDeletingService.this.pathLimitPerTask);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | ExecutionException e) {
                    LOG.error("Error while running delete files background task for store {}. Will retry at next run.", snapInfo, (Object)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.error("Interruption running delete directory background task for store {}.", snapInfo, (Object)e);
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

