/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.util.Collections;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.managed.ManagedIngestExternalFileOptions;

final class RDBSstFileLoader {
    private RDBSstFileLoader() {
    }

    static void load(RocksDatabase db, RocksDatabase.ColumnFamily family, File externalFile) throws RocksDatabaseException {
        if (externalFile.length() == 0L) {
            return;
        }
        try (ManagedIngestExternalFileOptions ingestOptions = new ManagedIngestExternalFileOptions();){
            ingestOptions.setIngestBehind(false);
            db.ingestExternalFile(family, Collections.singletonList(externalFile.getAbsolutePath()), ingestOptions);
        }
    }
}

