/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigGroup(prefix="hdds.container.balancer")
public final class ContainerBalancerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerBalancerConfiguration.class);
    @Config(key="utilization.threshold", type=ConfigType.AUTO, defaultValue="10", tags={ConfigTag.BALANCER}, description="Threshold is a percentage in the range of 0 to 100. A cluster is considered balanced if for each datanode, the utilization of the datanode (used space to capacity ratio) differs from the utilization of the cluster (used space to capacity ratio of the entire cluster) no more than the threshold.")
    private String threshold = "10";
    @Config(key="datanodes.involved.max.percentage.per.iteration", type=ConfigType.INT, defaultValue="20", tags={ConfigTag.BALANCER}, description="Maximum percentage of healthy, in service datanodes that can be involved in balancing in one iteration.")
    private int maxDatanodesPercentageToInvolvePerIteration = 20;
    @Config(key="size.moved.max.per.iteration", type=ConfigType.SIZE, defaultValue="500GB", tags={ConfigTag.BALANCER}, description="The maximum size of data in bytes that will be moved by Container Balancer in one iteration.")
    private long maxSizeToMovePerIteration = 0x7D00000000L;
    @Config(key="size.entering.target.max", type=ConfigType.SIZE, defaultValue="26GB", tags={ConfigTag.BALANCER}, description="The maximum size that can enter a target datanode in each iteration while balancing. This is the sum of data from multiple sources. The value must be greater than the configured (or default) ozone.scm.container.size.")
    private long maxSizeEnteringTarget;
    @Config(key="size.leaving.source.max", type=ConfigType.SIZE, defaultValue="26GB", tags={ConfigTag.BALANCER}, description="The maximum size that can leave a source datanode in each iteration while balancing. This is the sum of data moving to multiple targets. The value must be greater than the configured (or default) ozone.scm.container.size.")
    private long maxSizeLeavingSource;
    @Config(key="iterations", type=ConfigType.INT, defaultValue="10", tags={ConfigTag.BALANCER}, description="The number of iterations that Container Balancer will run for.")
    private int iterations = 10;
    @Config(key="exclude.containers", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.BALANCER}, description="List of container IDs to exclude from balancing. For example \"1, 4, 5\" or \"1,4,5\".")
    private String excludeContainers = "";
    @Config(key="move.timeout", type=ConfigType.TIME, defaultValue="65m", tags={ConfigTag.BALANCER}, description="The amount of time to allow a single container to move from source to target.")
    private long moveTimeout = Duration.ofMinutes(65L).toMillis();
    @Config(key="move.replication.timeout", type=ConfigType.TIME, defaultValue="50m", tags={ConfigTag.BALANCER}, description="The amount of time to allow a single container's replication from source to target as part of container move. For example, if \"hdds.container.balancer.move.timeout\" is 65 minutes, then out of those 65 minutes 50 minutes will be the deadline for replication to complete.")
    private long moveReplicationTimeout = Duration.ofMinutes(50L).toMillis();
    @Config(key="balancing.iteration.interval", type=ConfigType.TIME, defaultValue="70m", tags={ConfigTag.BALANCER}, description="The interval period between each iteration of Container Balancer.")
    private long balancingInterval = Duration.ofMinutes(70L).toMillis();
    @Config(key="include.datanodes", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.BALANCER}, description="A list of Datanode hostnames or ip addresses separated by commas. Only the Datanodes specified in this list are balanced. This configuration is empty by default and is applicable only if it is non-empty.")
    private String includeNodes = "";
    @Config(key="exclude.datanodes", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.BALANCER}, description="A list of Datanode hostnames or ip addresses separated by commas. The Datanodes specified in this list are excluded from balancing. This configuration is empty by default.")
    private String excludeNodes = "";
    @Config(key="move.networkTopology.enable", type=ConfigType.BOOLEAN, defaultValue="false", tags={ConfigTag.BALANCER}, description="whether to take network topology into account when selecting a target for a source. This configuration is false by default.")
    private boolean networkTopologyEnable = false;
    @Config(key="trigger.du.before.move.enable", type=ConfigType.BOOLEAN, defaultValue="false", tags={ConfigTag.BALANCER}, description="whether to send command to all the healthy and in-service data nodes to run du immediately before startinga balance iteration. note that running du is very time consuming , especially when the disk usage rate of a data node is very high")
    private boolean triggerDuEnable = false;

    public double getThreshold() {
        return Double.parseDouble(this.threshold);
    }

    public double getThresholdAsRatio() {
        return Double.parseDouble(this.threshold) / 100.0;
    }

    public void setThreshold(double threshold) {
        if (threshold < 0.0 || threshold >= 100.0) {
            throw new IllegalArgumentException("Threshold must be a percentage(double) in the range 0 to 100.");
        }
        this.threshold = String.valueOf(threshold);
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int count) {
        if (count < -1 || 0 == count) {
            throw new IllegalArgumentException("Iteration count must be greater than 0, or -1(for running balancer infinitely).");
        }
        this.iterations = count;
    }

    public int getMaxDatanodesPercentageToInvolvePerIteration() {
        return this.maxDatanodesPercentageToInvolvePerIteration;
    }

    public Boolean getNetworkTopologyEnable() {
        return this.networkTopologyEnable;
    }

    public Boolean getTriggerDuEnable() {
        return this.triggerDuEnable;
    }

    public void setTriggerDuEnable(boolean enable) {
        this.triggerDuEnable = enable;
    }

    public void setNetworkTopologyEnable(Boolean enable) {
        this.networkTopologyEnable = enable;
    }

    public double getMaxDatanodesRatioToInvolvePerIteration() {
        return (double)this.maxDatanodesPercentageToInvolvePerIteration / 100.0;
    }

    public void setMaxDatanodesPercentageToInvolvePerIteration(int maxDatanodesPercentageToInvolvePerIteration) {
        if (maxDatanodesPercentageToInvolvePerIteration < 0 || maxDatanodesPercentageToInvolvePerIteration > 100) {
            throw new IllegalArgumentException(String.format("Argument %d is illegal. Percentage must be from 0 up to and including 100.", maxDatanodesPercentageToInvolvePerIteration));
        }
        this.maxDatanodesPercentageToInvolvePerIteration = maxDatanodesPercentageToInvolvePerIteration;
    }

    public long getMaxSizeToMovePerIteration() {
        return this.maxSizeToMovePerIteration;
    }

    public void setMaxSizeToMovePerIteration(long maxSizeToMovePerIteration) {
        this.maxSizeToMovePerIteration = maxSizeToMovePerIteration;
    }

    public long getMaxSizeEnteringTarget() {
        return this.maxSizeEnteringTarget;
    }

    public void setMaxSizeEnteringTarget(long maxSizeEnteringTarget) {
        this.maxSizeEnteringTarget = maxSizeEnteringTarget;
    }

    public long getMaxSizeLeavingSource() {
        return this.maxSizeLeavingSource;
    }

    public void setMaxSizeLeavingSource(long maxSizeLeavingSource) {
        this.maxSizeLeavingSource = maxSizeLeavingSource;
    }

    public Set<ContainerID> getExcludeContainers() {
        if (this.excludeContainers.isEmpty()) {
            return new HashSet<ContainerID>();
        }
        return Arrays.stream(this.excludeContainers.split(",")).map(s -> {
            s = s.trim();
            return ContainerID.valueOf(Long.parseLong(s));
        }).collect(Collectors.toSet());
    }

    public void setExcludeContainers(String excludeContainers) {
        this.excludeContainers = excludeContainers;
    }

    public Duration getMoveTimeout() {
        return Duration.ofMillis(this.moveTimeout);
    }

    public void setMoveTimeout(Duration duration) {
        this.moveTimeout = duration.toMillis();
    }

    public void setMoveTimeout(long millis) {
        this.moveTimeout = millis;
    }

    public Duration getMoveReplicationTimeout() {
        return Duration.ofMillis(this.moveReplicationTimeout);
    }

    public void setMoveReplicationTimeout(Duration duration) {
        this.moveReplicationTimeout = duration.toMillis();
    }

    public void setMoveReplicationTimeout(long millis) {
        this.moveReplicationTimeout = millis;
    }

    public Duration getBalancingInterval() {
        return Duration.ofMillis(this.balancingInterval);
    }

    public void setBalancingInterval(Duration balancingInterval) {
        this.balancingInterval = balancingInterval.toMillis();
    }

    public void setBalancingInterval(long millis) {
        this.balancingInterval = millis;
    }

    public Set<String> getIncludeNodes() {
        if (this.includeNodes.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(this.includeNodes.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    public void setIncludeNodes(String includeNodes) {
        this.includeNodes = includeNodes;
    }

    public Set<String> getExcludeNodes() {
        if (this.excludeNodes.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(this.excludeNodes.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    public void setExcludeNodes(String excludeNodes) {
        this.excludeNodes = excludeNodes;
    }

    public String toString() {
        return String.format("Container Balancer Configuration values:%n%-50s %s%n%-50s %s%n%-50s %d%n%-50s %dGB%n%-50s %dGB%n%-50s %dGB%n%-50s %d%n%-50s %dmin%n%-50s %dmin%n%-50s %dmin%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n", "Key", "Value", "Threshold", this.threshold, "Max Datanodes to Involve per Iteration(percent)", this.maxDatanodesPercentageToInvolvePerIteration, "Max Size to Move per Iteration", this.maxSizeToMovePerIteration / 0x40000000L, "Max Size Entering Target per Iteration", this.maxSizeEnteringTarget / 0x40000000L, "Max Size Leaving Source per Iteration", this.maxSizeLeavingSource / 0x40000000L, "Number of Iterations", this.iterations, "Time Limit for Single Container's Movement", Duration.ofMillis(this.moveTimeout).toMinutes(), "Time Limit for Single Container's Replication", Duration.ofMillis(this.moveReplicationTimeout).toMinutes(), "Interval between each Iteration", Duration.ofMillis(this.balancingInterval).toMinutes(), "Whether to Enable Network Topology", this.networkTopologyEnable, "Whether to Trigger Refresh Datanode Usage Info", this.triggerDuEnable, "Container IDs to Exclude from Balancing", this.excludeContainers.equals("") ? "None" : this.excludeContainers, "Datanodes Specified to be Balanced", this.includeNodes.equals("") ? "None" : this.includeNodes, "Datanodes Excluded from Balancing", this.excludeNodes.equals("") ? "None" : this.excludeNodes);
    }

    public HddsProtos.ContainerBalancerConfigurationProto.Builder toProtobufBuilder() {
        HddsProtos.ContainerBalancerConfigurationProto.Builder builder = HddsProtos.ContainerBalancerConfigurationProto.newBuilder();
        builder.setUtilizationThreshold(this.threshold).setDatanodesInvolvedMaxPercentagePerIteration(this.maxDatanodesPercentageToInvolvePerIteration).setSizeMovedMaxPerIteration(this.maxSizeToMovePerIteration).setSizeEnteringTargetMax(this.maxSizeEnteringTarget).setSizeLeavingSourceMax(this.maxSizeLeavingSource).setIterations(this.iterations).setExcludeContainers(this.excludeContainers).setMoveTimeout(this.moveTimeout).setBalancingIterationInterval(this.balancingInterval).setIncludeDatanodes(this.includeNodes).setExcludeDatanodes(this.excludeNodes).setMoveNetworkTopologyEnable(this.networkTopologyEnable).setTriggerDuBeforeMoveEnable(this.triggerDuEnable).setMoveReplicationTimeout(this.moveReplicationTimeout);
        return builder;
    }

    static ContainerBalancerConfiguration fromProtobuf(@Nonnull HddsProtos.ContainerBalancerConfigurationProto proto, @Nonnull OzoneConfiguration ozoneConfiguration) {
        ContainerBalancerConfiguration config = (ContainerBalancerConfiguration)ozoneConfiguration.getObject(ContainerBalancerConfiguration.class);
        if (proto.hasUtilizationThreshold()) {
            config.setThreshold(Double.parseDouble(proto.getUtilizationThreshold()));
        }
        if (proto.hasDatanodesInvolvedMaxPercentagePerIteration()) {
            config.setMaxDatanodesPercentageToInvolvePerIteration(proto.getDatanodesInvolvedMaxPercentagePerIteration());
        }
        if (proto.hasSizeMovedMaxPerIteration()) {
            config.setMaxSizeToMovePerIteration(proto.getSizeMovedMaxPerIteration());
        }
        if (proto.hasSizeEnteringTargetMax()) {
            config.setMaxSizeEnteringTarget(proto.getSizeEnteringTargetMax());
        }
        if (proto.hasSizeLeavingSourceMax()) {
            config.setMaxSizeLeavingSource(proto.getSizeLeavingSourceMax());
        }
        if (proto.hasIterations()) {
            config.setIterations(proto.getIterations());
        }
        if (proto.hasExcludeContainers()) {
            config.setExcludeContainers(proto.getExcludeContainers());
        }
        if (proto.hasMoveTimeout()) {
            config.setMoveTimeout(proto.getMoveTimeout());
        }
        if (proto.hasBalancingIterationInterval()) {
            config.setBalancingInterval(proto.getBalancingIterationInterval());
        }
        if (proto.hasIncludeDatanodes()) {
            config.setIncludeNodes(proto.getIncludeDatanodes());
        }
        if (proto.hasExcludeDatanodes()) {
            config.setExcludeNodes(proto.getExcludeDatanodes());
        }
        if (proto.hasMoveNetworkTopologyEnable()) {
            config.setNetworkTopologyEnable(proto.getMoveNetworkTopologyEnable());
        }
        if (proto.hasTriggerDuBeforeMoveEnable()) {
            config.setTriggerDuEnable(proto.getTriggerDuBeforeMoveEnable());
        }
        if (proto.hasMoveReplicationTimeout()) {
            config.setMoveReplicationTimeout(proto.getMoveReplicationTimeout());
        }
        return config;
    }
}

