/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationQueue;

public final class ContainerCheckRequest {
    private final ContainerInfo containerInfo;
    private final Set<ContainerReplica> containerReplicas;
    private final List<ContainerReplicaOp> pendingOps;
    private final int maintenanceRedundancy;
    private final ReplicationManagerReport report;
    private final ReplicationQueue replicationQueue;
    private final boolean readOnly;

    private ContainerCheckRequest(Builder builder) {
        this.containerInfo = builder.containerInfo;
        this.containerReplicas = Collections.unmodifiableSet(builder.containerReplicas);
        this.pendingOps = Collections.unmodifiableList(builder.pendingOps);
        this.maintenanceRedundancy = builder.maintenanceRedundancy;
        this.report = builder.report;
        this.replicationQueue = builder.replicationQueue;
        this.readOnly = builder.readOnly;
    }

    public List<ContainerReplicaOp> getPendingOps() {
        return this.pendingOps;
    }

    public int getMaintenanceRedundancy() {
        return this.maintenanceRedundancy;
    }

    public Set<ContainerReplica> getContainerReplicas() {
        return this.containerReplicas;
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public ReplicationManagerReport getReport() {
        return this.report;
    }

    public ReplicationQueue getReplicationQueue() {
        return this.replicationQueue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static class Builder {
        private ContainerInfo containerInfo;
        private Set<ContainerReplica> containerReplicas;
        private List<ContainerReplicaOp> pendingOps;
        private int maintenanceRedundancy;
        private ReplicationManagerReport report;
        private ReplicationQueue replicationQueue;
        private boolean readOnly = false;

        public Builder setContainerInfo(ContainerInfo containerInfo) {
            this.containerInfo = containerInfo;
            return this;
        }

        public Builder setContainerReplicas(Set<ContainerReplica> containerReplicas) {
            this.containerReplicas = containerReplicas;
            return this;
        }

        public Builder setPendingOps(List<ContainerReplicaOp> pendingOps) {
            this.pendingOps = pendingOps;
            return this;
        }

        public Builder setMaintenanceRedundancy(int maintenanceRedundancy) {
            this.maintenanceRedundancy = maintenanceRedundancy;
            return this;
        }

        public Builder setReplicationQueue(ReplicationQueue repQueue) {
            this.replicationQueue = repQueue;
            return this;
        }

        public Builder setReport(ReplicationManagerReport report) {
            this.report = report;
            return this;
        }

        public Builder setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public ContainerCheckRequest build() {
            return new ContainerCheckRequest(this);
        }
    }
}

