/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;

public final class ContainerReplica
implements Comparable<ContainerReplica> {
    private final ContainerID containerID;
    private final StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state;
    private final DatanodeDetails datanodeDetails;
    private final DatanodeID originDatanodeId;
    private final int replicaIndex;
    private final Long sequenceId;
    private final long keyCount;
    private final long bytesUsed;
    private final boolean isEmpty;
    private final long dataChecksum;

    private ContainerReplica(ContainerReplicaBuilder b) {
        this.containerID = Objects.requireNonNull(b.containerID, "containerID == null");
        this.state = Objects.requireNonNull(b.state, "state == null");
        this.datanodeDetails = Objects.requireNonNull(b.datanode, "datanode == null");
        this.originDatanodeId = b.placeOfBirth;
        this.keyCount = b.keyCount;
        this.bytesUsed = b.bytesUsed;
        this.replicaIndex = b.replicaIndex;
        this.isEmpty = b.isEmpty;
        this.sequenceId = b.sequenceId;
        this.dataChecksum = b.dataChecksum;
    }

    public ContainerID getContainerID() {
        return this.containerID;
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    public DatanodeID getOriginDatanodeId() {
        return this.originDatanodeId != null ? this.originDatanodeId : this.datanodeDetails.getID();
    }

    public StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State getState() {
        return this.state;
    }

    public Long getSequenceId() {
        return this.sequenceId;
    }

    public long getKeyCount() {
        return this.keyCount;
    }

    public long getBytesUsed() {
        return this.bytesUsed;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public long getDataChecksum() {
        return this.dataChecksum;
    }

    public int hashCode() {
        return new HashCodeBuilder(61, 71).append((Object)this.containerID).append((Object)this.datanodeDetails).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerReplica that = (ContainerReplica)o;
        return new EqualsBuilder().append((Object)this.containerID, (Object)that.containerID).append((Object)this.datanodeDetails, (Object)that.datanodeDetails).isEquals();
    }

    @Override
    public int compareTo(ContainerReplica that) {
        Objects.requireNonNull(that);
        return new CompareToBuilder().append((Object)this.containerID, (Object)that.containerID).append((Object)this.datanodeDetails, (Object)that.datanodeDetails).build();
    }

    public static ContainerReplicaBuilder newBuilder() {
        return new ContainerReplicaBuilder();
    }

    public ContainerReplicaBuilder toBuilder() {
        return ContainerReplica.newBuilder().setBytesUsed(this.bytesUsed).setContainerID(this.containerID).setContainerState(this.state).setDatanodeDetails(this.datanodeDetails).setKeyCount(this.keyCount).setOriginNodeId(this.originDatanodeId).setReplicaIndex(this.replicaIndex).setSequenceId(this.sequenceId).setEmpty(this.isEmpty);
    }

    public String toString() {
        return "ContainerReplica{" + this.containerID + " (" + this.state + ") currentDN=" + this.datanodeDetails + (this.originDatanodeId != null ? ", originDN=" + this.originDatanodeId : " (origin)") + ", bcsid=" + this.sequenceId + (this.replicaIndex > 0 ? ", replicaIndex=" + this.replicaIndex : "") + ", keyCount=" + this.keyCount + ", bytesUsed=" + this.bytesUsed + ", " + (this.isEmpty ? "empty" : "non-empty") + ", dataChecksum=" + this.dataChecksum + '}';
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public static class ContainerReplicaBuilder {
        private ContainerID containerID;
        private StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state;
        private DatanodeDetails datanode;
        private DatanodeID placeOfBirth;
        private Long sequenceId;
        private long bytesUsed;
        private long keyCount;
        private int replicaIndex;
        private boolean isEmpty;
        private long dataChecksum;

        public ContainerReplicaBuilder setContainerID(ContainerID cID) {
            this.containerID = cID;
            return this;
        }

        public ContainerReplicaBuilder setContainerState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State containerState) {
            this.state = containerState;
            return this;
        }

        public ContainerReplicaBuilder setDatanodeDetails(DatanodeDetails datanodeDetails) {
            this.datanode = datanodeDetails;
            return this;
        }

        public ContainerReplicaBuilder setReplicaIndex(int index) {
            this.replicaIndex = index;
            return this;
        }

        public ContainerReplicaBuilder setOriginNodeId(DatanodeID originNodeId) {
            this.placeOfBirth = originNodeId;
            return this;
        }

        public ContainerReplicaBuilder setSequenceId(long seqId) {
            this.sequenceId = seqId;
            return this;
        }

        public ContainerReplicaBuilder setKeyCount(long count) {
            this.keyCount = count;
            return this;
        }

        public ContainerReplicaBuilder setBytesUsed(long used) {
            this.bytesUsed = used;
            return this;
        }

        public ContainerReplicaBuilder setEmpty(boolean empty) {
            this.isEmpty = empty;
            return this;
        }

        public ContainerReplicaBuilder setDataChecksum(long dataChecksum) {
            this.dataChecksum = dataChecksum;
            return this;
        }

        public ContainerReplica build() {
            return new ContainerReplica(this);
        }
    }
}

