/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.CountStats;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.FileSizeDistributionResponse;
import org.apache.hadoop.ozone.recon.api.types.NamespaceSummaryResponse;
import org.apache.hadoop.ozone.recon.api.types.ObjectDBInfo;
import org.apache.hadoop.ozone.recon.api.types.QuotaUsageResponse;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public class RootEntityHandler
extends EntityHandler {
    public RootEntityHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, String path) {
        super(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, path);
    }

    @Override
    public NamespaceSummaryResponse getSummaryResponse() throws IOException {
        List<OmVolumeArgs> volumes = this.getOmMetadataManager().listVolumes();
        List<OmBucketInfo> allBuckets = this.getOmMetadataManager().listBucketsUnderVolume(null);
        int totalNumDir = 0;
        long totalNumKey = 0L;
        for (OmBucketInfo bucket : allBuckets) {
            long bucketObjectId = bucket.getObjectID();
            totalNumDir += this.getTotalDirCount(bucketObjectId);
            totalNumKey += this.getTotalKeyCount(bucketObjectId);
        }
        CountStats countStats = new CountStats(volumes.size(), allBuckets.size(), totalNumDir, totalNumKey);
        return NamespaceSummaryResponse.newBuilder().setEntityType(EntityType.ROOT).setCountStats(countStats).setObjectDBInfo(this.getPrefixObjDbInfo()).setStatus(ResponseStatus.OK).build();
    }

    private ObjectDBInfo getPrefixObjDbInfo() throws IOException {
        OmPrefixInfo omPrefixInfo = (OmPrefixInfo)this.getOmMetadataManager().getPrefixTable().getSkipCache((Object)"/");
        if (null == omPrefixInfo) {
            return new ObjectDBInfo();
        }
        return new ObjectDBInfo(omPrefixInfo);
    }

    @Override
    public DUResponse getDuResponse(boolean listFile, boolean withReplica, boolean sortSubPaths) throws IOException {
        DUResponse duResponse = new DUResponse();
        duResponse.setPath(this.getNormalizedPath());
        ReconOMMetadataManager omMetadataManager = this.getOmMetadataManager();
        List<OmVolumeArgs> volumes = this.getOmMetadataManager().listVolumes();
        duResponse.setCount(volumes.size());
        List<DUResponse.DiskUsage> volumeDuData = new ArrayList<DUResponse.DiskUsage>();
        long totalDataSize = 0L;
        long totalDataSizeWithReplica = 0L;
        for (OmVolumeArgs volume : volumes) {
            String volumeName = volume.getVolume();
            String subpath = omMetadataManager.getVolumeKey(volumeName);
            DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
            long dataSize = 0L;
            diskUsage.setSubpath(subpath);
            long volumeDU = 0L;
            for (OmBucketInfo bucket : this.getOmMetadataManager().listBucketsUnderVolume(volumeName)) {
                long bucketObjectID = bucket.getObjectID();
                dataSize += this.getTotalSize(bucketObjectID);
                if (!withReplica) continue;
                BucketHandler bucketHandler = BucketHandler.getBucketHandler(this.getReconNamespaceSummaryManager(), this.getOmMetadataManager(), this.getReconSCM(), bucket);
                volumeDU += bucketHandler.calculateDUUnderObject(bucketObjectID);
            }
            totalDataSize += dataSize;
            if (withReplica) {
                totalDataSizeWithReplica += volumeDU;
                diskUsage.setSizeWithReplica(volumeDU);
            }
            diskUsage.setSize(dataSize);
            volumeDuData.add(diskUsage);
        }
        if (withReplica) {
            duResponse.setSizeWithReplica(totalDataSizeWithReplica);
        }
        duResponse.setSize(totalDataSize);
        if (sortSubPaths) {
            volumeDuData = ReconUtils.sortDiskUsageDescendingWithLimit(volumeDuData, 30);
        }
        duResponse.setDuData(volumeDuData);
        return duResponse;
    }

    @Override
    public QuotaUsageResponse getQuotaResponse() throws IOException {
        QuotaUsageResponse quotaUsageResponse = new QuotaUsageResponse();
        SCMNodeStat stats = this.getReconSCM().getScmNodeManager().getStats();
        long quotaInBytes = stats.getCapacity().get();
        long quotaUsedInBytes = this.getDuResponse(true, true, false).getSizeWithReplica();
        quotaUsageResponse.setQuota(quotaInBytes);
        quotaUsageResponse.setQuotaUsed(quotaUsedInBytes);
        return quotaUsageResponse;
    }

    @Override
    public FileSizeDistributionResponse getDistResponse() throws IOException {
        FileSizeDistributionResponse distResponse = new FileSizeDistributionResponse();
        List<OmBucketInfo> allBuckets = this.getOmMetadataManager().listBucketsUnderVolume(null);
        int[] fileSizeDist = new int[ReconConstants.NUM_OF_FILE_SIZE_BINS];
        for (OmBucketInfo bucket : allBuckets) {
            long bucketObjectId = bucket.getObjectID();
            int[] bucketFileSizeDist = this.getTotalFileSizeDist(bucketObjectId);
            for (int i = 0; i < ReconConstants.NUM_OF_FILE_SIZE_BINS; ++i) {
                int n = i;
                fileSizeDist[n] = fileSizeDist[n] + bucketFileSizeDist[i];
            }
        }
        distResponse.setFileSizeDist(fileSizeDist);
        return distResponse;
    }
}

