/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.container.replication.AbstractReplicationTask;
import org.apache.hadoop.ozone.container.replication.ContainerReplicationSource;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.ContainerUploader;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushReplicator
implements ContainerReplicator {
    private static final Logger LOG = LoggerFactory.getLogger(PushReplicator.class);
    private final ConfigurationSource conf;
    private final ContainerReplicationSource source;
    private final ContainerUploader uploader;

    public PushReplicator(ConfigurationSource conf, ContainerReplicationSource source, ContainerUploader uploader) {
        this.conf = conf;
        this.source = source;
        this.uploader = uploader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replicate(ReplicationTask task) {
        long containerID = task.getContainerId();
        DatanodeDetails target = task.getTarget();
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        CopyContainerCompression compression = CopyContainerCompression.getConf(this.conf);
        LOG.info("Starting replication of container {} to {} using {}", new Object[]{containerID, target, compression});
        this.source.prepare(containerID);
        CountingOutputStream output = null;
        try {
            output = new CountingOutputStream(this.uploader.startUpload(containerID, target, fut, compression));
            this.source.copyData(containerID, (OutputStream)output, compression);
            fut.get();
            task.setTransferredBytes(output.getByteCount());
            task.setStatus(AbstractReplicationTask.Status.DONE);
        }
        catch (Exception e) {
            try {
                LOG.warn("Container {} replication was unsuccessful.", (Object)containerID, (Object)e);
                if (output != null) {
                    task.setTransferredBytes(output.getByteCount());
                }
                task.setStatus(AbstractReplicationTask.Status.FAILED);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{output});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{output});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{output});
    }
}

