/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.grpc.stub.CallStreamObserver;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GrpcOutputStream<T>
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcOutputStream.class);
    public static final int READY_WAIT_TIME_IN_MS = 10;
    public static final int READY_RETRY_COUNT = 30000;
    private final CallStreamObserver<T> streamObserver;
    private final ByteString.Output buffer;
    private final long containerId;
    private final int bufferSize;
    private final AtomicBoolean closed = new AtomicBoolean();
    private long writtenBytes;

    GrpcOutputStream(CallStreamObserver<T> streamObserver, long containerId, int bufferSize) {
        this.streamObserver = streamObserver;
        this.containerId = containerId;
        this.bufferSize = bufferSize;
        this.buffer = ByteString.newOutput((int)bufferSize);
    }

    @Override
    public void write(int b) {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"stream is closed");
        try {
            this.buffer.write(b);
            if (this.buffer.size() >= this.bufferSize) {
                this.flushBuffer(false);
            }
        }
        catch (Exception ex) {
            this.streamObserver.onError((Throwable)ex);
        }
    }

    @Override
    public void write(@Nonnull byte[] data, int offset, int length) {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"stream is closed");
        if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        try {
            if (this.buffer.size() >= this.bufferSize) {
                this.flushBuffer(false);
            }
            int remaining = length;
            int off = offset;
            int len = Math.min(remaining, this.bufferSize - this.buffer.size());
            while (remaining > 0) {
                this.buffer.write(data, off, len);
                if (this.buffer.size() >= this.bufferSize) {
                    this.flushBuffer(false);
                }
                off += len;
                len = Math.min(this.bufferSize, remaining -= len);
            }
        }
        catch (Exception ex) {
            this.streamObserver.onError((Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            try {
                this.flushBuffer(true);
                LOG.info("Sent {} bytes for container {}", (Object)this.writtenBytes, (Object)this.containerId);
                this.streamObserver.onCompleted();
            }
            finally {
                this.buffer.close();
            }
        }
    }

    protected long getContainerId() {
        return this.containerId;
    }

    protected long getWrittenBytes() {
        return this.writtenBytes;
    }

    protected StreamObserver<T> getStreamObserver() {
        return this.streamObserver;
    }

    private void flushBuffer(boolean eof) throws IOException {
        this.waitUntilReady();
        int length = this.buffer.size();
        if (length > 0) {
            ByteString data = this.buffer.toByteString();
            LOG.debug("Sending {} bytes (of type {}) for container {}", new Object[]{length, data.getClass().getSimpleName(), this.containerId});
            this.sendPart(eof, length, data);
            this.writtenBytes += (long)length;
            this.buffer.reset();
        }
    }

    private void waitUntilReady() throws IOException {
        int count;
        try {
            for (count = 0; !this.streamObserver.isReady() && count < 30000; ++count) {
                LOG.debug("Stream is not ready, backoff");
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.error("InterruptedException while waiting for channel ready", (Throwable)e);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (count >= 30000) {
            throw new IOException("Channel is not ready after " + count * 10 + "ms");
        }
    }

    protected abstract void sendPart(boolean var1, int var2, ByteString var3);
}

