/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import org.apache.hadoop.ozone.container.common.volume.AvailableSpaceFilter;
import org.apache.hadoop.util.DiskChecker;
import org.slf4j.Logger;

final class VolumeChoosingUtil {
    private VolumeChoosingUtil() {
    }

    static void throwDiskOutOfSpace(AvailableSpaceFilter filter, Logger log) throws DiskChecker.DiskOutOfSpaceException {
        String msg = String.format("No volumes have enough space for a new container.  Most available space: %s bytes", filter.mostAvailableSpace());
        log.info("{}; {}", (Object)msg, (Object)filter);
        throw new DiskChecker.DiskOutOfSpaceException(msg);
    }

    static void logIfSomeVolumesOutOfSpace(AvailableSpaceFilter filter, Logger log) {
        if (log.isDebugEnabled() && filter.foundFullVolumes()) {
            log.debug("Some volumes do not have enough space for a new container; {}", (Object)filter);
        }
    }
}

