/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.hadoop.ozone.container.common.impl.StorageLocationReport;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;

public class AvailableSpaceFilter
implements Predicate<HddsVolume> {
    private final long requiredSpace;
    private final List<StorageLocationReport> fullVolumes = new LinkedList<StorageLocationReport>();
    private long mostAvailableSpace = Long.MIN_VALUE;

    AvailableSpaceFilter(long requiredSpace) {
        this.requiredSpace = requiredSpace;
    }

    @Override
    public boolean test(HddsVolume vol) {
        StorageLocationReport report = vol.getReport();
        long available = report.getUsableSpace();
        boolean hasEnoughSpace = available > this.requiredSpace;
        this.mostAvailableSpace = Math.max(available, this.mostAvailableSpace);
        if (!hasEnoughSpace) {
            this.fullVolumes.add(report);
        }
        return hasEnoughSpace;
    }

    boolean foundFullVolumes() {
        return !this.fullVolumes.isEmpty();
    }

    long mostAvailableSpace() {
        return this.mostAvailableSpace;
    }

    public String toString() {
        return "required space: " + this.requiredSpace + ", volumes: " + this.fullVolumes;
    }
}

