/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.time.ZoneId;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyClient;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyVerifierClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.NettyMetrics;
import org.apache.hadoop.ozone.HddsDatanodeService;
import org.apache.hadoop.ozone.HddsDatanodeStopService;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.container.checksum.DNContainerOperationClient;
import org.apache.hadoop.ozone.container.common.DatanodeLayoutStorage;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.report.ReportManager;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeQueueMetrics;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CloseContainerCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.ClosePipelineCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandDispatcher;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CreatePipelineCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.DeleteBlocksCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.DeleteContainerCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.FinalizeNewLayoutVersionCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.ReconcileContainerCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.ReconstructECContainersCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.RefreshVolumeUsageCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.ReplicateContainerCommandHandler;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.SetNodeOperationalStateCommandHandler;
import org.apache.hadoop.ozone.container.common.volume.VolumeChoosingPolicyFactory;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionCoordinator;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionMetrics;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.container.replication.ContainerImporter;
import org.apache.hadoop.ozone.container.replication.DownloadAndImportReplicator;
import org.apache.hadoop.ozone.container.replication.GrpcContainerUploader;
import org.apache.hadoop.ozone.container.replication.MeasuredReplicator;
import org.apache.hadoop.ozone.container.replication.OnDemandContainerReplicationSource;
import org.apache.hadoop.ozone.container.replication.PushReplicator;
import org.apache.hadoop.ozone.container.replication.ReplicationServer;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisor;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisorMetrics;
import org.apache.hadoop.ozone.container.replication.SimpleContainerDownloader;
import org.apache.hadoop.ozone.container.upgrade.DataNodeUpgradeFinalizer;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatanodeStateMachine
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeStateMachine.class);
    private final ExecutorService executorService;
    private final ExecutorService closePipelineCommandExecutorService;
    private final ExecutorService createPipelineCommandExecutorService;
    private final ConfigurationSource conf;
    private final SCMConnectionManager connectionManager;
    private final ECReconstructionCoordinator ecReconstructionCoordinator;
    private StateContext context;
    private VolumeChoosingPolicy volumeChoosingPolicy;
    private final OzoneContainer container;
    private final DatanodeDetails datanodeDetails;
    private final CommandDispatcher commandDispatcher;
    private final ReportManager reportManager;
    private final AtomicLong nextHB;
    private volatile Thread stateMachineThread = null;
    private Thread cmdProcessThread = null;
    private final ReplicationSupervisor supervisor;
    private final HddsDatanodeStopService hddsDatanodeStopService;
    private final HDDSLayoutVersionManager layoutVersionManager;
    private final DatanodeLayoutStorage layoutStorage;
    private final DataNodeUpgradeFinalizer upgradeFinalizer;
    private final ReadWriteLock constructionLock = new ReentrantReadWriteLock();
    private final MeasuredReplicator pullReplicatorWithMetrics;
    private final MeasuredReplicator pushReplicatorWithMetrics;
    private final ReplicationSupervisorMetrics replicationSupervisorMetrics;
    private final NettyMetrics nettyMetrics;
    private final ECReconstructionMetrics ecReconstructionMetrics;
    private final ReconstructECContainersCommandHandler reconstructECContainersCommandHandler;
    private final DatanodeQueueMetrics queueMetrics;
    private final ReconfigurationHandler reconfigurationHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeStateMachine(HddsDatanodeService hddsDatanodeService, DatanodeDetails datanodeDetails, ConfigurationSource conf, CertificateClient certClient, SecretKeyClient secretKeyClient, HddsDatanodeStopService hddsDatanodeStopService, ReconfigurationHandler reconfigurationHandler) throws IOException {
        DatanodeConfiguration dnConf = (DatanodeConfiguration)((Object)conf.getObject(DatanodeConfiguration.class));
        this.reconfigurationHandler = reconfigurationHandler;
        this.hddsDatanodeStopService = hddsDatanodeStopService;
        this.conf = conf;
        this.datanodeDetails = datanodeDetails;
        Clock clock = Clock.system(ZoneId.systemDefault());
        this.layoutStorage = new DatanodeLayoutStorage(conf, datanodeDetails.getUuidString());
        this.layoutVersionManager = new HDDSLayoutVersionManager(this.layoutStorage.getLayoutVersion());
        this.upgradeFinalizer = new DataNodeUpgradeFinalizer(this.layoutVersionManager);
        VersionedDatanodeFeatures.initialize(this.layoutVersionManager);
        String threadNamePrefix = datanodeDetails.threadNamePrefix();
        this.executorService = Executors.newFixedThreadPool(this.getEndPointTaskThreadPoolSize(), new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "DatanodeStateMachineTaskThread-%d").build());
        this.connectionManager = new SCMConnectionManager(conf);
        this.context = new StateContext(this.conf, DatanodeStates.getInitState(), this, threadNamePrefix);
        this.volumeChoosingPolicy = VolumeChoosingPolicyFactory.getPolicy(conf);
        this.constructionLock.writeLock().lock();
        try {
            this.container = new OzoneContainer(hddsDatanodeService, this.datanodeDetails, conf, this.context, certClient, (SecretKeyVerifierClient)secretKeyClient, this.volumeChoosingPolicy);
        }
        finally {
            this.constructionLock.writeLock().unlock();
        }
        this.nextHB = new AtomicLong(Time.monotonicNow());
        ContainerImporter importer = new ContainerImporter(conf, this.container.getContainerSet(), this.container.getController(), this.container.getVolumeSet(), this.volumeChoosingPolicy);
        DownloadAndImportReplicator pullReplicator = new DownloadAndImportReplicator(conf, this.container.getContainerSet(), importer, new SimpleContainerDownloader(conf, certClient));
        PushReplicator pushReplicator = new PushReplicator(conf, new OnDemandContainerReplicationSource(this.container.getController()), new GrpcContainerUploader(conf, certClient, this.container.getController()));
        this.pullReplicatorWithMetrics = new MeasuredReplicator(pullReplicator, "pull");
        this.pushReplicatorWithMetrics = new MeasuredReplicator(pushReplicator, "push");
        ReplicationServer.ReplicationConfig replicationConfig = (ReplicationServer.ReplicationConfig)conf.getObject(ReplicationServer.ReplicationConfig.class);
        this.supervisor = ReplicationSupervisor.newBuilder().stateContext(this.context).datanodeConfig(dnConf).replicationConfig(replicationConfig).clock(clock).build();
        this.replicationSupervisorMetrics = ReplicationSupervisorMetrics.create(this.supervisor);
        this.ecReconstructionMetrics = ECReconstructionMetrics.create();
        this.ecReconstructionCoordinator = new ECReconstructionCoordinator(conf, certClient, (SecretKeySignerClient)secretKeyClient, this.context, this.ecReconstructionMetrics, threadNamePrefix);
        this.reconstructECContainersCommandHandler = new ReconstructECContainersCommandHandler(conf, this.supervisor, this.ecReconstructionCoordinator);
        DNContainerOperationClient dnClient = new DNContainerOperationClient(conf, certClient, (SecretKeySignerClient)secretKeyClient);
        ThreadFactory closePipelineThreadFactory = new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "ClosePipelineCommandHandlerThread-%d").build();
        this.closePipelineCommandExecutorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(dnConf.getCommandQueueLimit()), closePipelineThreadFactory);
        ThreadFactory createPipelineThreadFactory = new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "CreatePipelineCommandHandlerThread-%d").build();
        this.createPipelineCommandExecutorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(dnConf.getCommandQueueLimit()), createPipelineThreadFactory);
        this.commandDispatcher = CommandDispatcher.newBuilder().addHandler(new CloseContainerCommandHandler(dnConf.getContainerCloseThreads(), dnConf.getCommandQueueLimit(), threadNamePrefix)).addHandler(new DeleteBlocksCommandHandler(this.getContainer(), conf, dnConf, threadNamePrefix)).addHandler(new ReplicateContainerCommandHandler(conf, this.supervisor, this.pullReplicatorWithMetrics, this.pushReplicatorWithMetrics)).addHandler(this.reconstructECContainersCommandHandler).addHandler(new DeleteContainerCommandHandler(dnConf.getContainerDeleteThreads(), clock, dnConf.getCommandQueueLimit(), threadNamePrefix)).addHandler(new ClosePipelineCommandHandler(conf, (Executor)this.closePipelineCommandExecutorService)).addHandler(new CreatePipelineCommandHandler(conf, (Executor)this.createPipelineCommandExecutorService)).addHandler(new SetNodeOperationalStateCommandHandler(conf, this.supervisor::nodeStateUpdated)).addHandler(new FinalizeNewLayoutVersionCommandHandler()).addHandler(new RefreshVolumeUsageCommandHandler()).addHandler(new ReconcileContainerCommandHandler(this.supervisor, dnClient)).setConnectionManager(this.connectionManager).setContainer(this.container).setContext(this.context).build();
        this.reportManager = ReportManager.newBuilder(conf).setStateContext(this.context).addPublisherFor(StorageContainerDatanodeProtocolProtos.NodeReportProto.class).addPublisherFor(StorageContainerDatanodeProtocolProtos.ContainerReportsProto.class).addPublisherFor(StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto.class).addPublisherFor(StorageContainerDatanodeProtocolProtos.PipelineReportsProto.class).addThreadNamePrefix(threadNamePrefix).build();
        this.queueMetrics = DatanodeQueueMetrics.create(this);
        this.nettyMetrics = NettyMetrics.create();
    }

    @VisibleForTesting
    public DatanodeStateMachine(DatanodeDetails datanodeDetails, ConfigurationSource conf) throws IOException {
        this(null, datanodeDetails, conf, null, null, null, new ReconfigurationHandler("DN", (OzoneConfiguration)conf, op -> {}));
    }

    private int getEndPointTaskThreadPoolSize() {
        int totalServerCount = 1;
        try {
            totalServerCount += HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)this.conf).size();
        }
        catch (Exception e) {
            LOG.error("Fail to get scm addresses", (Throwable)e);
        }
        LOG.info("Datanode State Machine Task Thread Pool size {}", (Object)totalServerCount);
        return totalServerCount;
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    public SCMConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public OzoneContainer getContainer() {
        this.constructionLock.readLock().lock();
        try {
            OzoneContainer ozoneContainer = this.container;
            return ozoneContainer;
        }
        finally {
            this.constructionLock.readLock().unlock();
        }
    }

    private void startStateMachineThread() throws IOException {
        this.reportManager.init();
        this.initCommandHandlerThread(this.conf);
        this.upgradeFinalizer.runPrefinalizeStateActions((Storage)this.layoutStorage, this);
        LOG.info("Ozone container server started.");
        while (this.context.getState() != DatanodeStates.SHUTDOWN) {
            long now;
            try {
                LOG.debug("Executing cycle Number : {}", (Object)this.context.getExecutionCount());
                long heartbeatFrequency = this.context.getHeartbeatFrequency();
                this.nextHB.set(Time.monotonicNow() + heartbeatFrequency);
                this.context.execute(this.executorService, heartbeatFrequency, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOG.error("Unable to finish the execution.", (Throwable)e);
            }
            if ((now = Time.monotonicNow()) >= this.nextHB.get() || Thread.interrupted()) continue;
            try {
                Thread.sleep(this.nextHB.get() - now);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.context.getShutdownOnError()) {
            LOG.error("DatanodeStateMachine Shutdown due to an critical error");
            this.hddsDatanodeStopService.stopService();
        }
    }

    public void handleFatalVolumeFailures() {
        LOG.error("DatanodeStateMachine Shutdown due to too many bad volumes, check hdds.datanode.failed.data.volumes.tolerated and hdds.datanode.failed.metadata.volumes.tolerated and hdds.datanode.failed.db.volumes.tolerated");
        this.hddsDatanodeStopService.stopService();
    }

    public StateContext getContext() {
        return this.context;
    }

    public void setContext(StateContext context) {
        this.context = context;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.ecReconstructionCoordinator});
        if (this.stateMachineThread != null) {
            this.stateMachineThread.interrupt();
        }
        if (this.cmdProcessThread != null) {
            this.cmdProcessThread.interrupt();
        }
        if (this.layoutVersionManager != null) {
            this.layoutVersionManager.close();
        }
        this.context.setState(DatanodeStates.getLastState());
        this.replicationSupervisorMetrics.unRegister();
        this.ecReconstructionMetrics.unRegister();
        this.executorServiceShutdownGraceful(this.executorService);
        this.executorServiceShutdownGraceful(this.closePipelineCommandExecutorService);
        this.executorServiceShutdownGraceful(this.createPipelineCommandExecutorService);
        if (this.connectionManager != null) {
            this.connectionManager.close();
        }
        if (this.container != null) {
            this.container.stop();
        }
        if (this.commandDispatcher != null) {
            this.commandDispatcher.stop();
        }
        if (this.queueMetrics != null) {
            DatanodeQueueMetrics.unRegister();
        }
        if (this.nettyMetrics != null) {
            this.nettyMetrics.unregister();
        }
    }

    private void executorServiceShutdownGraceful(ExecutorService executor) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.error("Unable to shutdown state machine properly.");
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error attempting to shutdown.", (Throwable)e);
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void startDaemon() {
        Runnable startStateMachineTask = () -> {
            try {
                this.startStateMachineThread();
            }
            catch (Exception ex) {
                LOG.error("Unable to start the DatanodeState Machine", (Throwable)ex);
            }
        };
        this.stateMachineThread = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.datanodeDetails.threadNamePrefix() + "DatanodeStateMachineDaemonThread").setUncaughtExceptionHandler((t, ex) -> {
            String message = "Terminate Datanode, encounter uncaught exception in Datanode State Machine Thread";
            ExitUtils.terminate((int)1, (String)message, (Throwable)ex, (Logger)LOG);
        }).build().newThread(startStateMachineTask);
        this.stateMachineThread.setPriority(10);
        this.stateMachineThread.start();
    }

    public void triggerHeartbeat() {
        if (this.stateMachineThread != null && this.isDaemonStarted()) {
            this.stateMachineThread.interrupt();
        }
    }

    public void join() throws InterruptedException {
        if (this.stateMachineThread != null) {
            this.stateMachineThread.join();
        }
        if (this.cmdProcessThread != null) {
            this.cmdProcessThread.join();
        }
    }

    public Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> getQueuedCommandCount() {
        Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> commandQSummary = this.context.getCommandQueueSummary();
        Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> dispatcherQSummary = this.commandDispatcher.getQueuedCommandCount();
        commandQSummary.forEach((k, v) -> dispatcherQSummary.merge((StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type)k, (Integer)v, Integer::sum));
        return dispatcherQSummary;
    }

    public synchronized void stopDaemon() {
        try {
            IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.pushReplicatorWithMetrics, this.pullReplicatorWithMetrics});
            this.supervisor.stop();
            this.context.setShutdownGracefully();
            this.context.setState(DatanodeStates.SHUTDOWN);
            this.reportManager.shutdown();
            this.close();
            LOG.info("Ozone container server stopped.");
        }
        catch (IOException e) {
            LOG.error("Stop ozone container server failed.", (Throwable)e);
        }
    }

    public boolean isDaemonStarted() {
        return this.getContext().getExecutionCount() > 0L;
    }

    @VisibleForTesting
    public boolean isDaemonStopped() {
        return this.executorService.isShutdown() && this.getContext().getState() == DatanodeStates.SHUTDOWN;
    }

    private void initCommandHandlerThread(ConfigurationSource config) {
        Runnable processCommandQueue = () -> {
            while (this.getContext().getState() != DatanodeStates.SHUTDOWN) {
                SCMCommand<?> command = this.getContext().getNextCommand();
                if (command != null) {
                    this.commandDispatcher.handle(command);
                    continue;
                }
                try {
                    long now = Time.monotonicNow();
                    if (this.nextHB.get() <= now) continue;
                    Thread.sleep(this.nextHB.get() - now + 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.cmdProcessThread = this.getCommandHandlerThread(processCommandQueue);
        this.cmdProcessThread.setPriority(5);
        this.cmdProcessThread.start();
    }

    private Thread getCommandHandlerThread(Runnable processCommandQueue) {
        Thread handlerThread = new Thread(processCommandQueue);
        handlerThread.setDaemon(true);
        handlerThread.setName(this.datanodeDetails.threadNamePrefix() + "CommandProcessorThread");
        handlerThread.setUncaughtExceptionHandler((t, e) -> {
            LOG.error("Critical Error : Command processor thread encountered an error. Thread: {}", (Object)t.toString(), (Object)e);
            this.getCommandHandlerThread(processCommandQueue).start();
        });
        return handlerThread;
    }

    @VisibleForTesting
    public CommandDispatcher getCommandDispatcher() {
        return this.commandDispatcher;
    }

    @VisibleForTesting
    public ReplicationSupervisor getSupervisor() {
        return this.supervisor;
    }

    @VisibleForTesting
    public HDDSLayoutVersionManager getLayoutVersionManager() {
        return this.layoutVersionManager;
    }

    @VisibleForTesting
    public DatanodeLayoutStorage getLayoutStorage() {
        return this.layoutStorage;
    }

    public UpgradeFinalization.StatusAndMessages finalizeUpgrade() throws IOException {
        return this.upgradeFinalizer.finalize(this.datanodeDetails.getUuidString(), this);
    }

    public UpgradeFinalization.StatusAndMessages queryUpgradeStatus() throws IOException {
        return this.upgradeFinalizer.reportStatus(this.datanodeDetails.getUuidString(), true);
    }

    public UpgradeFinalizer<DatanodeStateMachine> getUpgradeFinalizer() {
        return this.upgradeFinalizer;
    }

    public ConfigurationSource getConf() {
        return this.conf;
    }

    public DatanodeQueueMetrics getQueueMetrics() {
        return this.queueMetrics;
    }

    public ReconfigurationHandler getReconfigurationHandler() {
        return this.reconfigurationHandler;
    }

    public Thread getStateMachineThread() {
        return this.stateMachineThread;
    }

    public Thread getCmdProcessThread() {
        return this.cmdProcessThread;
    }

    public VolumeChoosingPolicy getVolumeChoosingPolicy() {
        return this.volumeChoosingPolicy;
    }

    public static enum DatanodeStates {
        INIT(1),
        RUNNING(2),
        SHUTDOWN(3);

        private final int value;

        private DatanodeStates(int value) {
            this.value = value;
        }

        public static DatanodeStates getInitState() {
            return INIT;
        }

        public static DatanodeStates getLastState() {
            return SHUTDOWN;
        }

        public int getValue() {
            return this.value;
        }

        public DatanodeStates getNextState() {
            if (this.value < DatanodeStates.getLastState().getValue()) {
                int stateValue = this.getValue() + 1;
                for (DatanodeStates iter : DatanodeStates.values()) {
                    if (stateValue != iter.getValue()) continue;
                    return iter;
                }
            }
            return DatanodeStates.getLastState();
        }

        public boolean isTransitionAllowedTo(DatanodeStates newState) {
            return newState.getValue() > this.getValue();
        }
    }
}

