/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.interfaces.StorageLocationReportMXBean;
import org.apache.hadoop.ozone.container.common.volume.VolumeUsage;

@Immutable
public final class StorageLocationReport
implements StorageLocationReportMXBean {
    private final String id;
    private final boolean failed;
    private final long capacity;
    private final long scmUsed;
    private final long remaining;
    private final long committed;
    private final long freeSpaceToSpare;
    private final StorageType storageType;
    private final String storageLocation;

    private StorageLocationReport(Builder builder) {
        this.id = builder.id;
        this.failed = builder.failed;
        this.capacity = builder.capacity;
        this.scmUsed = builder.scmUsed;
        this.remaining = builder.remaining;
        this.committed = builder.committed;
        this.freeSpaceToSpare = builder.freeSpaceToSpare;
        this.storageType = builder.storageType;
        this.storageLocation = builder.storageLocation;
    }

    public long getUsableSpace() {
        return VolumeUsage.getUsableSpace(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getScmUsed() {
        return this.scmUsed;
    }

    @Override
    public long getRemaining() {
        return this.remaining;
    }

    @Override
    public long getCommitted() {
        return this.committed;
    }

    @Override
    public long getFreeSpaceToSpare() {
        return this.freeSpaceToSpare;
    }

    @Override
    public String getStorageLocation() {
        return this.storageLocation;
    }

    @Override
    public String getStorageTypeName() {
        return this.storageType.name();
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    private HddsProtos.StorageTypeProto getStorageTypeProto() throws IOException {
        return StorageLocationReport.getStorageTypeProto(this.getStorageType());
    }

    public static HddsProtos.StorageTypeProto getStorageTypeProto(StorageType type) throws IOException {
        HddsProtos.StorageTypeProto storageTypeProto;
        switch (type) {
            case SSD: {
                storageTypeProto = HddsProtos.StorageTypeProto.SSD;
                break;
            }
            case DISK: {
                storageTypeProto = HddsProtos.StorageTypeProto.DISK;
                break;
            }
            case ARCHIVE: {
                storageTypeProto = HddsProtos.StorageTypeProto.ARCHIVE;
                break;
            }
            case PROVIDED: {
                storageTypeProto = HddsProtos.StorageTypeProto.PROVIDED;
                break;
            }
            case RAM_DISK: {
                storageTypeProto = HddsProtos.StorageTypeProto.RAM_DISK;
                break;
            }
            default: {
                throw new IOException("Illegal Storage Type specified");
            }
        }
        return storageTypeProto;
    }

    private static StorageType getStorageType(HddsProtos.StorageTypeProto proto) throws IOException {
        StorageType storageType;
        switch (proto) {
            case SSD: {
                storageType = StorageType.SSD;
                break;
            }
            case DISK: {
                storageType = StorageType.DISK;
                break;
            }
            case ARCHIVE: {
                storageType = StorageType.ARCHIVE;
                break;
            }
            case PROVIDED: {
                storageType = StorageType.PROVIDED;
                break;
            }
            case RAM_DISK: {
                storageType = StorageType.RAM_DISK;
                break;
            }
            default: {
                throw new IOException("Illegal Storage Type specified");
            }
        }
        return storageType;
    }

    public StorageContainerDatanodeProtocolProtos.StorageReportProto getProtoBufMessage() throws IOException {
        StorageContainerDatanodeProtocolProtos.StorageReportProto.Builder srb = StorageContainerDatanodeProtocolProtos.StorageReportProto.newBuilder();
        return srb.setStorageUuid(this.getId()).setCapacity(this.getCapacity()).setScmUsed(this.getScmUsed()).setRemaining(this.getRemaining()).setCommitted(this.getCommitted()).setStorageType(this.getStorageTypeProto()).setStorageLocation(this.getStorageLocation()).setFailed(this.isFailed()).setFreeSpaceToSpare(this.getFreeSpaceToSpare()).build();
    }

    public StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto getMetadataProtoBufMessage() throws IOException {
        StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto.Builder srb = StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto.newBuilder();
        return srb.setCapacity(this.getCapacity()).setScmUsed(this.getScmUsed()).setRemaining(this.getRemaining()).setStorageType(this.getStorageTypeProto()).setStorageLocation(this.getStorageLocation()).setFailed(this.isFailed()).build();
    }

    public static StorageLocationReport getFromProtobuf(StorageContainerDatanodeProtocolProtos.StorageReportProto report) throws IOException {
        Builder builder = StorageLocationReport.newBuilder();
        builder.setId(report.getStorageUuid()).setStorageLocation(report.getStorageLocation());
        if (report.hasCapacity()) {
            builder.setCapacity(report.getCapacity());
        }
        if (report.hasScmUsed()) {
            builder.setScmUsed(report.getScmUsed());
        }
        if (report.hasStorageType()) {
            builder.setStorageType(StorageLocationReport.getStorageType(report.getStorageType()));
        }
        if (report.hasRemaining()) {
            builder.setRemaining(report.getRemaining());
        }
        if (report.hasFailed()) {
            builder.setFailed(report.getFailed());
        }
        return builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128).append('{').append(" id=").append(this.id).append(" dir=").append(this.storageLocation).append(" type=").append(this.storageType);
        if (this.failed) {
            sb.append(" failed");
        } else {
            sb.append(" capacity=").append(this.capacity).append(" used=").append(this.scmUsed).append(" available=").append(this.remaining).append(" minFree=").append(this.freeSpaceToSpare).append(" committed=").append(this.committed);
        }
        return sb.append(" }").toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private boolean failed;
        private long capacity;
        private long scmUsed;
        private long remaining;
        private long committed;
        private long freeSpaceToSpare;
        private StorageType storageType;
        private String storageLocation;

        public Builder setId(String idValue) {
            this.id = idValue;
            return this;
        }

        public Builder setFailed(boolean failedValue) {
            this.failed = failedValue;
            return this;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public Builder setCapacity(long capacityValue) {
            this.capacity = capacityValue;
            return this;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public Builder setScmUsed(long scmUsedValue) {
            this.scmUsed = scmUsedValue;
            return this;
        }

        public Builder setRemaining(long remainingValue) {
            this.remaining = remainingValue;
            return this;
        }

        public Builder setStorageType(StorageType storageTypeValue) {
            this.storageType = storageTypeValue;
            return this;
        }

        public Builder setCommitted(long committed) {
            this.committed = committed;
            return this;
        }

        public Builder setFreeSpaceToSpare(long freeSpaceToSpare) {
            this.freeSpaceToSpare = freeSpaceToSpare;
            return this;
        }

        public Builder setStorageLocation(String storageLocationValue) {
            this.storageLocation = storageLocationValue;
            return this;
        }

        public StorageLocationReport build() {
            return new StorageLocationReport(this);
        }
    }
}

