/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.common.Storage;

public class DatanodeLayoutStorage
extends Storage {
    public DatanodeLayoutStorage(ConfigurationSource conf, String dataNodeId) throws IOException {
        super(HddsProtos.NodeType.DATANODE, ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf), "dnlayoutversion", dataNodeId, DatanodeLayoutStorage.getDefaultLayoutVersion(conf));
    }

    public DatanodeLayoutStorage(OzoneConfiguration conf, String dataNodeId, int layoutVersion) throws IOException {
        super(HddsProtos.NodeType.DATANODE, ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf), "dnlayoutversion", dataNodeId, layoutVersion);
    }

    public DatanodeLayoutStorage(ConfigurationSource conf) throws IOException {
        super(HddsProtos.NodeType.DATANODE, ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf), "dnlayoutversion", DatanodeLayoutStorage.getDefaultLayoutVersion(conf));
    }

    public File getCurrentDir() {
        return new File(this.getStorageDir());
    }

    protected Properties getNodeProperties() {
        return new Properties();
    }

    public void setClusterId(String clusterId) throws IOException {
        super.getStorageInfo().setClusterId(clusterId);
    }

    private static int getDefaultLayoutVersion(ConfigurationSource conf) {
        int defaultLayoutVersion = HDDSLayoutVersionManager.maxLayoutVersion();
        File dnIdFile = new File(HddsServerUtil.getDatanodeIdFilePath((ConfigurationSource)conf));
        if (dnIdFile.exists()) {
            defaultLayoutVersion = HDDSLayoutFeature.INITIAL_VERSION.layoutVersion();
        }
        return defaultLayoutVersion;
    }
}

