/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.page;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.debugger.model.SearchMatch;
import org.openqa.selenium.devtools.v85.dom.model.Rect;
import org.openqa.selenium.devtools.v85.emulation.model.ScreenOrientation;
import org.openqa.selenium.devtools.v85.io.model.StreamHandle;
import org.openqa.selenium.devtools.v85.network.model.Cookie;
import org.openqa.selenium.devtools.v85.network.model.LoaderId;
import org.openqa.selenium.devtools.v85.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v85.page.model.AppManifestError;
import org.openqa.selenium.devtools.v85.page.model.AppManifestParsedProperties;
import org.openqa.selenium.devtools.v85.page.model.CompilationCacheProduced;
import org.openqa.selenium.devtools.v85.page.model.DownloadProgress;
import org.openqa.selenium.devtools.v85.page.model.DownloadWillBegin;
import org.openqa.selenium.devtools.v85.page.model.FileChooserOpened;
import org.openqa.selenium.devtools.v85.page.model.FontFamilies;
import org.openqa.selenium.devtools.v85.page.model.FontSizes;
import org.openqa.selenium.devtools.v85.page.model.Frame;
import org.openqa.selenium.devtools.v85.page.model.FrameAttached;
import org.openqa.selenium.devtools.v85.page.model.FrameId;
import org.openqa.selenium.devtools.v85.page.model.FrameRequestedNavigation;
import org.openqa.selenium.devtools.v85.page.model.FrameResourceTree;
import org.openqa.selenium.devtools.v85.page.model.FrameScheduledNavigation;
import org.openqa.selenium.devtools.v85.page.model.FrameTree;
import org.openqa.selenium.devtools.v85.page.model.InstallabilityError;
import org.openqa.selenium.devtools.v85.page.model.JavascriptDialogClosed;
import org.openqa.selenium.devtools.v85.page.model.JavascriptDialogOpening;
import org.openqa.selenium.devtools.v85.page.model.LayoutViewport;
import org.openqa.selenium.devtools.v85.page.model.LifecycleEvent;
import org.openqa.selenium.devtools.v85.page.model.NavigatedWithinDocument;
import org.openqa.selenium.devtools.v85.page.model.NavigationEntry;
import org.openqa.selenium.devtools.v85.page.model.ReferrerPolicy;
import org.openqa.selenium.devtools.v85.page.model.ScreencastFrame;
import org.openqa.selenium.devtools.v85.page.model.ScriptIdentifier;
import org.openqa.selenium.devtools.v85.page.model.TransitionType;
import org.openqa.selenium.devtools.v85.page.model.Viewport;
import org.openqa.selenium.devtools.v85.page.model.VisualViewport;
import org.openqa.selenium.devtools.v85.page.model.WindowOpen;
import org.openqa.selenium.devtools.v85.runtime.model.ExecutionContextId;
import org.openqa.selenium.json.JsonInput;

public class Page {
    @Beta
    @Deprecated
    public static Command<ScriptIdentifier> addScriptToEvaluateOnLoad(String scriptSource) {
        Objects.requireNonNull(scriptSource, "scriptSource is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("scriptSource", scriptSource);
        return new Command("Page.addScriptToEvaluateOnLoad", Map.copyOf(params), ConverterFunctions.map((String)"identifier", ScriptIdentifier.class));
    }

    public static Command<ScriptIdentifier> addScriptToEvaluateOnNewDocument(String source, Optional<String> worldName) {
        Objects.requireNonNull(source, "source is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("source", source);
        worldName.ifPresent(p -> params.put("worldName", (String)p));
        return new Command("Page.addScriptToEvaluateOnNewDocument", Map.copyOf(params), ConverterFunctions.map((String)"identifier", ScriptIdentifier.class));
    }

    public static Command<Void> bringToFront() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.bringToFront", Map.copyOf(params));
    }

    public static Command<String> captureScreenshot(Optional<CaptureScreenshotFormat> format, Optional<Integer> quality, Optional<Viewport> clip, Optional<Boolean> fromSurface) {
        LinkedHashMap params = new LinkedHashMap();
        format.ifPresent(p -> params.put("format", p));
        quality.ifPresent(p -> params.put("quality", p));
        clip.ifPresent(p -> params.put("clip", p));
        fromSurface.ifPresent(p -> params.put("fromSurface", p));
        return new Command("Page.captureScreenshot", Map.copyOf(params), ConverterFunctions.map((String)"data", String.class));
    }

    @Beta
    public static Command<String> captureSnapshot(Optional<CaptureSnapshotFormat> format) {
        LinkedHashMap params = new LinkedHashMap();
        format.ifPresent(p -> params.put("format", p));
        return new Command("Page.captureSnapshot", Map.copyOf(params), ConverterFunctions.map((String)"data", String.class));
    }

    @Beta
    @Deprecated
    public static Command<Void> clearDeviceMetricsOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.clearDeviceMetricsOverride", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> clearDeviceOrientationOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.clearDeviceOrientationOverride", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> clearGeolocationOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.clearGeolocationOverride", Map.copyOf(params));
    }

    public static Command<ExecutionContextId> createIsolatedWorld(FrameId frameId, Optional<String> worldName, Optional<Boolean> grantUniveralAccess) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        worldName.ifPresent(p -> params.put("worldName", (FrameId)p));
        grantUniveralAccess.ifPresent(p -> params.put("grantUniveralAccess", (FrameId)p));
        return new Command("Page.createIsolatedWorld", Map.copyOf(params), ConverterFunctions.map((String)"executionContextId", ExecutionContextId.class));
    }

    @Beta
    @Deprecated
    public static Command<Void> deleteCookie(String cookieName, String url) {
        Objects.requireNonNull(cookieName, "cookieName is required");
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("cookieName", cookieName);
        params.put("url", url);
        return new Command("Page.deleteCookie", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.enable", Map.copyOf(params));
    }

    public static Command<GetAppManifestResponse> getAppManifest() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.getAppManifest", Map.copyOf(params), input -> (GetAppManifestResponse)input.read(GetAppManifestResponse.class));
    }

    @Beta
    public static Command<List<InstallabilityError>> getInstallabilityErrors() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.getInstallabilityErrors", Map.copyOf(params), ConverterFunctions.map((String)"installabilityErrors", input -> input.readArray(InstallabilityError.class)));
    }

    @Beta
    public static Command<String> getManifestIcons() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.getManifestIcons", Map.copyOf(params), ConverterFunctions.map((String)"primaryIcon", String.class));
    }

    @Beta
    @Deprecated
    public static Command<List<Cookie>> getCookies() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.getCookies", Map.copyOf(params), ConverterFunctions.map((String)"cookies", input -> input.readArray(Cookie.class)));
    }

    public static Command<FrameTree> getFrameTree() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.getFrameTree", Map.copyOf(params), ConverterFunctions.map((String)"frameTree", FrameTree.class));
    }

    public static Command<GetLayoutMetricsResponse> getLayoutMetrics() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.getLayoutMetrics", Map.copyOf(params), input -> (GetLayoutMetricsResponse)input.read(GetLayoutMetricsResponse.class));
    }

    public static Command<GetNavigationHistoryResponse> getNavigationHistory() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.getNavigationHistory", Map.copyOf(params), input -> (GetNavigationHistoryResponse)input.read(GetNavigationHistoryResponse.class));
    }

    public static Command<Void> resetNavigationHistory() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.resetNavigationHistory", Map.copyOf(params));
    }

    @Beta
    public static Command<GetResourceContentResponse> getResourceContent(FrameId frameId, String url) {
        Objects.requireNonNull(frameId, "frameId is required");
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("frameId", frameId);
        params.put("url", url);
        return new Command("Page.getResourceContent", Map.copyOf(params), input -> (GetResourceContentResponse)input.read(GetResourceContentResponse.class));
    }

    @Beta
    public static Command<FrameResourceTree> getResourceTree() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.getResourceTree", Map.copyOf(params), ConverterFunctions.map((String)"frameTree", FrameResourceTree.class));
    }

    public static Command<Void> handleJavaScriptDialog(Boolean accept, Optional<String> promptText) {
        Objects.requireNonNull(accept, "accept is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("accept", accept);
        promptText.ifPresent(p -> params.put("promptText", (Boolean)p));
        return new Command("Page.handleJavaScriptDialog", Map.copyOf(params));
    }

    public static Command<NavigateResponse> navigate(String url, Optional<String> referrer, Optional<TransitionType> transitionType, Optional<FrameId> frameId, Optional<ReferrerPolicy> referrerPolicy) {
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url);
        referrer.ifPresent(p -> params.put("referrer", (String)p));
        transitionType.ifPresent(p -> params.put("transitionType", (String)p));
        frameId.ifPresent(p -> params.put("frameId", (String)p));
        referrerPolicy.ifPresent(p -> params.put("referrerPolicy", (String)p));
        return new Command("Page.navigate", Map.copyOf(params), input -> (NavigateResponse)input.read(NavigateResponse.class));
    }

    public static Command<Void> navigateToHistoryEntry(Integer entryId) {
        Objects.requireNonNull(entryId, "entryId is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("entryId", entryId);
        return new Command("Page.navigateToHistoryEntry", Map.copyOf(params));
    }

    public static Command<PrintToPDFResponse> printToPDF(Optional<Boolean> landscape, Optional<Boolean> displayHeaderFooter, Optional<Boolean> printBackground, Optional<Number> scale, Optional<Number> paperWidth, Optional<Number> paperHeight, Optional<Number> marginTop, Optional<Number> marginBottom, Optional<Number> marginLeft, Optional<Number> marginRight, Optional<String> pageRanges, Optional<Boolean> ignoreInvalidPageRanges, Optional<String> headerTemplate, Optional<String> footerTemplate, Optional<Boolean> preferCSSPageSize, Optional<PrintToPDFTransferMode> transferMode) {
        LinkedHashMap params = new LinkedHashMap();
        landscape.ifPresent(p -> params.put("landscape", p));
        displayHeaderFooter.ifPresent(p -> params.put("displayHeaderFooter", p));
        printBackground.ifPresent(p -> params.put("printBackground", p));
        scale.ifPresent(p -> params.put("scale", p));
        paperWidth.ifPresent(p -> params.put("paperWidth", p));
        paperHeight.ifPresent(p -> params.put("paperHeight", p));
        marginTop.ifPresent(p -> params.put("marginTop", p));
        marginBottom.ifPresent(p -> params.put("marginBottom", p));
        marginLeft.ifPresent(p -> params.put("marginLeft", p));
        marginRight.ifPresent(p -> params.put("marginRight", p));
        pageRanges.ifPresent(p -> params.put("pageRanges", p));
        ignoreInvalidPageRanges.ifPresent(p -> params.put("ignoreInvalidPageRanges", p));
        headerTemplate.ifPresent(p -> params.put("headerTemplate", p));
        footerTemplate.ifPresent(p -> params.put("footerTemplate", p));
        preferCSSPageSize.ifPresent(p -> params.put("preferCSSPageSize", p));
        transferMode.ifPresent(p -> params.put("transferMode", p));
        return new Command("Page.printToPDF", Map.copyOf(params), input -> (PrintToPDFResponse)input.read(PrintToPDFResponse.class));
    }

    public static Command<Void> reload(Optional<Boolean> ignoreCache, Optional<String> scriptToEvaluateOnLoad) {
        LinkedHashMap params = new LinkedHashMap();
        ignoreCache.ifPresent(p -> params.put("ignoreCache", p));
        scriptToEvaluateOnLoad.ifPresent(p -> params.put("scriptToEvaluateOnLoad", p));
        return new Command("Page.reload", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> removeScriptToEvaluateOnLoad(ScriptIdentifier identifier) {
        Objects.requireNonNull(identifier, "identifier is required");
        LinkedHashMap<String, ScriptIdentifier> params = new LinkedHashMap<String, ScriptIdentifier>();
        params.put("identifier", identifier);
        return new Command("Page.removeScriptToEvaluateOnLoad", Map.copyOf(params));
    }

    public static Command<Void> removeScriptToEvaluateOnNewDocument(ScriptIdentifier identifier) {
        Objects.requireNonNull(identifier, "identifier is required");
        LinkedHashMap<String, ScriptIdentifier> params = new LinkedHashMap<String, ScriptIdentifier>();
        params.put("identifier", identifier);
        return new Command("Page.removeScriptToEvaluateOnNewDocument", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> screencastFrameAck(Integer sessionId) {
        Objects.requireNonNull(sessionId, "sessionId is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("sessionId", sessionId);
        return new Command("Page.screencastFrameAck", Map.copyOf(params));
    }

    @Beta
    public static Command<List<SearchMatch>> searchInResource(FrameId frameId, String url, String query, Optional<Boolean> caseSensitive, Optional<Boolean> isRegex) {
        Objects.requireNonNull(frameId, "frameId is required");
        Objects.requireNonNull(url, "url is required");
        Objects.requireNonNull(query, "query is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("frameId", frameId);
        params.put("url", url);
        params.put("query", query);
        caseSensitive.ifPresent(p -> params.put("caseSensitive", p));
        isRegex.ifPresent(p -> params.put("isRegex", p));
        return new Command("Page.searchInResource", Map.copyOf(params), ConverterFunctions.map((String)"result", input -> input.readArray(SearchMatch.class)));
    }

    @Beta
    public static Command<Void> setAdBlockingEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("Page.setAdBlockingEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setBypassCSP(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("Page.setBypassCSP", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setDeviceMetricsOverride(Integer width, Integer height, Number deviceScaleFactor, Boolean mobile, Optional<Number> scale, Optional<Integer> screenWidth, Optional<Integer> screenHeight, Optional<Integer> positionX, Optional<Integer> positionY, Optional<Boolean> dontSetVisibleSize, Optional<ScreenOrientation> screenOrientation, Optional<Viewport> viewport) {
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        Objects.requireNonNull(deviceScaleFactor, "deviceScaleFactor is required");
        Objects.requireNonNull(mobile, "mobile is required");
        LinkedHashMap<String, Serializable> params = new LinkedHashMap<String, Serializable>();
        params.put("width", width);
        params.put("height", height);
        params.put("deviceScaleFactor", deviceScaleFactor);
        params.put("mobile", mobile);
        scale.ifPresent(p -> params.put("scale", (Serializable)p));
        screenWidth.ifPresent(p -> params.put("screenWidth", (Serializable)p));
        screenHeight.ifPresent(p -> params.put("screenHeight", (Serializable)p));
        positionX.ifPresent(p -> params.put("positionX", (Serializable)p));
        positionY.ifPresent(p -> params.put("positionY", (Serializable)p));
        dontSetVisibleSize.ifPresent(p -> params.put("dontSetVisibleSize", (Serializable)p));
        screenOrientation.ifPresent(p -> params.put("screenOrientation", (Serializable)p));
        viewport.ifPresent(p -> params.put("viewport", (Serializable)p));
        return new Command("Page.setDeviceMetricsOverride", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setDeviceOrientationOverride(Number alpha, Number beta, Number gamma) {
        Objects.requireNonNull(alpha, "alpha is required");
        Objects.requireNonNull(beta, "beta is required");
        Objects.requireNonNull(gamma, "gamma is required");
        LinkedHashMap<String, Number> params = new LinkedHashMap<String, Number>();
        params.put("alpha", alpha);
        params.put("beta", beta);
        params.put("gamma", gamma);
        return new Command("Page.setDeviceOrientationOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setFontFamilies(FontFamilies fontFamilies) {
        Objects.requireNonNull(fontFamilies, "fontFamilies is required");
        LinkedHashMap<String, FontFamilies> params = new LinkedHashMap<String, FontFamilies>();
        params.put("fontFamilies", fontFamilies);
        return new Command("Page.setFontFamilies", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setFontSizes(FontSizes fontSizes) {
        Objects.requireNonNull(fontSizes, "fontSizes is required");
        LinkedHashMap<String, FontSizes> params = new LinkedHashMap<String, FontSizes>();
        params.put("fontSizes", fontSizes);
        return new Command("Page.setFontSizes", Map.copyOf(params));
    }

    public static Command<Void> setDocumentContent(FrameId frameId, String html) {
        Objects.requireNonNull(frameId, "frameId is required");
        Objects.requireNonNull(html, "html is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("frameId", frameId);
        params.put("html", html);
        return new Command("Page.setDocumentContent", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setDownloadBehavior(SetDownloadBehaviorBehavior behavior, Optional<String> downloadPath) {
        Objects.requireNonNull(behavior, "behavior is required");
        LinkedHashMap<String, SetDownloadBehaviorBehavior> params = new LinkedHashMap<String, SetDownloadBehaviorBehavior>();
        params.put("behavior", behavior);
        downloadPath.ifPresent(p -> params.put("downloadPath", (SetDownloadBehaviorBehavior)((Object)p)));
        return new Command("Page.setDownloadBehavior", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> setGeolocationOverride(Optional<Number> latitude, Optional<Number> longitude, Optional<Number> accuracy) {
        LinkedHashMap params = new LinkedHashMap();
        latitude.ifPresent(p -> params.put("latitude", p));
        longitude.ifPresent(p -> params.put("longitude", p));
        accuracy.ifPresent(p -> params.put("accuracy", p));
        return new Command("Page.setGeolocationOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setLifecycleEventsEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("Page.setLifecycleEventsEnabled", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setTouchEmulationEnabled(Boolean enabled, Optional<SetTouchEmulationEnabledConfiguration> configuration) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        configuration.ifPresent(p -> params.put("configuration", (Boolean)p));
        return new Command("Page.setTouchEmulationEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> startScreencast(Optional<StartScreencastFormat> format, Optional<Integer> quality, Optional<Integer> maxWidth, Optional<Integer> maxHeight, Optional<Integer> everyNthFrame) {
        LinkedHashMap params = new LinkedHashMap();
        format.ifPresent(p -> params.put("format", p));
        quality.ifPresent(p -> params.put("quality", p));
        maxWidth.ifPresent(p -> params.put("maxWidth", p));
        maxHeight.ifPresent(p -> params.put("maxHeight", p));
        everyNthFrame.ifPresent(p -> params.put("everyNthFrame", p));
        return new Command("Page.startScreencast", Map.copyOf(params));
    }

    public static Command<Void> stopLoading() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.stopLoading", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> crash() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.crash", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> close() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.close", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setWebLifecycleState(SetWebLifecycleStateState state) {
        Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, SetWebLifecycleStateState> params = new LinkedHashMap<String, SetWebLifecycleStateState>();
        params.put("state", state);
        return new Command("Page.setWebLifecycleState", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> stopScreencast() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.stopScreencast", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setProduceCompilationCache(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("Page.setProduceCompilationCache", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> addCompilationCache(String url, String data) {
        Objects.requireNonNull(url, "url is required");
        Objects.requireNonNull(data, "data is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url);
        params.put("data", data);
        return new Command("Page.addCompilationCache", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> clearCompilationCache() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.clearCompilationCache", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> generateTestReport(String message, Optional<String> group) {
        Objects.requireNonNull(message, "message is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("message", message);
        group.ifPresent(p -> params.put("group", (String)p));
        return new Command("Page.generateTestReport", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> waitForDebugger() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Page.waitForDebugger", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setInterceptFileChooserDialog(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("Page.setInterceptFileChooserDialog", Map.copyOf(params));
    }

    public static Event<MonotonicTime> domContentEventFired() {
        return new Event("Page.domContentEventFired", ConverterFunctions.map((String)"timestamp", MonotonicTime.class));
    }

    public static Event<FileChooserOpened> fileChooserOpened() {
        return new Event("Page.fileChooserOpened", input -> (FileChooserOpened)input.read(FileChooserOpened.class));
    }

    public static Event<FrameAttached> frameAttached() {
        return new Event("Page.frameAttached", input -> (FrameAttached)input.read(FrameAttached.class));
    }

    public static Event<FrameId> frameClearedScheduledNavigation() {
        return new Event("Page.frameClearedScheduledNavigation", ConverterFunctions.map((String)"frameId", FrameId.class));
    }

    public static Event<FrameId> frameDetached() {
        return new Event("Page.frameDetached", ConverterFunctions.map((String)"frameId", FrameId.class));
    }

    public static Event<Frame> frameNavigated() {
        return new Event("Page.frameNavigated", ConverterFunctions.map((String)"frame", Frame.class));
    }

    public static Event<Void> frameResized() {
        return new Event("Page.frameResized", ConverterFunctions.empty());
    }

    public static Event<FrameRequestedNavigation> frameRequestedNavigation() {
        return new Event("Page.frameRequestedNavigation", input -> (FrameRequestedNavigation)input.read(FrameRequestedNavigation.class));
    }

    public static Event<FrameScheduledNavigation> frameScheduledNavigation() {
        return new Event("Page.frameScheduledNavigation", input -> (FrameScheduledNavigation)input.read(FrameScheduledNavigation.class));
    }

    public static Event<FrameId> frameStartedLoading() {
        return new Event("Page.frameStartedLoading", ConverterFunctions.map((String)"frameId", FrameId.class));
    }

    public static Event<FrameId> frameStoppedLoading() {
        return new Event("Page.frameStoppedLoading", ConverterFunctions.map((String)"frameId", FrameId.class));
    }

    public static Event<DownloadWillBegin> downloadWillBegin() {
        return new Event("Page.downloadWillBegin", input -> (DownloadWillBegin)input.read(DownloadWillBegin.class));
    }

    public static Event<DownloadProgress> downloadProgress() {
        return new Event("Page.downloadProgress", input -> (DownloadProgress)input.read(DownloadProgress.class));
    }

    public static Event<Void> interstitialHidden() {
        return new Event("Page.interstitialHidden", ConverterFunctions.empty());
    }

    public static Event<Void> interstitialShown() {
        return new Event("Page.interstitialShown", ConverterFunctions.empty());
    }

    public static Event<JavascriptDialogClosed> javascriptDialogClosed() {
        return new Event("Page.javascriptDialogClosed", input -> (JavascriptDialogClosed)input.read(JavascriptDialogClosed.class));
    }

    public static Event<JavascriptDialogOpening> javascriptDialogOpening() {
        return new Event("Page.javascriptDialogOpening", input -> (JavascriptDialogOpening)input.read(JavascriptDialogOpening.class));
    }

    public static Event<LifecycleEvent> lifecycleEvent() {
        return new Event("Page.lifecycleEvent", input -> (LifecycleEvent)input.read(LifecycleEvent.class));
    }

    public static Event<MonotonicTime> loadEventFired() {
        return new Event("Page.loadEventFired", ConverterFunctions.map((String)"timestamp", MonotonicTime.class));
    }

    public static Event<NavigatedWithinDocument> navigatedWithinDocument() {
        return new Event("Page.navigatedWithinDocument", input -> (NavigatedWithinDocument)input.read(NavigatedWithinDocument.class));
    }

    public static Event<ScreencastFrame> screencastFrame() {
        return new Event("Page.screencastFrame", input -> (ScreencastFrame)input.read(ScreencastFrame.class));
    }

    public static Event<Boolean> screencastVisibilityChanged() {
        return new Event("Page.screencastVisibilityChanged", ConverterFunctions.map((String)"visible", Boolean.class));
    }

    public static Event<WindowOpen> windowOpen() {
        return new Event("Page.windowOpen", input -> (WindowOpen)input.read(WindowOpen.class));
    }

    public static Event<CompilationCacheProduced> compilationCacheProduced() {
        return new Event("Page.compilationCacheProduced", input -> (CompilationCacheProduced)input.read(CompilationCacheProduced.class));
    }

    public static class PrintToPDFResponse {
        private final String data;
        private final Optional<StreamHandle> stream;

        public PrintToPDFResponse(String data, Optional<StreamHandle> stream) {
            this.data = Objects.requireNonNull(data, "data is required");
            this.stream = stream;
        }

        public String getData() {
            return this.data;
        }

        public Optional<StreamHandle> getStream() {
            return this.stream;
        }

        private static PrintToPDFResponse fromJson(JsonInput input) {
            String data = null;
            Optional<StreamHandle> stream = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "data": {
                        data = input.nextString();
                        continue block8;
                    }
                    case "stream": {
                        stream = Optional.ofNullable((StreamHandle)input.read(StreamHandle.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new PrintToPDFResponse(data, stream);
        }
    }

    public static class NavigateResponse {
        private final FrameId frameId;
        private final Optional<LoaderId> loaderId;
        private final Optional<String> errorText;

        public NavigateResponse(FrameId frameId, Optional<LoaderId> loaderId, Optional<String> errorText) {
            this.frameId = Objects.requireNonNull(frameId, "frameId is required");
            this.loaderId = loaderId;
            this.errorText = errorText;
        }

        public FrameId getFrameId() {
            return this.frameId;
        }

        public Optional<LoaderId> getLoaderId() {
            return this.loaderId;
        }

        public Optional<String> getErrorText() {
            return this.errorText;
        }

        private static NavigateResponse fromJson(JsonInput input) {
            FrameId frameId = null;
            Optional<LoaderId> loaderId = Optional.empty();
            Optional<String> errorText = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "frameId": {
                        frameId = (FrameId)input.read(FrameId.class);
                        continue block10;
                    }
                    case "loaderId": {
                        loaderId = Optional.ofNullable((LoaderId)input.read(LoaderId.class));
                        continue block10;
                    }
                    case "errorText": {
                        errorText = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new NavigateResponse(frameId, loaderId, errorText);
        }
    }

    public static class GetResourceContentResponse {
        private final String content;
        private final Boolean base64Encoded;

        public GetResourceContentResponse(String content, Boolean base64Encoded) {
            this.content = Objects.requireNonNull(content, "content is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getContent() {
            return this.content;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResourceContentResponse fromJson(JsonInput input) {
            String content = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "content": {
                        content = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResourceContentResponse(content, base64Encoded);
        }
    }

    public static class GetNavigationHistoryResponse {
        private final Integer currentIndex;
        private final List<NavigationEntry> entries;

        public GetNavigationHistoryResponse(Integer currentIndex, List<NavigationEntry> entries) {
            this.currentIndex = Objects.requireNonNull(currentIndex, "currentIndex is required");
            this.entries = Objects.requireNonNull(entries, "entries is required");
        }

        public Integer getCurrentIndex() {
            return this.currentIndex;
        }

        public List<NavigationEntry> getEntries() {
            return this.entries;
        }

        private static GetNavigationHistoryResponse fromJson(JsonInput input) {
            Integer currentIndex = 0;
            List entries = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "currentIndex": {
                        currentIndex = input.nextNumber().intValue();
                        continue block8;
                    }
                    case "entries": {
                        entries = input.readArray(NavigationEntry.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetNavigationHistoryResponse(currentIndex, entries);
        }
    }

    public static class GetLayoutMetricsResponse {
        private final LayoutViewport layoutViewport;
        private final VisualViewport visualViewport;
        private final Rect contentSize;

        public GetLayoutMetricsResponse(LayoutViewport layoutViewport, VisualViewport visualViewport, Rect contentSize) {
            this.layoutViewport = Objects.requireNonNull(layoutViewport, "layoutViewport is required");
            this.visualViewport = Objects.requireNonNull(visualViewport, "visualViewport is required");
            this.contentSize = Objects.requireNonNull(contentSize, "contentSize is required");
        }

        public LayoutViewport getLayoutViewport() {
            return this.layoutViewport;
        }

        public VisualViewport getVisualViewport() {
            return this.visualViewport;
        }

        public Rect getContentSize() {
            return this.contentSize;
        }

        private static GetLayoutMetricsResponse fromJson(JsonInput input) {
            LayoutViewport layoutViewport = null;
            VisualViewport visualViewport = null;
            Rect contentSize = null;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "layoutViewport": {
                        layoutViewport = (LayoutViewport)input.read(LayoutViewport.class);
                        continue block10;
                    }
                    case "visualViewport": {
                        visualViewport = (VisualViewport)input.read(VisualViewport.class);
                        continue block10;
                    }
                    case "contentSize": {
                        contentSize = (Rect)input.read(Rect.class);
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetLayoutMetricsResponse(layoutViewport, visualViewport, contentSize);
        }
    }

    public static class GetAppManifestResponse {
        private final String url;
        private final List<AppManifestError> errors;
        private final Optional<String> data;
        private final Optional<AppManifestParsedProperties> parsed;

        public GetAppManifestResponse(String url, List<AppManifestError> errors, Optional<String> data, Optional<AppManifestParsedProperties> parsed) {
            this.url = Objects.requireNonNull(url, "url is required");
            this.errors = Objects.requireNonNull(errors, "errors is required");
            this.data = data;
            this.parsed = parsed;
        }

        public String getUrl() {
            return this.url;
        }

        public List<AppManifestError> getErrors() {
            return this.errors;
        }

        public Optional<String> getData() {
            return this.data;
        }

        public Optional<AppManifestParsedProperties> getParsed() {
            return this.parsed;
        }

        private static GetAppManifestResponse fromJson(JsonInput input) {
            String url = null;
            List errors = null;
            Optional<String> data = Optional.empty();
            Optional<AppManifestParsedProperties> parsed = Optional.empty();
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "url": {
                        url = input.nextString();
                        continue block12;
                    }
                    case "errors": {
                        errors = input.readArray(AppManifestError.class);
                        continue block12;
                    }
                    case "data": {
                        data = Optional.ofNullable(input.nextString());
                        continue block12;
                    }
                    case "parsed": {
                        parsed = Optional.ofNullable((AppManifestParsedProperties)input.read(AppManifestParsedProperties.class));
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetAppManifestResponse(url, errors, data, parsed);
        }
    }

    public static enum SetWebLifecycleStateState {
        FROZEN("frozen"),
        ACTIVE("active");

        private String value;

        private SetWebLifecycleStateState(String value) {
            this.value = value;
        }

        public static SetWebLifecycleStateState fromString(String s) {
            return Arrays.stream(SetWebLifecycleStateState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetWebLifecycleStateState "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetWebLifecycleStateState fromJson(JsonInput input) {
            return SetWebLifecycleStateState.fromString(input.nextString());
        }
    }

    public static enum StartScreencastFormat {
        JPEG("jpeg"),
        PNG("png");

        private String value;

        private StartScreencastFormat(String value) {
            this.value = value;
        }

        public static StartScreencastFormat fromString(String s) {
            return Arrays.stream(StartScreencastFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within StartScreencastFormat "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static StartScreencastFormat fromJson(JsonInput input) {
            return StartScreencastFormat.fromString(input.nextString());
        }
    }

    public static enum SetTouchEmulationEnabledConfiguration {
        MOBILE("mobile"),
        DESKTOP("desktop");

        private String value;

        private SetTouchEmulationEnabledConfiguration(String value) {
            this.value = value;
        }

        public static SetTouchEmulationEnabledConfiguration fromString(String s) {
            return Arrays.stream(SetTouchEmulationEnabledConfiguration.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetTouchEmulationEnabledConfiguration "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetTouchEmulationEnabledConfiguration fromJson(JsonInput input) {
            return SetTouchEmulationEnabledConfiguration.fromString(input.nextString());
        }
    }

    public static enum SetDownloadBehaviorBehavior {
        DENY("deny"),
        ALLOW("allow"),
        DEFAULT("default");

        private String value;

        private SetDownloadBehaviorBehavior(String value) {
            this.value = value;
        }

        public static SetDownloadBehaviorBehavior fromString(String s) {
            return Arrays.stream(SetDownloadBehaviorBehavior.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetDownloadBehaviorBehavior "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetDownloadBehaviorBehavior fromJson(JsonInput input) {
            return SetDownloadBehaviorBehavior.fromString(input.nextString());
        }
    }

    public static enum PrintToPDFTransferMode {
        RETURNASBASE64("ReturnAsBase64"),
        RETURNASSTREAM("ReturnAsStream");

        private String value;

        private PrintToPDFTransferMode(String value) {
            this.value = value;
        }

        public static PrintToPDFTransferMode fromString(String s) {
            return Arrays.stream(PrintToPDFTransferMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within PrintToPDFTransferMode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static PrintToPDFTransferMode fromJson(JsonInput input) {
            return PrintToPDFTransferMode.fromString(input.nextString());
        }
    }

    public static enum CaptureSnapshotFormat {
        MHTML("mhtml");

        private String value;

        private CaptureSnapshotFormat(String value) {
            this.value = value;
        }

        public static CaptureSnapshotFormat fromString(String s) {
            return Arrays.stream(CaptureSnapshotFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CaptureSnapshotFormat "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static CaptureSnapshotFormat fromJson(JsonInput input) {
            return CaptureSnapshotFormat.fromString(input.nextString());
        }
    }

    public static enum CaptureScreenshotFormat {
        JPEG("jpeg"),
        PNG("png");

        private String value;

        private CaptureScreenshotFormat(String value) {
            this.value = value;
        }

        public static CaptureScreenshotFormat fromString(String s) {
            return Arrays.stream(CaptureScreenshotFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CaptureScreenshotFormat "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static CaptureScreenshotFormat fromJson(JsonInput input) {
            return CaptureScreenshotFormat.fromString(input.nextString());
        }
    }
}

