/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie;

public class Cookie
implements Serializable {
    private final ClientCookie httpClientCookie_;

    public Cookie(String domain, String name, String value) {
        this(domain, name, value, null, null, false);
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        this(domain, name, value, path, expires, secure, false, null);
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure, boolean httpOnly) {
        this(domain, name, value, path, expires, secure, httpOnly, null);
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure, boolean httpOnly, String sameSite) {
        if (domain == null) {
            throw new IllegalArgumentException("Cookie domain must be specified");
        }
        BasicClientCookie cookie = new BasicClientCookie(name, value == null ? "" : value);
        cookie.setDomain(domain);
        cookie.setAttribute("domain", domain);
        cookie.setPath(path);
        if (expires != null) {
            cookie.setExpiryDate(expires);
        }
        cookie.setSecure(secure);
        if (httpOnly) {
            cookie.setAttribute("httponly", "true");
        }
        if (sameSite != null) {
            cookie.setAttribute("samesite", sameSite);
        }
        this.httpClientCookie_ = cookie;
    }

    public Cookie(ClientCookie clientCookie) {
        this.httpClientCookie_ = clientCookie;
    }

    public Cookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        this(domain, name, value, path, Cookie.convertToExpiryDate(maxAge), secure);
    }

    private static Date convertToExpiryDate(int maxAge) {
        if (maxAge < -1) {
            throw new IllegalArgumentException("invalid max age:  " + maxAge);
        }
        if (maxAge >= 0) {
            return new Date(System.currentTimeMillis() + (long)maxAge * 1000L);
        }
        return null;
    }

    public String getName() {
        return this.httpClientCookie_.getName();
    }

    public String getValue() {
        return this.httpClientCookie_.getValue();
    }

    public String getDomain() {
        return this.httpClientCookie_.getDomain();
    }

    public String getPath() {
        return this.httpClientCookie_.getPath();
    }

    public Date getExpires() {
        return this.httpClientCookie_.getExpiryDate();
    }

    public boolean isSecure() {
        return this.httpClientCookie_.isSecure();
    }

    public boolean isHttpOnly() {
        return this.httpClientCookie_.getAttribute("httponly") != null;
    }

    public String getSameSite() {
        return this.httpClientCookie_.getAttribute("samesite");
    }

    public String toString() {
        return this.getName() + "=" + this.getValue() + (this.getDomain() == null ? "" : ";domain=" + this.getDomain()) + (this.getPath() == null ? "" : ";path=" + this.getPath()) + (this.getExpires() == null ? "" : ";expires=" + this.getExpires()) + (this.isSecure() ? ";secure" : "") + (this.isHttpOnly() ? ";httpOnly" : "") + (this.getSameSite() == null ? "" : ";sameSite=" + this.getSameSite());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie other = (Cookie)o;
        String path = this.getPath() == null ? "/" : this.getPath();
        String otherPath = other.getPath() == null ? "/" : other.getPath();
        return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getDomain(), (Object)other.getDomain()).append((Object)path, (Object)otherPath).isEquals();
    }

    public int hashCode() {
        String path = this.getPath() == null ? "/" : this.getPath();
        return new HashCodeBuilder().append((Object)this.getName()).append((Object)this.getDomain()).append((Object)path).toHashCode();
    }

    public org.apache.http.cookie.Cookie toHttpClient() {
        return this.httpClientCookie_;
    }

    public static List<org.apache.http.cookie.Cookie> toHttpClient(Collection<Cookie> cookies) {
        ArrayList<org.apache.http.cookie.Cookie> array = new ArrayList<org.apache.http.cookie.Cookie>(cookies.size());
        for (Cookie cookie : cookies) {
            array.add(cookie.toHttpClient());
        }
        return array;
    }

    public static List<Cookie> fromHttpClient(List<org.apache.http.cookie.Cookie> cookies) {
        ArrayList<Cookie> list = new ArrayList<Cookie>(cookies.size());
        for (org.apache.http.cookie.Cookie c : cookies) {
            list.add(new Cookie((ClientCookie)c));
        }
        return list;
    }
}

